/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.log;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.jetty.util.Loader;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.log.LoggerLog;
import org.eclipse.jetty.util.log.StdErrLog;

public class Log {
    public static final String EXCEPTION = "EXCEPTION ";
    public static final String IGNORED = "IGNORED ";
    protected static final Properties __props;
    public static String __logClass;
    public static boolean __ignored;
    private static final ConcurrentMap<String, Logger> __loggers;
    private static Logger LOG;
    private static boolean __initialized;

    private static void safeCloseInputStream(InputStream in) {
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (IOException e) {
            LOG.ignore(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean initialized() {
        if (LOG != null) {
            return true;
        }
        Class<Log> clazz = Log.class;
        synchronized (Log.class) {
            if (__initialized) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return LOG != null;
            }
            __initialized = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            try {
                Class log_class = Loader.loadClass(Log.class, __logClass);
                if (LOG == null || !LOG.getClass().equals(log_class)) {
                    LOG = (Logger)log_class.newInstance();
                    LOG.debug("Logging to {} via {}", LOG, log_class.getName());
                }
            }
            catch (Throwable e) {
                Log.initStandardLogging(e);
            }
            return LOG != null;
        }
    }

    private static void initStandardLogging(Throwable e) {
        if (e != null && __ignored) {
            e.printStackTrace();
        }
        if (LOG == null) {
            Class<StdErrLog> log_class = StdErrLog.class;
            LOG = new StdErrLog();
            LOG.debug("Logging to {} via {}", LOG, log_class.getName());
        }
    }

    public static Logger getLog() {
        Log.initialized();
        return LOG;
    }

    public static void setLog(Logger log) {
        LOG = log;
    }

    public static Logger getRootLogger() {
        Log.initialized();
        return LOG;
    }

    static boolean isIgnored() {
        return __ignored;
    }

    public static void setLogToParent(String name) {
        ClassLoader loader = Log.class.getClassLoader();
        if (loader != null && loader.getParent() != null) {
            try {
                Class<?> uberlog = loader.getParent().loadClass("org.eclipse.jetty.util.log.Log");
                Method getLogger = uberlog.getMethod("getLogger", String.class);
                Object logger = getLogger.invoke(null, name);
                Log.setLog(new LoggerLog(logger));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            Log.setLog(Log.getLogger(name));
        }
    }

    public static Logger getLogger(Class<?> clazz) {
        return Log.getLogger(clazz.getName());
    }

    public static Logger getLogger(String name) {
        if (!Log.initialized()) {
            IllegalStateException e = new IllegalStateException();
            e.printStackTrace();
            throw e;
        }
        if (name == null) {
            return LOG;
        }
        Logger logger = (Logger)__loggers.get(name);
        if (logger == null) {
            logger = LOG.getLogger(name);
        }
        return logger;
    }

    static ConcurrentMap<String, Logger> getMutableLoggers() {
        return __loggers;
    }

    @ManagedAttribute(value="list of all instantiated loggers")
    public static Map<String, Logger> getLoggers() {
        return Collections.unmodifiableMap(__loggers);
    }

    static {
        __loggers = new ConcurrentHashMap<String, Logger>();
        __props = new Properties();
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() {
                URL testProps = Loader.getResource(Log.class, "jetty-logging.properties");
                if (testProps != null) {
                    InputStream in = null;
                    try {
                        in = testProps.openStream();
                        __props.load(in);
                    }
                    catch (IOException e) {
                        System.err.println("Unable to load " + testProps);
                        e.printStackTrace(System.err);
                    }
                    finally {
                        Log.safeCloseInputStream(in);
                    }
                }
                Enumeration<?> systemKeyEnum = System.getProperties().propertyNames();
                while (systemKeyEnum.hasMoreElements()) {
                    String key = (String)systemKeyEnum.nextElement();
                    String val = System.getProperty(key);
                    if (val == null) continue;
                    __props.setProperty(key, val);
                }
                __logClass = __props.getProperty("org.eclipse.jetty.util.log.class", "org.eclipse.jetty.util.log.Slf4jLog");
                __ignored = Boolean.parseBoolean(__props.getProperty("org.eclipse.jetty.util.log.IGNORED", "false"));
                return null;
            }
        });
    }
}

