/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.server.io;

import java.io.File;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.WriteResult;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.http.HttpHeader;
import org.glassfish.grizzly.http.io.OutputBuffer;
import org.glassfish.grizzly.http.server.Response;

public class ServerOutputBuffer
extends OutputBuffer {
    private Response serverResponse;

    public void initialize(Response response, FilterChainContext ctx) {
        super.initialize((HttpHeader)response.getResponse(), response.isSendFileEnabled(), ctx);
        this.serverResponse = response;
    }

    public void sendfile(File file, long offset, long length, CompletionHandler<WriteResult> handler) {
        if (!this.sendfileEnabled) {
            throw new IllegalStateException("sendfile support isn't available.");
        }
        boolean suspendedAtStart = this.serverResponse.isSuspended();
        CompletionHandler<WriteResult> ch = suspendedAtStart && handler != null ? handler : (!suspendedAtStart && handler != null ? this.suspendAndCreateHandler(handler) : this.createInternalCompletionHandler(file, suspendedAtStart));
        super.sendfile(file, offset, length, ch);
    }

    public void recycle() {
        this.serverResponse = null;
        super.recycle();
    }

    protected Executor getThreadPool() {
        return this.serverResponse.getRequest().getRequestExecutor();
    }

    private CompletionHandler<WriteResult> createInternalCompletionHandler(final File file, boolean suspendedAtStart) {
        if (!suspendedAtStart) {
            this.serverResponse.suspend();
        }
        CompletionHandler<WriteResult> ch = new CompletionHandler<WriteResult>(){

            public void cancelled() {
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, "Transfer of file {0} was cancelled.", file.getAbsolutePath());
                }
                ServerOutputBuffer.this.serverResponse.resume();
            }

            public void failed(Throwable throwable) {
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.log(Level.SEVERE, String.format("Failed to transfer file %s.  Cause: %s.", file.getAbsolutePath(), throwable.getMessage()), throwable);
                }
                ServerOutputBuffer.this.serverResponse.resume();
            }

            public void completed(WriteResult result) {
                ServerOutputBuffer.this.serverResponse.resume();
            }

            public void updated(WriteResult result) {
            }
        };
        return ch;
    }

    private CompletionHandler<WriteResult> suspendAndCreateHandler(final CompletionHandler<WriteResult> handler) {
        this.serverResponse.suspend();
        return new CompletionHandler<WriteResult>(){

            public void cancelled() {
                handler.cancelled();
                ServerOutputBuffer.this.serverResponse.resume();
            }

            public void failed(Throwable throwable) {
                handler.failed(throwable);
                ServerOutputBuffer.this.serverResponse.resume();
            }

            public void completed(WriteResult result) {
                handler.completed((Object)result);
                ServerOutputBuffer.this.serverResponse.resume();
            }

            public void updated(WriteResult result) {
                handler.updated((Object)result);
            }
        };
    }
}

