/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.rebalancer.strategy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.helix.controller.common.CapacityNode;
import org.apache.helix.controller.dataproviders.ResourceControllerDataProvider;
import org.apache.helix.controller.rebalancer.strategy.RebalanceStrategy;
import org.apache.helix.zookeeper.datamodel.ZNRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GreedyRebalanceStrategy
implements RebalanceStrategy<ResourceControllerDataProvider> {
    private static Logger logger = LoggerFactory.getLogger(GreedyRebalanceStrategy.class);
    private String _resourceName;
    private List<String> _partitions;
    private LinkedHashMap<String, Integer> _states;

    @Override
    public void init(String resourceName, List<String> partitions, LinkedHashMap<String, Integer> states, int maximumPerNode) {
        this._resourceName = resourceName;
        this._partitions = partitions;
        this._states = states;
    }

    @Override
    public ZNRecord computePartitionAssignment(List<String> allNodes, List<String> liveNodes, Map<String, Map<String, String>> currentMapping, ResourceControllerDataProvider clusterData) {
        int numReplicas = this.countStateReplicas();
        ZNRecord znRecord = new ZNRecord(this._resourceName);
        if (liveNodes.size() == 0) {
            return znRecord;
        }
        if (clusterData.getSimpleCapacitySet() == null) {
            logger.warn("No capacity set for resource: " + this._resourceName);
            return znRecord;
        }
        ArrayList<CapacityNode> assignableNodes = new ArrayList<CapacityNode>(clusterData.getSimpleCapacitySet());
        Collections.sort(assignableNodes, Comparator.comparing(CapacityNode::getId));
        int index = 0;
        for (int i = 0; i < this._partitions.size(); ++i) {
            int startIndex = index;
            ArrayList<String> preferenceList = new ArrayList<String>();
            for (int j = 0; j < numReplicas; ++j) {
                while (index - startIndex < assignableNodes.size()) {
                    CapacityNode node;
                    if (!(node = (CapacityNode)assignableNodes.get(index++ % assignableNodes.size())).canAdd(this._resourceName, this._partitions.get(i))) continue;
                    preferenceList.add(node.getId());
                    break;
                }
                if (index - startIndex < assignableNodes.size()) continue;
                logger.warn("No enough assignable nodes for resource: " + this._resourceName);
            }
            znRecord.setListField(this._partitions.get(i), preferenceList);
        }
        return znRecord;
    }

    private int countStateReplicas() {
        int total = 0;
        for (Integer count : this._states.values()) {
            total += count.intValue();
        }
        return total;
    }
}

