/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.tools.commandtools;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.zip.GZIPInputStream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.FileUtils;
import org.apache.helix.tools.commandtools.ZKLogFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkGrep {
    private static Logger LOG = LoggerFactory.getLogger(ZkGrep.class);
    private static final String zkCfg = "zkCfg";
    private static final String pattern = "pattern";
    private static final String by = "by";
    private static final String between = "between";
    public static final String log = "log";
    public static final String snapshot = "snapshot";
    private static final String gzSuffix = ".gz";

    private static Options constructCommandLineOptions() {
        OptionBuilder.hasArgs((int)1);
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withLongOpt((String)zkCfg);
        OptionBuilder.withArgName((String)"zoo.cfg");
        OptionBuilder.withDescription((String)"provide zoo.cfg");
        Option zkCfgOption = OptionBuilder.create();
        OptionBuilder.hasArgs();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withLongOpt((String)pattern);
        OptionBuilder.withArgName((String)"grep-patterns...");
        OptionBuilder.withDescription((String)"provide patterns (required)");
        Option patternOption = OptionBuilder.create();
        OptionBuilder.hasArgs((int)2);
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withLongOpt((String)between);
        OptionBuilder.withArgName((String)"t1 t2 (timestamp in ms or yyMMdd_hhmmss_SSS)");
        OptionBuilder.withDescription((String)"grep between t1 and t2");
        Option betweenOption = OptionBuilder.create();
        OptionBuilder.hasArgs((int)1);
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withLongOpt((String)by);
        OptionBuilder.withArgName((String)"t (timestamp in ms or yyMMdd_hhmmss_SSS)");
        OptionBuilder.withDescription((String)"grep by t");
        Option byOption = OptionBuilder.create();
        OptionGroup group = new OptionGroup();
        group.setRequired(true);
        group.addOption(betweenOption);
        group.addOption(byOption);
        Options options = new Options();
        options.addOption(zkCfgOption);
        options.addOption(patternOption);
        options.addOptionGroup(group);
        return options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String[] getZkDataDirs(String zkCfgFile) {
        String[] zkDirs = new String[2];
        FileInputStream fis = null;
        BufferedReader br = null;
        try {
            String line;
            fis = new FileInputStream(zkCfgFile);
            br = new BufferedReader(new InputStreamReader(fis));
            while ((line = br.readLine()) != null) {
                String key = "dataDir=";
                if (line.startsWith(key)) {
                    zkDirs[1] = zkDirs[0] = line.substring(key.length()) + "/version-2";
                }
                if (!line.startsWith(key = "dataLogDir=")) continue;
                zkDirs[0] = line.substring(key.length()) + "/version-2";
            }
        }
        catch (Exception e) {
            LOG.error("exception in read file: " + zkCfgFile, (Throwable)e);
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception e) {
                LOG.error("exception in closing file: " + zkCfgFile, (Throwable)e);
            }
        }
        return zkDirs;
    }

    static void printFiles(File[] files) {
        System.out.println("START print");
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            System.out.println(file.getName() + ", " + file.lastModified());
        }
        System.out.println("END print");
    }

    static File[] getSortedFiles(String dirPath, final String pattern) {
        File dir = new File(dirPath);
        File[] files = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isFile() && file.getName().indexOf(pattern) != -1;
            }
        });
        Arrays.sort(files, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                int sign = (int)Math.signum(o1.lastModified() - o2.lastModified());
                return sign;
            }
        });
        return files;
    }

    static String getAttributeValue(String line, String attribute) {
        String[] parts;
        if (line == null) {
            return null;
        }
        if (!((String)attribute).endsWith(":")) {
            attribute = (String)attribute + ":";
        }
        if ((parts = line.split("\\s")) != null && parts.length > 0) {
            for (int i = 0; i < parts.length; ++i) {
                if (!parts[i].startsWith((String)attribute)) continue;
                String val = parts[i].substring(((String)attribute).length());
                return val;
            }
        }
        return null;
    }

    static long getTimestamp(String line) {
        String timestamp = ZkGrep.getAttributeValue(line, "time");
        return Long.parseLong(timestamp);
    }

    static long parseTimeString(String time) {
        try {
            return Long.parseLong(time);
        }
        catch (NumberFormatException e) {
            try {
                SimpleDateFormat formatter = new SimpleDateFormat("yyMMdd_hhmmss_SSS");
                Date date = formatter.parse(time);
                return date.getTime();
            }
            catch (java.text.ParseException ex) {
                LOG.error("fail to parse time string: " + time, (Throwable)e);
                return -1L;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void grepZkLog(File zkLog, long start, long end, String ... patterns) {
        FileInputStream fis = null;
        BufferedReader br = null;
        try {
            String line;
            fis = new FileInputStream(zkLog);
            br = new BufferedReader(new InputStreamReader(fis));
            while ((line = br.readLine()) != null) {
                try {
                    long timestamp = ZkGrep.getTimestamp(line);
                    if (timestamp > end) {
                        break;
                    }
                    if (timestamp < start) continue;
                    boolean match = true;
                    for (String pattern : patterns) {
                        if (line.indexOf(pattern) != -1) continue;
                        match = false;
                        break;
                    }
                    if (!match) continue;
                    System.out.println(line);
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        catch (Exception e) {
            LOG.error("exception in grep zk-log: " + zkLog, (Throwable)e);
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception e) {
                LOG.error("exception in closing zk-log: " + zkLog, (Throwable)e);
            }
        }
    }

    public static void grepZkLogDir(List<File> parsedZkLogs, long start, long end, String ... patterns) {
        for (File file : parsedZkLogs) {
            ZkGrep.grepZkLog(file, start, end, patterns);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void grepZkSnapshot(File zkSnapshot, String ... patterns) {
        FileInputStream fis = null;
        BufferedReader br = null;
        try {
            String line;
            fis = new FileInputStream(zkSnapshot);
            br = new BufferedReader(new InputStreamReader(fis));
            while ((line = br.readLine()) != null) {
                try {
                    boolean match = true;
                    for (String pattern : patterns) {
                        if (line.indexOf(pattern) != -1) continue;
                        match = false;
                        break;
                    }
                    if (!match) continue;
                    System.out.println(line);
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        catch (Exception e) {
            LOG.error("exception in grep zk-snapshot: " + zkSnapshot, (Throwable)e);
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception e) {
                LOG.error("exception in closing zk-snapshot: " + zkSnapshot, (Throwable)e);
            }
        }
    }

    static String guessZkCfgDir() {
        return null;
    }

    public static void printUsage(Options cliOptions) {
        HelpFormatter helpFormatter = new HelpFormatter();
        helpFormatter.setWidth(1000);
        helpFormatter.printHelp("java " + ZkGrep.class.getName(), cliOptions);
    }

    static List<File> parseZkLogs(String zkLogDir, long start, long end) {
        File zkParsedDir = new File(String.format("%s/zklog-parsed", System.getProperty("user.home")));
        File[] zkLogs = ZkGrep.getSortedFiles(zkLogDir, log);
        ArrayList<File> parsedZkLogs = new ArrayList<File>();
        boolean stop = false;
        for (File zkLog : zkLogs) {
            if (stop) break;
            if (zkLog.lastModified() < start) continue;
            if (zkLog.lastModified() > end) {
                stop = true;
            }
            try {
                File parsedZkLog = new File(zkParsedDir, ZkGrep.stripGzSuffix(zkLog.getName()) + ".parsed");
                if (!parsedZkLog.exists() || parsedZkLog.lastModified() <= zkLog.lastModified()) {
                    if (zkLog.getName().endsWith(gzSuffix)) {
                        FileUtils.copyFileToDirectory((File)zkLog, (File)zkParsedDir);
                        File zkLogGz = new File(zkParsedDir, zkLog.getName());
                        File tmpZkLog = ZkGrep.gunzip(zkLogGz);
                        ZKLogFormatter.main(new String[]{log, tmpZkLog.getAbsolutePath(), parsedZkLog.getAbsolutePath()});
                        zkLogGz.delete();
                        tmpZkLog.delete();
                    } else {
                        ZKLogFormatter.main(new String[]{log, zkLog.getAbsolutePath(), parsedZkLog.getAbsolutePath()});
                    }
                }
                parsedZkLogs.add(parsedZkLog);
            }
            catch (Exception e) {
                LOG.error("fail to parse zkLog: " + zkLog, (Throwable)e);
            }
        }
        return parsedZkLogs;
    }

    static String stripGzSuffix(String filename) {
        if (filename.endsWith(gzSuffix)) {
            return filename.substring(0, filename.length() - gzSuffix.length());
        }
        return filename;
    }

    static File gunzip(File zipFile) {
        File outputFile = new File(ZkGrep.stripGzSuffix(zipFile.getAbsolutePath()));
        byte[] buffer = new byte[1024];
        try {
            int len;
            GZIPInputStream gzis = new GZIPInputStream(new FileInputStream(zipFile));
            FileOutputStream out = new FileOutputStream(outputFile);
            while ((len = gzis.read(buffer)) > 0) {
                out.write(buffer, 0, len);
            }
            gzis.close();
            out.close();
            return outputFile;
        }
        catch (IOException e) {
            LOG.error("fail to gunzip file: " + zipFile, (Throwable)e);
            return null;
        }
    }

    static File[] parseZkSnapshot(String zkSnapshotDir, long byTime) {
        File zkSnapshot;
        File[] retFiles = new File[2];
        File zkParsedDir = new File(String.format("%s/zklog-parsed", System.getProperty("user.home")));
        File[] zkSnapshots = ZkGrep.getSortedFiles(zkSnapshotDir, snapshot);
        File lastZkSnapshot = null;
        for (int i = 0; i < zkSnapshots.length && (zkSnapshot = zkSnapshots[i]).lastModified() < byTime; ++i) {
            retFiles[0] = lastZkSnapshot = zkSnapshot;
        }
        try {
            File parsedZkSnapshot = new File(zkParsedDir, ZkGrep.stripGzSuffix(lastZkSnapshot.getName()) + ".parsed");
            if (!parsedZkSnapshot.exists() || parsedZkSnapshot.lastModified() <= lastZkSnapshot.lastModified()) {
                if (lastZkSnapshot.getName().endsWith(gzSuffix)) {
                    FileUtils.copyFileToDirectory((File)lastZkSnapshot, (File)zkParsedDir);
                    File lastZkSnapshotGz = new File(zkParsedDir, lastZkSnapshot.getName());
                    File tmpLastZkSnapshot = ZkGrep.gunzip(lastZkSnapshotGz);
                    ZKLogFormatter.main(new String[]{snapshot, tmpLastZkSnapshot.getAbsolutePath(), parsedZkSnapshot.getAbsolutePath()});
                    lastZkSnapshotGz.delete();
                    tmpLastZkSnapshot.delete();
                } else {
                    ZKLogFormatter.main(new String[]{snapshot, lastZkSnapshot.getAbsolutePath(), parsedZkSnapshot.getAbsolutePath()});
                }
            }
            retFiles[1] = parsedZkSnapshot;
            return retFiles;
        }
        catch (Exception e) {
            LOG.error("fail to parse zkSnapshot: " + lastZkSnapshot, (Throwable)e);
            return null;
        }
    }

    public static void processCommandLineArgs(String[] cliArgs) {
        File zkParsedDir;
        GnuParser cliParser = new GnuParser();
        Options cliOptions = ZkGrep.constructCommandLineOptions();
        CommandLine cmd = null;
        try {
            cmd = cliParser.parse(cliOptions, cliArgs);
        }
        catch (ParseException pe) {
            System.err.println("CommandLineClient: failed to parse command-line options: " + pe);
            ZkGrep.printUsage(cliOptions);
            System.exit(1);
        }
        String zkCfgDirValue = null;
        Object zkCfgFile = null;
        if (cmd.hasOption(zkCfg)) {
            zkCfgDirValue = cmd.getOptionValue(zkCfg);
        }
        if (zkCfgDirValue == null) {
            zkCfgDirValue = ZkGrep.guessZkCfgDir();
        }
        if (zkCfgDirValue == null) {
            LOG.error("couldn't figure out path to zkCfg file");
            System.exit(1);
        }
        if (!((String)(zkCfgFile = zkCfgDirValue)).endsWith(".cfg")) {
            zkCfgFile = (String)zkCfgFile + "/zoo.cfg";
        }
        if (!new File((String)zkCfgFile).exists()) {
            LOG.error("zoo.cfg file doen't exist: " + (String)zkCfgFile);
            System.exit(1);
        }
        String[] patterns = cmd.getOptionValues(pattern);
        String[] zkDataDirs = ZkGrep.getZkDataDirs((String)zkCfgFile);
        if (zkDataDirs == null || zkDataDirs[0] == null || zkDataDirs[1] == null) {
            LOG.error("invalid zkCfgDir: " + zkCfgDirValue);
            System.exit(1);
        }
        if (!(zkParsedDir = new File(String.format("%s/zklog-parsed", System.getProperty("user.home")))).exists()) {
            LOG.info("creating zklog-parsed dir: " + zkParsedDir.getAbsolutePath());
            zkParsedDir.mkdirs();
        }
        if (cmd.hasOption(between)) {
            long endTime;
            String[] timeStrings = cmd.getOptionValues(between);
            long startTime = ZkGrep.parseTimeString(timeStrings[0]);
            if (startTime == -1L) {
                LOG.error("invalid start time string: " + timeStrings[0] + ", should be either timestamp or yyMMdd_hhmmss_SSS");
                System.exit(1);
            }
            if ((endTime = ZkGrep.parseTimeString(timeStrings[1])) == -1L) {
                LOG.error("invalid end time string: " + timeStrings[1] + ", should be either timestamp or yyMMdd_hhmmss_SSS");
                System.exit(1);
            }
            if (startTime > endTime) {
                LOG.warn("empty window: " + startTime + " - " + endTime);
                System.exit(1);
            }
            List<File> parsedZkLogs = ZkGrep.parseZkLogs(zkDataDirs[0], startTime, endTime);
            ZkGrep.grepZkLogDir(parsedZkLogs, startTime, endTime, patterns);
        } else if (cmd.hasOption(by)) {
            String timeString = cmd.getOptionValue(by);
            long byTime = ZkGrep.parseTimeString(timeString);
            if (byTime == -1L) {
                LOG.error("invalid by time string: " + timeString + ", should be either timestamp or yyMMdd_hhmmss_SSS");
                System.exit(1);
            }
            File[] lastZkSnapshot = ZkGrep.parseZkSnapshot(zkDataDirs[1], byTime);
            ZkGrep.grepZkSnapshot(lastZkSnapshot[1], patterns);
            long startTime = lastZkSnapshot[0].lastModified();
            List<File> parsedZkLogs = ZkGrep.parseZkLogs(zkDataDirs[0], startTime, byTime);
            ZkGrep.grepZkLogDir(parsedZkLogs, startTime, byTime, patterns);
        }
    }

    public static void main(String[] args) {
        ZkGrep.processCommandLineArgs(args);
    }
}

