/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.zookeeper.datamodel;

import java.util.HashMap;
import java.util.Map;
import org.apache.helix.zookeeper.datamodel.ZNRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZNRecordBucketizer {
    private static Logger LOG = LoggerFactory.getLogger(ZNRecordBucketizer.class);
    final int _bucketSize;

    public ZNRecordBucketizer(int bucketSize) {
        if (bucketSize <= 0) {
            LOG.debug("bucketSize <= 0 (was " + bucketSize + "). Set to 0 to use non-bucketized HelixProperty.");
            bucketSize = 0;
        }
        this._bucketSize = bucketSize;
    }

    public String getBucketName(String key) {
        if (this._bucketSize == 0) {
            return null;
        }
        int idx = key.lastIndexOf(95);
        if (idx < 0) {
            throw new IllegalArgumentException("Could NOT find partition# in " + key + ". partitionName should be in format of resourceName_partition#");
        }
        try {
            int partitionNb = Integer.parseInt(key.substring(idx + 1));
            int bucketNb = partitionNb / this._bucketSize;
            int startPartition = bucketNb * this._bucketSize;
            int endPartition = bucketNb * this._bucketSize + (this._bucketSize - 1);
            return key.substring(0, idx) + "_p" + startPartition + "-p" + endPartition;
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Could NOT parse partition# (" + key.substring(idx + 1) + ") in " + key);
        }
    }

    public Map<String, ZNRecord> bucketize(ZNRecord record) {
        ZNRecord bucketizedRecord;
        String bucketName;
        HashMap<String, ZNRecord> map = new HashMap<String, ZNRecord>();
        if (this._bucketSize == 0) {
            map.put(record.getId(), record);
            return map;
        }
        for (String partitionName : record.getListFields().keySet()) {
            bucketName = this.getBucketName(partitionName);
            if (bucketName != null) {
                if (!map.containsKey(bucketName)) {
                    map.put(bucketName, new ZNRecord(bucketName));
                }
                bucketizedRecord = (ZNRecord)map.get(bucketName);
                bucketizedRecord.setListField(partitionName, record.getListField(partitionName));
                continue;
            }
            LOG.error("Can't bucketize " + partitionName + " in list field");
        }
        for (String partitionName : record.getMapFields().keySet()) {
            bucketName = this.getBucketName(partitionName);
            if (bucketName != null) {
                if (!map.containsKey(bucketName)) {
                    map.put(bucketName, new ZNRecord(bucketName));
                }
                bucketizedRecord = (ZNRecord)map.get(bucketName);
                bucketizedRecord.setMapField(partitionName, record.getMapField(partitionName));
                continue;
            }
            LOG.error("Can't bucketize " + partitionName + " in map field");
        }
        for (ZNRecord bucketizedRecord2 : map.values()) {
            bucketizedRecord2.setSimpleFields(record.getSimpleFields());
        }
        return map;
    }
}

