/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.rest.server.json.instance;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class StoppableCheck {
    @JsonProperty(value="stoppable")
    private boolean isStoppable;
    @JsonProperty(value="failedChecks")
    private List<String> failedChecks;

    public StoppableCheck(boolean isStoppable, List<String> failedChecks, Category category) {
        this.isStoppable = isStoppable;
        this.failedChecks = failedChecks.stream().sorted().map(checkName -> this.appendPrefix((String)checkName, category)).collect(Collectors.toList());
    }

    public StoppableCheck(Map<String, Boolean> checks, Category category) {
        this.failedChecks = Maps.filterValues(checks, Boolean.FALSE::equals).keySet().stream().sorted().map(checkName -> this.appendPrefix((String)checkName, category)).collect(Collectors.toList());
        this.isStoppable = this.failedChecks.isEmpty();
    }

    private String appendPrefix(String checkName, Category category) {
        return category.prefix + checkName;
    }

    public boolean isStoppable() {
        return this.isStoppable;
    }

    public List<String> getFailedChecks() {
        return this.failedChecks;
    }

    public void add(StoppableCheck other) {
        this.failedChecks.addAll(other.getFailedChecks());
        this.isStoppable = this.failedChecks.isEmpty();
    }

    public static enum Category {
        HELIX_OWN_CHECK("HELIX:"),
        CUSTOM_INSTANCE_CHECK("CUSTOM_INSTANCE_HEALTH_FAILURE:"),
        CUSTOM_PARTITION_CHECK("CUSTOM_PARTITION_HEALTH_FAILURE:");

        String prefix;

        private Category(String prefix) {
            this.prefix = prefix;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public static Set<Category> categorySetFromCommaSeperatedString(String categories) throws IllegalArgumentException {
            return Arrays.stream(categories.split(",")).map(Category::valueOf).collect(Collectors.toSet());
        }
    }
}

