/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.remoting.netty;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.protobuf.MessageLite;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.compression.ZlibCodecFactory;
import io.netty.handler.codec.compression.ZlibWrapper;
import io.netty.handler.codec.protobuf.ProtobufDecoder;
import io.netty.handler.codec.protobuf.ProtobufEncoder;
import io.netty.handler.codec.protobuf.ProtobufVarint32FrameDecoder;
import io.netty.handler.codec.protobuf.ProtobufVarint32LengthFieldPrepender;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.timeout.IdleStateHandler;
import java.util.List;
import java.util.concurrent.ThreadFactory;
import org.apache.hertzbeat.common.entity.message.ClusterMsg;
import org.apache.hertzbeat.common.support.CommonThreadPool;
import org.apache.hertzbeat.remoting.RemotingServer;
import org.apache.hertzbeat.remoting.event.NettyEventListener;
import org.apache.hertzbeat.remoting.netty.NettyHook;
import org.apache.hertzbeat.remoting.netty.NettyRemotingAbstract;
import org.apache.hertzbeat.remoting.netty.NettyServerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyRemotingServer
extends NettyRemotingAbstract
implements RemotingServer {
    private static final Logger log = LoggerFactory.getLogger(NettyRemotingServer.class);
    private final NettyServerConfig nettyServerConfig;
    private final CommonThreadPool threadPool;
    private EventLoopGroup bossGroup;
    private EventLoopGroup workerGroup;
    private Channel channel = null;

    public NettyRemotingServer(NettyServerConfig nettyServerConfig, NettyEventListener nettyEventListener, CommonThreadPool threadPool) {
        super(nettyEventListener);
        this.nettyServerConfig = nettyServerConfig;
        this.threadPool = threadPool;
    }

    @Override
    public void start() {
        this.threadPool.execute(() -> {
            int port = this.nettyServerConfig.getPort();
            ThreadFactory bossThreadFactory = new ThreadFactoryBuilder().setUncaughtExceptionHandler((thread, throwable) -> {
                log.error("NettyServerBoss has uncaughtException.");
                log.error(throwable.getMessage(), throwable);
            }).setDaemon(true).setNameFormat("netty-server-boss-%d").build();
            ThreadFactory workerThreadFactory = new ThreadFactoryBuilder().setUncaughtExceptionHandler((thread, throwable) -> {
                log.error("NettyServerWorker has uncaughtException.");
                log.error(throwable.getMessage(), throwable);
            }).setDaemon(true).setNameFormat("netty-server-worker-%d").build();
            if (this.useEpoll()) {
                this.bossGroup = new EpollEventLoopGroup(bossThreadFactory);
                this.workerGroup = new EpollEventLoopGroup(workerThreadFactory);
            } else {
                this.bossGroup = new NioEventLoopGroup(bossThreadFactory);
                this.workerGroup = new NioEventLoopGroup(workerThreadFactory);
            }
            try {
                ServerBootstrap b = new ServerBootstrap();
                ((ServerBootstrap)((ServerBootstrap)b.group(this.bossGroup, this.workerGroup).channel(this.useEpoll() ? EpollServerSocketChannel.class : NioServerSocketChannel.class)).handler((ChannelHandler)new LoggingHandler(LogLevel.INFO))).childOption(ChannelOption.TCP_NODELAY, (Object)true).childOption(ChannelOption.SO_KEEPALIVE, (Object)false).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                    protected void initChannel(SocketChannel channel) throws Exception {
                        NettyRemotingServer.this.initChannel(channel);
                    }
                });
                this.channel = b.bind(port).sync().channel();
                this.channel.closeFuture().sync();
            }
            catch (InterruptedException ignored) {
                log.info("server shutdown now!");
            }
            catch (Exception e) {
                log.error("Netty Server start exception, {}", (Object)e.getMessage());
                throw new RuntimeException(e);
            }
            finally {
                this.bossGroup.shutdownGracefully();
                this.workerGroup.shutdownGracefully();
            }
        });
    }

    @Override
    public boolean isStart() {
        return this.channel != null && this.channel.isActive();
    }

    private void initChannel(SocketChannel channel) {
        ChannelPipeline pipeline = channel.pipeline();
        pipeline.addLast(new ChannelHandler[]{ZlibCodecFactory.newZlibEncoder((ZlibWrapper)ZlibWrapper.GZIP)});
        pipeline.addLast(new ChannelHandler[]{ZlibCodecFactory.newZlibDecoder((ZlibWrapper)ZlibWrapper.GZIP)});
        pipeline.addLast(new ChannelHandler[]{new ProtobufVarint32FrameDecoder()});
        pipeline.addLast(new ChannelHandler[]{new ProtobufDecoder((MessageLite)ClusterMsg.Message.getDefaultInstance())});
        pipeline.addLast(new ChannelHandler[]{new ProtobufVarint32LengthFieldPrepender()});
        pipeline.addLast(new ChannelHandler[]{new ProtobufEncoder()});
        pipeline.addLast(new ChannelHandler[]{new IdleStateHandler(0, 0, this.nettyServerConfig.getIdleStateEventTriggerTime().intValue())});
        pipeline.addLast(new ChannelHandler[]{new NettyServerHandler()});
    }

    @Override
    public void shutdown() {
        try {
            this.bossGroup.shutdownGracefully();
            this.workerGroup.shutdownGracefully();
            this.threadPool.destroy();
        }
        catch (Exception e) {
            log.error("Netty Server shutdown exception, ", (Throwable)e);
        }
    }

    @Override
    public void sendMsg(Channel channel, ClusterMsg.Message request) {
        this.sendMsgImpl(channel, request);
    }

    @Override
    public ClusterMsg.Message sendMsgSync(Channel channel, ClusterMsg.Message request, int timeoutMillis) {
        return this.sendMsgSyncImpl(channel, request, timeoutMillis);
    }

    @Override
    public void registerHook(List<NettyHook> nettyHookList) {
        this.nettyHookList.addAll(nettyHookList);
    }

    @ChannelHandler.Sharable
    public class NettyServerHandler
    extends SimpleChannelInboundHandler<ClusterMsg.Message> {
        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            NettyRemotingServer.this.channelActive(ctx);
        }

        protected void channelRead0(ChannelHandlerContext ctx, ClusterMsg.Message msg) throws Exception {
            NettyRemotingServer.this.processReceiveMsg(ctx, msg);
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
            NettyRemotingServer.this.channelIdle(ctx, evt);
        }
    }
}

