/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.model.instance;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import org.apache.atlas.model.PList;
import org.apache.atlas.model.SearchFilter;
import org.apache.atlas.model.typedef.AtlasBaseTypeDef;
import org.apache.commons.lang.StringUtils;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.PROPERTY)
public class AtlasObjectId
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String KEY_GUID = "guid";
    public static final String KEY_TYPENAME = "typeName";
    public static final String KEY_UNIQUE_ATTRIBUTES = "uniqueAttributes";
    private String guid;
    private String typeName;
    private Map<String, Object> uniqueAttributes;

    public AtlasObjectId() {
        this(null, null, null);
    }

    public AtlasObjectId(String guid) {
        this(guid, null, null);
    }

    public AtlasObjectId(String guid, String typeName) {
        this(guid, typeName, null);
    }

    public AtlasObjectId(String typeName, Map<String, Object> uniqueAttributes) {
        this(null, typeName, uniqueAttributes);
    }

    public AtlasObjectId(String typeName, final String attrName, final Object attrValue) {
        this(null, typeName, (Map<String, Object>)new HashMap<String, Object>(){
            {
                this.put(attrName, attrValue);
            }
        });
    }

    public AtlasObjectId(String guid, String typeName, Map<String, Object> uniqueAttributes) {
        this.setGuid(guid);
        this.setTypeName(typeName);
        this.setUniqueAttributes(uniqueAttributes);
    }

    public AtlasObjectId(AtlasObjectId other) {
        if (other != null) {
            this.setGuid(other.getGuid());
            this.setTypeName(other.getTypeName());
            this.setUniqueAttributes(other.getUniqueAttributes());
        }
    }

    public AtlasObjectId(Map objIdMap) {
        if (objIdMap != null) {
            Object g = objIdMap.get(KEY_GUID);
            Object t = objIdMap.get(KEY_TYPENAME);
            Object u = objIdMap.get(KEY_UNIQUE_ATTRIBUTES);
            if (g != null) {
                this.setGuid(g.toString());
            }
            if (t != null) {
                this.setTypeName(t.toString());
            }
            if (u != null && u instanceof Map) {
                this.setUniqueAttributes((Map)u);
            }
        }
    }

    public String getGuid() {
        return this.guid;
    }

    public void setGuid(String guid) {
        this.guid = guid;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public Map<String, Object> getUniqueAttributes() {
        return this.uniqueAttributes;
    }

    public void setUniqueAttributes(Map<String, Object> uniqueAttributes) {
        this.uniqueAttributes = uniqueAttributes;
    }

    public StringBuilder toString(StringBuilder sb) {
        if (sb == null) {
            sb = new StringBuilder();
        }
        sb.append("AtlasObjectId{");
        sb.append("guid='").append(this.guid).append('\'');
        sb.append(", typeName='").append(this.typeName).append('\'');
        sb.append(", uniqueAttributes={");
        AtlasBaseTypeDef.dumpObjects(this.uniqueAttributes, sb);
        sb.append('}');
        sb.append('}');
        return sb;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AtlasObjectId that = (AtlasObjectId)o;
        if (StringUtils.isEmpty((String)this.guid) && StringUtils.isEmpty((String)that.guid)) {
            return Objects.equals(this.typeName, that.typeName) && Objects.equals(this.uniqueAttributes, that.uniqueAttributes);
        }
        return Objects.equals(this.guid, that.guid);
    }

    public int hashCode() {
        return this.guid != null ? Objects.hash(this.guid) : Objects.hash(this.typeName, this.uniqueAttributes);
    }

    public String toString() {
        return this.toString(new StringBuilder()).toString();
    }

    @JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    @XmlSeeAlso(value={AtlasObjectId.class})
    public static class AtlasObjectIds
    extends PList<AtlasObjectId> {
        private static final long serialVersionUID = 1L;

        public AtlasObjectIds() {
        }

        public AtlasObjectIds(List<AtlasObjectId> list) {
            super(list);
        }

        public AtlasObjectIds(List list, long startIndex, int pageSize, long totalCount, SearchFilter.SortType sortType, String sortBy) {
            super(list, startIndex, pageSize, totalCount, sortType, sortBy);
        }
    }
}

