/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.management;

import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.datanucleus.management.ManagementManager;

public abstract class AbstractStatistics {
    ManagementManager manager;
    String registeredName = null;
    AbstractStatistics parent = null;
    final AtomicInteger numReads = new AtomicInteger();
    final AtomicInteger numWrites = new AtomicInteger();
    final AtomicInteger numReadsLastTxn = new AtomicInteger();
    final AtomicInteger numWritesLastTxn = new AtomicInteger();
    final AtomicInteger numReadsStartTxn = new AtomicInteger();
    final AtomicInteger numWritesStartTxn = new AtomicInteger();
    final AtomicInteger insertCount = new AtomicInteger();
    final AtomicInteger deleteCount = new AtomicInteger();
    final AtomicInteger updateCount = new AtomicInteger();
    final AtomicInteger fetchCount = new AtomicInteger();
    final AtomicInteger txnTotalCount = new AtomicInteger();
    final AtomicInteger txnCommittedTotalCount = new AtomicInteger();
    final AtomicInteger txnRolledBackTotalCount = new AtomicInteger();
    final AtomicInteger txnActiveTotalCount = new AtomicInteger();
    final AtomicLong txnExecutionTotalTime = new AtomicLong();
    final AtomicLong txnExecutionTimeHigh = new AtomicLong(-1L);
    final AtomicLong txnExecutionTimeLow = new AtomicLong(-1L);
    SMA txnExecutionTimeAverage = new SMA(50);
    final AtomicInteger queryActiveTotalCount = new AtomicInteger();
    final AtomicInteger queryErrorTotalCount = new AtomicInteger();
    final AtomicInteger queryExecutionTotalCount = new AtomicInteger();
    final AtomicLong queryExecutionTotalTime = new AtomicLong();
    final AtomicLong queryExecutionTimeHigh = new AtomicLong(-1L);
    final AtomicLong queryExecutionTimeLow = new AtomicLong(-1L);
    SMA queryExecutionTimeAverage = new SMA(50);

    public AbstractStatistics(ManagementManager mgmtManager, AbstractStatistics parent) {
        this.manager = mgmtManager;
        this.parent = parent;
        if (mgmtManager != null) {
            this.registeredName = this.manager.getDomainName() + ":InstanceName=" + this.manager.getInstanceName() + ",Type=" + this.getClass().getName() + ",Name=Manager" + ManagementManager.random.nextLong();
            mgmtManager.registerMBean(this, this.registeredName);
        }
    }

    public void close() {
        if (this.manager != null) {
            this.manager.deregisterMBean(this.registeredName);
        }
    }

    public String getRegisteredName() {
        return this.registeredName;
    }

    public int getQueryActiveTotalCount() {
        return this.queryActiveTotalCount.intValue();
    }

    public int getQueryErrorTotalCount() {
        return this.queryErrorTotalCount.intValue();
    }

    public int getQueryExecutionTotalCount() {
        return this.queryExecutionTotalCount.intValue();
    }

    public long getQueryExecutionTimeLow() {
        return this.queryExecutionTimeLow.longValue();
    }

    public long getQueryExecutionTimeHigh() {
        return this.queryExecutionTimeHigh.longValue();
    }

    public long getQueryExecutionTotalTime() {
        return this.queryExecutionTotalTime.longValue();
    }

    public long getQueryExecutionTimeAverage() {
        return (int)this.queryExecutionTimeAverage.currentAverage();
    }

    public void queryBegin() {
        this.queryActiveTotalCount.incrementAndGet();
        if (this.parent != null) {
            this.parent.queryBegin();
        }
    }

    public void queryExecutedWithError() {
        this.queryErrorTotalCount.incrementAndGet();
        this.queryActiveTotalCount.decrementAndGet();
        if (this.parent != null) {
            this.parent.queryExecutedWithError();
        }
    }

    public void queryExecuted(long executionTime) {
        this.queryExecutionTotalCount.incrementAndGet();
        this.queryActiveTotalCount.decrementAndGet();
        this.queryExecutionTimeAverage.compute(executionTime);
        this.queryExecutionTimeLow.accumulateAndGet(executionTime, (prev, x) -> {
            if (prev == -1L) {
                return x;
            }
            return Math.min(prev, x);
        });
        this.queryExecutionTimeHigh.accumulateAndGet(executionTime, Math::max);
        this.queryExecutionTotalTime.addAndGet(executionTime);
        if (this.parent != null) {
            this.parent.queryExecuted(executionTime);
        }
    }

    public int getNumberOfDatastoreWrites() {
        return this.numWrites.intValue();
    }

    public int getNumberOfDatastoreReads() {
        return this.numReads.intValue();
    }

    public int getNumberOfDatastoreWritesInLatestTxn() {
        return this.numWritesLastTxn.intValue();
    }

    public int getNumberOfDatastoreReadsInLatestTxn() {
        return this.numReadsLastTxn.intValue();
    }

    public void incrementNumReads() {
        this.numReads.incrementAndGet();
        if (this.parent != null) {
            this.parent.incrementNumReads();
        }
    }

    public void incrementNumWrites() {
        this.numWrites.incrementAndGet();
        if (this.parent != null) {
            this.parent.incrementNumWrites();
        }
    }

    public int getNumberOfObjectFetches() {
        return this.fetchCount.intValue();
    }

    public int getNumberOfObjectInserts() {
        return this.insertCount.intValue();
    }

    public int getNumberOfObjectUpdates() {
        return this.updateCount.intValue();
    }

    public int getNumberOfObjectDeletes() {
        return this.deleteCount.intValue();
    }

    public void incrementInsertCount() {
        this.insertCount.incrementAndGet();
        if (this.parent != null) {
            this.parent.incrementInsertCount();
        }
    }

    public void incrementDeleteCount() {
        this.deleteCount.incrementAndGet();
        if (this.parent != null) {
            this.parent.incrementDeleteCount();
        }
    }

    public void incrementFetchCount() {
        this.fetchCount.incrementAndGet();
        if (this.parent != null) {
            this.parent.incrementFetchCount();
        }
    }

    public void incrementUpdateCount() {
        this.updateCount.incrementAndGet();
        if (this.parent != null) {
            this.parent.incrementUpdateCount();
        }
    }

    public long getTransactionExecutionTimeAverage() {
        return (int)this.txnExecutionTimeAverage.currentAverage();
    }

    public long getTransactionExecutionTimeLow() {
        return this.txnExecutionTimeLow.longValue();
    }

    public long getTransactionExecutionTimeHigh() {
        return this.txnExecutionTimeHigh.longValue();
    }

    public long getTransactionExecutionTotalTime() {
        return this.txnExecutionTotalTime.longValue();
    }

    public int getTransactionTotalCount() {
        return this.txnTotalCount.intValue();
    }

    public int getTransactionActiveTotalCount() {
        return this.txnActiveTotalCount.intValue();
    }

    public int getTransactionCommittedTotalCount() {
        return this.txnCommittedTotalCount.intValue();
    }

    public int getTransactionRolledBackTotalCount() {
        return this.txnRolledBackTotalCount.intValue();
    }

    public void transactionCommitted(long executionTime) {
        this.txnCommittedTotalCount.incrementAndGet();
        this.txnActiveTotalCount.decrementAndGet();
        this.txnExecutionTimeAverage.compute(executionTime);
        this.txnExecutionTimeLow.accumulateAndGet(executionTime, (prev, x) -> {
            if (prev == -1L) {
                return x;
            }
            return Math.min(prev, x);
        });
        this.txnExecutionTimeHigh.accumulateAndGet(executionTime, Math::max);
        this.txnExecutionTotalTime.addAndGet(executionTime);
        this.numReadsLastTxn.accumulateAndGet(this.numReads.intValue(), (prev, x) -> x - prev);
        this.numWritesLastTxn.accumulateAndGet(this.numWrites.intValue(), (prev, x) -> x - prev);
        if (this.parent != null) {
            this.parent.transactionCommitted(executionTime);
        }
    }

    public void transactionRolledBack(long executionTime) {
        this.txnRolledBackTotalCount.incrementAndGet();
        this.txnActiveTotalCount.decrementAndGet();
        this.txnExecutionTimeAverage.compute(executionTime);
        this.txnExecutionTimeLow.accumulateAndGet(executionTime, (prev, x) -> {
            if (prev == -1L) {
                return x;
            }
            return Math.min(prev, x);
        });
        this.txnExecutionTimeHigh.accumulateAndGet(executionTime, Math::max);
        this.txnExecutionTotalTime.addAndGet(executionTime);
        this.numReadsLastTxn.accumulateAndGet(this.numReads.intValue(), (prev, x) -> x - prev);
        this.numWritesLastTxn.accumulateAndGet(this.numWrites.intValue(), (prev, x) -> x - prev);
        if (this.parent != null) {
            this.parent.transactionRolledBack(executionTime);
        }
    }

    public void transactionStarted() {
        this.txnTotalCount.incrementAndGet();
        this.txnActiveTotalCount.incrementAndGet();
        this.numReadsStartTxn.set(this.numReads.intValue());
        this.numWritesStartTxn.set(this.numWrites.intValue());
        if (this.parent != null) {
            this.parent.transactionStarted();
        }
    }

    public static class SMA {
        private LinkedList<Double> values = new LinkedList();
        private int length;
        private double sum = 0.0;
        private double average = 0.0;

        public SMA(int length) {
            if (length <= 0) {
                throw new IllegalArgumentException("length must be greater than zero");
            }
            this.length = length;
        }

        public double currentAverage() {
            return this.average;
        }

        public synchronized double compute(double value) {
            if (this.values.size() == this.length && this.length > 0) {
                this.sum -= this.values.getFirst().doubleValue();
                this.values.removeFirst();
            }
            this.sum += value;
            this.values.addLast(value);
            this.average = this.sum / (double)this.values.size();
            return this.average;
        }
    }
}

