/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.enumerable;

import java.util.List;
import org.apache.calcite.adapter.enumerable.EnumerableAggregate;
import org.apache.calcite.adapter.enumerable.EnumerableConvention;
import org.apache.calcite.adapter.enumerable.EnumerableRules;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.InvalidRelException;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.convert.ConverterRule;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.logical.LogicalAggregate;
import org.apache.calcite.util.ImmutableBitSet;
import org.checkerframework.checker.nullness.qual.Nullable;

class EnumerableAggregateRule
extends ConverterRule {
    static final ConverterRule.Config DEFAULT_CONFIG = ConverterRule.Config.INSTANCE.withConversion(LogicalAggregate.class, Convention.NONE, EnumerableConvention.INSTANCE, "EnumerableAggregateRule").withRuleFactory(EnumerableAggregateRule::new);

    protected EnumerableAggregateRule(ConverterRule.Config config) {
        super(config);
    }

    @Override
    public @Nullable RelNode convert(RelNode rel) {
        Aggregate agg = (Aggregate)rel;
        RelTraitSet traitSet = rel.getCluster().traitSet().replace(EnumerableConvention.INSTANCE);
        try {
            return new EnumerableAggregate(rel.getCluster(), traitSet, EnumerableAggregateRule.convert(agg.getInput(), traitSet), agg.getGroupSet(), (List<ImmutableBitSet>)agg.getGroupSets(), agg.getAggCallList());
        }
        catch (InvalidRelException e) {
            EnumerableRules.LOGGER.debug(e.toString());
            return null;
        }
    }
}

