/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

Create Graph IF NOT EXISTS g (
  Vertex buyer (
    id bigint ID,
    name string,
    age int
  ),
  Vertex seller (
    id bigint ID,
    name string
  ),
  Edge buy (
    srcId FROM buyer SOURCE ID,
    targetId FROM seller DESTINATION ID,
    ts bigint,
    amount double
  ),
  Edge knows (
    srcId FROM buyer SOURCE ID,
    targetId FROM buyer DESTINATION ID,
    weight double
  )
) With ( -- 配置信息
  storeType = 'memory',
  shardCount = 2
)
;

INSERT INTO g.seller SELECT 1, 'test';