/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.runtimemetrics.java8;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.runtimemetrics.java8.RuntimeMetrics;
import io.opentelemetry.instrumentation.runtimemetrics.java8.internal.JmxRuntimeMetricsFactory;
import java.util.List;

public final class RuntimeMetricsBuilder {
    private final OpenTelemetry openTelemetry;
    private boolean enableExperimentalJmxTelemetry = false;

    RuntimeMetricsBuilder(OpenTelemetry openTelemetry) {
        this.openTelemetry = openTelemetry;
    }

    @CanIgnoreReturnValue
    public RuntimeMetricsBuilder enableExperimentalJmxTelemetry() {
        this.enableExperimentalJmxTelemetry = true;
        return this;
    }

    public RuntimeMetrics build() {
        List<AutoCloseable> observables = JmxRuntimeMetricsFactory.buildObservables(this.openTelemetry, this.enableExperimentalJmxTelemetry);
        return new RuntimeMetrics(observables);
    }
}

