/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.logging;

import java.io.Serializable;
import java.util.Date;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.sessions.AbstractSession;

public class SessionLogEntry
implements Serializable {
    protected Date date = new Date();
    protected transient AbstractSession session;
    protected transient Thread thread = Thread.currentThread();
    protected transient Accessor connection;
    protected String message;
    protected Throwable throwable;
    protected int level;
    protected String nameSpace;
    protected Object[] parameters;
    protected boolean shouldTranslate;
    protected String sourceClassName;
    protected String sourceMethodName;

    public SessionLogEntry(AbstractSession session) {
        this.session = session;
        this.message = "";
        this.level = 5;
    }

    public SessionLogEntry(AbstractSession session, Throwable throwable) {
        this(session);
        this.throwable = throwable;
        this.level = 7;
    }

    public SessionLogEntry(AbstractSession session, String message) {
        this(session);
        this.message = message;
    }

    public SessionLogEntry(AbstractSession session, String message, Accessor connection) {
        this(session, message);
        this.connection = connection;
    }

    public SessionLogEntry(int level, AbstractSession session, String message, Object[] params, Accessor connection, boolean shouldTranslate) {
        this(session, message, connection);
        this.level = level;
        this.parameters = params;
        this.shouldTranslate = shouldTranslate;
    }

    public SessionLogEntry(int level, String category, AbstractSession session, String message, Object[] params, Accessor connection, boolean shouldTranslate) {
        this(level, session, message, params, connection, shouldTranslate);
        this.nameSpace = category;
    }

    public SessionLogEntry(AbstractSession session, int level, String category, Throwable throwable) {
        this(session, throwable);
        this.level = level;
        this.nameSpace = category;
    }

    public Accessor getConnection() {
        return this.connection;
    }

    public Date getDate() {
        return this.date;
    }

    public Throwable getException() {
        return this.throwable;
    }

    public String getMessage() {
        return this.message;
    }

    public AbstractSession getSession() {
        return this.session;
    }

    public Thread getThread() {
        return this.thread;
    }

    public int getLevel() {
        return this.level;
    }

    public String getNameSpace() {
        return this.nameSpace;
    }

    public Object[] getParameters() {
        return this.parameters;
    }

    public String getSourceClassName() {
        return this.sourceClassName;
    }

    public String getSourceMethodName() {
        return this.sourceMethodName;
    }

    public boolean shouldTranslate() {
        return this.shouldTranslate;
    }

    public boolean hasException() {
        return this.getException() != null;
    }

    public boolean hasMessage() {
        return this.getMessage() != null && this.getMessage().length() != 0;
    }

    public void setConnection(Accessor connection) {
        this.connection = connection;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public void setException(Throwable throwable) {
        this.throwable = throwable;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setSession(AbstractSession session) {
        this.session = session;
    }

    public void setThread(Thread thread) {
        this.thread = thread;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public void setNameSpace(String nameSpace) {
        this.nameSpace = nameSpace;
    }

    public void setParameters(Object[] params) {
        this.parameters = params;
    }

    public void setShouldTranslate(boolean shouldTranslate) {
        this.shouldTranslate = shouldTranslate;
    }

    public void setSourceClassName(String sourceClassName) {
        this.sourceClassName = sourceClassName;
    }

    public void setSourceMethodName(String sourceMethodName) {
        this.sourceMethodName = sourceMethodName;
    }

    public String toString() {
        return Helper.getShortClassName(this.getClass()) + "(" + this.getMessage() + ")";
    }
}

