/*
 * Decompiled with CFR 0.152.
 */
package org.apache.livy.rsc.rpc;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageCodec;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.livy.client.common.Serializer;
import org.apache.livy.rsc.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class KryoMessageCodec
extends ByteToMessageCodec<Object> {
    private static final Logger LOG = LoggerFactory.getLogger(KryoMessageCodec.class);
    private final int maxMessageSize;
    private final Serializer serializer;
    private volatile EncryptionHandler encryptionHandler;

    public KryoMessageCodec(int maxMessageSize, Class<?> ... messages) {
        this.maxMessageSize = maxMessageSize;
        this.serializer = new Serializer(messages);
        this.encryptionHandler = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        if (in.readableBytes() < 4) {
            return;
        }
        in.markReaderIndex();
        int msgSize = in.readInt();
        this.checkSize(msgSize);
        if (in.readableBytes() < msgSize) {
            in.resetReaderIndex();
            return;
        }
        try {
            ByteBuffer nioBuffer = this.maybeDecrypt(in.nioBuffer(in.readerIndex(), msgSize));
            Object msg = this.serializer.deserialize(nioBuffer);
            LOG.debug("Decoded message of type {} ({} bytes)", msg != null ? msg.getClass().getName() : msg, (Object)msgSize);
            out.add(msg);
        }
        finally {
            in.skipBytes(msgSize);
        }
    }

    protected void encode(ChannelHandlerContext ctx, Object msg, ByteBuf buf) throws Exception {
        ByteBuffer msgData = this.maybeEncrypt(this.serializer.serialize(msg));
        LOG.debug("Encoded message of type {} ({} bytes)", (Object)msg.getClass().getName(), (Object)msgData.remaining());
        this.checkSize(msgData.remaining());
        buf.ensureWritable(msgData.remaining() + 4);
        buf.writeInt(msgData.remaining());
        buf.writeBytes(msgData);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        if (this.encryptionHandler != null) {
            this.encryptionHandler.dispose();
        }
        super.channelInactive(ctx);
    }

    private void checkSize(int msgSize) {
        Utils.checkArgument(msgSize > 0, "Message size (%s bytes) must be positive.", msgSize);
        Utils.checkArgument(this.maxMessageSize <= 0 || msgSize <= this.maxMessageSize, "Message (%s bytes) exceeds maximum allowed size (%s bytes).", msgSize, this.maxMessageSize);
    }

    private ByteBuffer maybeEncrypt(ByteBuffer data) throws Exception {
        return this.doWrapOrUnWrap(data, true);
    }

    private ByteBuffer maybeDecrypt(ByteBuffer data) throws Exception {
        return this.doWrapOrUnWrap(data, false);
    }

    private ByteBuffer doWrapOrUnWrap(ByteBuffer data, boolean wrap) throws IOException {
        int offset;
        byte[] byteData;
        if (this.encryptionHandler == null) {
            return data;
        }
        int len = data.limit() - data.position();
        if (data.hasArray()) {
            byteData = data.array();
            offset = data.position() + data.arrayOffset();
            data.position(data.limit());
        } else {
            byteData = new byte[len];
            offset = 0;
            data.get(byteData);
        }
        byte[] result = wrap ? this.encryptionHandler.wrap(byteData, offset, len) : this.encryptionHandler.unwrap(byteData, offset, len);
        return ByteBuffer.wrap(result);
    }

    void setEncryptionHandler(EncryptionHandler handler) {
        this.encryptionHandler = handler;
    }

    static interface EncryptionHandler {
        public byte[] wrap(byte[] var1, int var2, int var3) throws IOException;

        public byte[] unwrap(byte[] var1, int var2, int var3) throws IOException;

        public void dispose() throws IOException;
    }
}

