#
# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.
#
# coding: utf-8

"""
    Apache Iceberg REST Catalog API

    Defines the specification for the first version of the REST Catalog API. Implementations should ideally support both Iceberg table specs v1 and v2, with priority given to v2.

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
from inspect import getfullargspec
import json
import pprint
import re  # noqa: F401
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Optional
from polaris.catalog.models.add_schema_update import AddSchemaUpdate
from polaris.catalog.models.add_view_version_update import AddViewVersionUpdate
from polaris.catalog.models.assign_uuid_update import AssignUUIDUpdate
from polaris.catalog.models.remove_properties_update import RemovePropertiesUpdate
from polaris.catalog.models.set_current_view_version_update import SetCurrentViewVersionUpdate
from polaris.catalog.models.set_location_update import SetLocationUpdate
from polaris.catalog.models.set_properties_update import SetPropertiesUpdate
from polaris.catalog.models.upgrade_format_version_update import UpgradeFormatVersionUpdate
from typing import Union, Any, List, Set, TYPE_CHECKING, Optional, Dict
from typing_extensions import Literal, Self
from pydantic import Field

VIEWUPDATE_ANY_OF_SCHEMAS = ["AddSchemaUpdate", "AddViewVersionUpdate", "AssignUUIDUpdate", "RemovePropertiesUpdate", "SetCurrentViewVersionUpdate", "SetLocationUpdate", "SetPropertiesUpdate", "UpgradeFormatVersionUpdate"]

class ViewUpdate(BaseModel):
    """
    ViewUpdate
    """

    # data type: AssignUUIDUpdate
    anyof_schema_1_validator: Optional[AssignUUIDUpdate] = None
    # data type: UpgradeFormatVersionUpdate
    anyof_schema_2_validator: Optional[UpgradeFormatVersionUpdate] = None
    # data type: AddSchemaUpdate
    anyof_schema_3_validator: Optional[AddSchemaUpdate] = None
    # data type: SetLocationUpdate
    anyof_schema_4_validator: Optional[SetLocationUpdate] = None
    # data type: SetPropertiesUpdate
    anyof_schema_5_validator: Optional[SetPropertiesUpdate] = None
    # data type: RemovePropertiesUpdate
    anyof_schema_6_validator: Optional[RemovePropertiesUpdate] = None
    # data type: AddViewVersionUpdate
    anyof_schema_7_validator: Optional[AddViewVersionUpdate] = None
    # data type: SetCurrentViewVersionUpdate
    anyof_schema_8_validator: Optional[SetCurrentViewVersionUpdate] = None
    if TYPE_CHECKING:
        actual_instance: Optional[Union[AddSchemaUpdate, AddViewVersionUpdate, AssignUUIDUpdate, RemovePropertiesUpdate, SetCurrentViewVersionUpdate, SetLocationUpdate, SetPropertiesUpdate, UpgradeFormatVersionUpdate]] = None
    else:
        actual_instance: Any = None
    any_of_schemas: Set[str] = { "AddSchemaUpdate", "AddViewVersionUpdate", "AssignUUIDUpdate", "RemovePropertiesUpdate", "SetCurrentViewVersionUpdate", "SetLocationUpdate", "SetPropertiesUpdate", "UpgradeFormatVersionUpdate" }

    model_config = {
        "validate_assignment": True,
        "protected_namespaces": (),
    }

    discriminator_value_class_map: Dict[str, str] = {
    }

    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_anyof(cls, v):
        instance = ViewUpdate.model_construct()
        error_messages = []
        # validate data type: AssignUUIDUpdate
        if not isinstance(v, AssignUUIDUpdate):
            error_messages.append(f"Error! Input type `{type(v)}` is not `AssignUUIDUpdate`")
        else:
            return v

        # validate data type: UpgradeFormatVersionUpdate
        if not isinstance(v, UpgradeFormatVersionUpdate):
            error_messages.append(f"Error! Input type `{type(v)}` is not `UpgradeFormatVersionUpdate`")
        else:
            return v

        # validate data type: AddSchemaUpdate
        if not isinstance(v, AddSchemaUpdate):
            error_messages.append(f"Error! Input type `{type(v)}` is not `AddSchemaUpdate`")
        else:
            return v

        # validate data type: SetLocationUpdate
        if not isinstance(v, SetLocationUpdate):
            error_messages.append(f"Error! Input type `{type(v)}` is not `SetLocationUpdate`")
        else:
            return v

        # validate data type: SetPropertiesUpdate
        if not isinstance(v, SetPropertiesUpdate):
            error_messages.append(f"Error! Input type `{type(v)}` is not `SetPropertiesUpdate`")
        else:
            return v

        # validate data type: RemovePropertiesUpdate
        if not isinstance(v, RemovePropertiesUpdate):
            error_messages.append(f"Error! Input type `{type(v)}` is not `RemovePropertiesUpdate`")
        else:
            return v

        # validate data type: AddViewVersionUpdate
        if not isinstance(v, AddViewVersionUpdate):
            error_messages.append(f"Error! Input type `{type(v)}` is not `AddViewVersionUpdate`")
        else:
            return v

        # validate data type: SetCurrentViewVersionUpdate
        if not isinstance(v, SetCurrentViewVersionUpdate):
            error_messages.append(f"Error! Input type `{type(v)}` is not `SetCurrentViewVersionUpdate`")
        else:
            return v

        if error_messages:
            # no match
            raise ValueError("No match found when setting the actual_instance in ViewUpdate with anyOf schemas: AddSchemaUpdate, AddViewVersionUpdate, AssignUUIDUpdate, RemovePropertiesUpdate, SetCurrentViewVersionUpdate, SetLocationUpdate, SetPropertiesUpdate, UpgradeFormatVersionUpdate. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Dict[str, Any]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        # anyof_schema_1_validator: Optional[AssignUUIDUpdate] = None
        try:
            instance.actual_instance = AssignUUIDUpdate.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_2_validator: Optional[UpgradeFormatVersionUpdate] = None
        try:
            instance.actual_instance = UpgradeFormatVersionUpdate.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_3_validator: Optional[AddSchemaUpdate] = None
        try:
            instance.actual_instance = AddSchemaUpdate.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_4_validator: Optional[SetLocationUpdate] = None
        try:
            instance.actual_instance = SetLocationUpdate.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_5_validator: Optional[SetPropertiesUpdate] = None
        try:
            instance.actual_instance = SetPropertiesUpdate.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_6_validator: Optional[RemovePropertiesUpdate] = None
        try:
            instance.actual_instance = RemovePropertiesUpdate.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_7_validator: Optional[AddViewVersionUpdate] = None
        try:
            instance.actual_instance = AddViewVersionUpdate.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_8_validator: Optional[SetCurrentViewVersionUpdate] = None
        try:
            instance.actual_instance = SetCurrentViewVersionUpdate.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))

        if error_messages:
            # no match
            raise ValueError("No match found when deserializing the JSON string into ViewUpdate with anyOf schemas: AddSchemaUpdate, AddViewVersionUpdate, AssignUUIDUpdate, RemovePropertiesUpdate, SetCurrentViewVersionUpdate, SetLocationUpdate, SetPropertiesUpdate, UpgradeFormatVersionUpdate. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], AddSchemaUpdate, AddViewVersionUpdate, AssignUUIDUpdate, RemovePropertiesUpdate, SetCurrentViewVersionUpdate, SetLocationUpdate, SetPropertiesUpdate, UpgradeFormatVersionUpdate]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


