/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.cluster;

import org.apache.camel.CamelContext;
import org.apache.camel.NamedNode;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.cluster.CamelClusterService;
import org.apache.camel.impl.cluster.ClusteredRoutePolicy;
import org.apache.camel.spi.RoutePolicy;
import org.apache.camel.spi.RoutePolicyFactory;
import org.apache.camel.support.cluster.ClusterServiceSelectors;
import org.apache.camel.util.ObjectHelper;

public class ClusteredRoutePolicyFactory
implements RoutePolicyFactory {
    private final String namespace;
    private final CamelClusterService clusterService;
    private final CamelClusterService.Selector clusterServiceSelector;

    public ClusteredRoutePolicyFactory(String namespace) {
        ObjectHelper.notNull((Object)namespace, (String)"Cluster View Namespace");
        this.namespace = namespace;
        this.clusterService = null;
        this.clusterServiceSelector = ClusterServiceSelectors.DEFAULT_SELECTOR;
    }

    public ClusteredRoutePolicyFactory(CamelClusterService.Selector selector, String namespace) {
        ObjectHelper.notNull((Object)namespace, (String)"Cluster View Namespace");
        ObjectHelper.notNull((Object)selector, (String)"Cluster Service Selector");
        this.namespace = namespace;
        this.clusterService = null;
        this.clusterServiceSelector = selector;
    }

    public ClusteredRoutePolicyFactory(CamelClusterService clusterService, String viewName) {
        ObjectHelper.notNull((Object)clusterService, (String)"Cluster Service");
        ObjectHelper.notNull((Object)viewName, (String)"Cluster View Namespace");
        this.clusterService = clusterService;
        this.namespace = viewName;
        this.clusterServiceSelector = null;
    }

    public RoutePolicy createRoutePolicy(CamelContext camelContext, String routeId, NamedNode route) {
        try {
            return this.clusterService != null ? ClusteredRoutePolicy.forNamespace(this.clusterService, this.namespace) : ClusteredRoutePolicy.forNamespace(camelContext, this.clusterServiceSelector, this.namespace);
        }
        catch (Exception e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }

    public static ClusteredRoutePolicyFactory forNamespace(String namespace) {
        return new ClusteredRoutePolicyFactory(namespace);
    }

    public static ClusteredRoutePolicyFactory forNamespace(CamelClusterService.Selector selector, String namespace) {
        return new ClusteredRoutePolicyFactory(selector, namespace);
    }

    public static ClusteredRoutePolicyFactory forNamespace(CamelClusterService clusterService, String namespace) {
        return new ClusteredRoutePolicyFactory(clusterService, namespace);
    }
}

