/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.services;

import java.util.List;
import java.util.Objects;
import org.apache.maven.api.ArtifactCoordinates;
import org.apache.maven.api.RemoteRepository;
import org.apache.maven.api.Session;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.Nullable;
import org.apache.maven.api.services.BaseRequest;
import org.apache.maven.api.services.Request;
import org.apache.maven.api.services.RequestTrace;

@Experimental
public interface VersionResolverRequest
extends Request<Session> {
    @Nonnull
    public ArtifactCoordinates getArtifactCoordinates();

    @Nullable
    public List<RemoteRepository> getRepositories();

    @Nonnull
    public static VersionResolverRequest build(@Nonnull Session session, @Nonnull ArtifactCoordinates artifactCoordinates) {
        return VersionResolverRequest.builder().session(Objects.requireNonNull(session, "session cannot be null")).artifactCoordinates(Objects.requireNonNull(artifactCoordinates, "artifactCoordinates cannot be null")).build();
    }

    @Nonnull
    public static VersionResolverRequest build(@Nonnull Session session, @Nonnull ArtifactCoordinates artifactCoordinates, @Nullable List<RemoteRepository> repositories) {
        return VersionResolverRequest.builder().session(Objects.requireNonNull(session, "session cannot be null")).artifactCoordinates(Objects.requireNonNull(artifactCoordinates, "artifactCoordinates cannot be null")).repositories(repositories).build();
    }

    @Nonnull
    public static VersionResolverRequestBuilder builder() {
        return new VersionResolverRequestBuilder();
    }

    @NotThreadSafe
    public static class VersionResolverRequestBuilder {
        Session session;
        RequestTrace trace;
        ArtifactCoordinates artifactCoordinates;
        List<RemoteRepository> repositories;

        public VersionResolverRequestBuilder session(Session session) {
            this.session = session;
            return this;
        }

        public VersionResolverRequestBuilder trace(RequestTrace trace) {
            this.trace = trace;
            return this;
        }

        public VersionResolverRequestBuilder artifactCoordinates(ArtifactCoordinates artifactCoordinates) {
            this.artifactCoordinates = artifactCoordinates;
            return this;
        }

        public VersionResolverRequestBuilder repositories(List<RemoteRepository> repositories) {
            this.repositories = repositories;
            return this;
        }

        public VersionResolverRequest build() {
            return new DefaultVersionResolverRequest(this.session, this.trace, this.artifactCoordinates, this.repositories);
        }

        private static class DefaultVersionResolverRequest
        extends BaseRequest<Session>
        implements VersionResolverRequest {
            private final ArtifactCoordinates artifactCoordinates;
            private final List<RemoteRepository> repositories;

            DefaultVersionResolverRequest(@Nonnull Session session, @Nullable RequestTrace trace, @Nonnull ArtifactCoordinates artifactCoordinates, @Nullable List<RemoteRepository> repositories) {
                super(session, trace);
                this.artifactCoordinates = artifactCoordinates;
                this.repositories = repositories;
            }

            @Override
            @Nonnull
            public ArtifactCoordinates getArtifactCoordinates() {
                return this.artifactCoordinates;
            }

            @Override
            @Nullable
            public List<RemoteRepository> getRepositories() {
                return this.repositories;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public boolean equals(Object o) {
                if (!(o instanceof DefaultVersionResolverRequest)) return false;
                DefaultVersionResolverRequest that = (DefaultVersionResolverRequest)o;
                if (!Objects.equals(this.artifactCoordinates, that.artifactCoordinates)) return false;
                if (!Objects.equals(this.repositories, that.repositories)) return false;
                return true;
            }

            @Override
            public int hashCode() {
                return Objects.hash(this.artifactCoordinates, this.repositories);
            }

            @Override
            public String toString() {
                return "VersionResolverRequest[artifactCoordinates=" + String.valueOf(this.artifactCoordinates) + ", repositories=" + String.valueOf(this.repositories) + "]";
            }
        }
    }
}

