/*
 * Decompiled with CFR 0.152.
 */
package io.takari.maven.builder.smart;

import io.takari.maven.builder.smart.DependencyGraph;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import org.apache.maven.project.MavenProject;

class ProjectComparator {
    ProjectComparator() {
    }

    public static Comparator<MavenProject> create(DependencyGraph<MavenProject> graph) {
        return ProjectComparator.create0(graph, Collections.emptyMap(), ProjectComparator::id);
    }

    static <K> Comparator<K> create0(DependencyGraph<K> dependencyGraph, Map<String, AtomicLong> historicalServiceTimes, Function<K, String> toKey) {
        long defaultServiceTime = ProjectComparator.average(historicalServiceTimes.values());
        HashMap serviceTimes = new HashMap();
        HashSet rootProjects = new HashSet();
        dependencyGraph.getProjects().forEach(project -> {
            long serviceTime = ProjectComparator.getServiceTime(historicalServiceTimes, project, defaultServiceTime, toKey);
            serviceTimes.put(project, serviceTime);
            if (dependencyGraph.isRoot(project)) {
                rootProjects.add(project);
            }
        });
        Map<K, Long> projectWeights = ProjectComparator.calculateWeights(dependencyGraph, serviceTimes, rootProjects);
        return Comparator.comparingLong(projectWeights::get).thenComparing(toKey, String::compareTo).reversed();
    }

    private static long average(Collection<AtomicLong> values) {
        return (long)values.stream().mapToLong(AtomicLong::longValue).average().orElse(1.0);
    }

    private static <K> long getServiceTime(Map<String, AtomicLong> serviceTimes, K project, long defaultServiceTime, Function<K, String> toKey) {
        AtomicLong serviceTime = serviceTimes.get(toKey.apply(project));
        return serviceTime != null ? serviceTime.longValue() : defaultServiceTime;
    }

    private static <K> Map<K, Long> calculateWeights(DependencyGraph<K> dependencyGraph, Map<K, Long> serviceTimes, Collection<K> rootProjects) {
        HashMap weights = new HashMap();
        for (K rootProject : rootProjects) {
            ProjectComparator.calculateWeights(dependencyGraph, serviceTimes, rootProject, weights);
        }
        return weights;
    }

    private static <K> long calculateWeights(DependencyGraph<K> dependencyGraph, Map<K, Long> serviceTimes, K project, Map<K, Long> weights) {
        long weight = serviceTimes.get(project) + dependencyGraph.getDownstreamProjects(project).mapToLong(successor -> {
            long successorWeight = weights.containsKey(successor) ? (Long)weights.get(successor) : ProjectComparator.calculateWeights(dependencyGraph, serviceTimes, successor, weights);
            return successorWeight;
        }).max().orElse(0L);
        weights.put(project, weight);
        return weight;
    }

    static String id(MavenProject project) {
        return String.valueOf(project.getGroupId()) + ':' + project.getArtifactId() + ':' + project.getVersion();
    }
}

