/*
 * Decompiled with CFR 0.152.
 */
package org.jline.consoleui.prompt.builder;

import java.util.ArrayList;
import java.util.List;
import org.jline.consoleui.elements.Checkbox;
import org.jline.consoleui.elements.PageSizeType;
import org.jline.consoleui.elements.items.CheckboxItemIF;
import org.jline.consoleui.prompt.builder.CheckboxItemBuilder;
import org.jline.consoleui.prompt.builder.CheckboxSeparatorBuilder;
import org.jline.consoleui.prompt.builder.PromptBuilder;

public class CheckboxPromptBuilder {
    private final PromptBuilder promptBuilder;
    private String name;
    private String message;
    private int pageSize;
    private PageSizeType pageSizeType;
    private final List<CheckboxItemIF> itemList;

    public CheckboxPromptBuilder(PromptBuilder promptBuilder) {
        this.promptBuilder = promptBuilder;
        this.pageSize = 10;
        this.pageSizeType = PageSizeType.ABSOLUTE;
        this.itemList = new ArrayList<CheckboxItemIF>();
    }

    void addItem(CheckboxItemIF checkboxItem) {
        this.itemList.add(checkboxItem);
    }

    public CheckboxPromptBuilder name(String name) {
        this.name = name;
        if (this.message == null) {
            this.message = name;
        }
        return this;
    }

    public CheckboxPromptBuilder message(String message) {
        this.message = message;
        if (this.name == null) {
            this.name = message;
        }
        return this;
    }

    public CheckboxPromptBuilder pageSize(int absoluteSize) {
        this.pageSize = absoluteSize;
        this.pageSizeType = PageSizeType.ABSOLUTE;
        return this;
    }

    public CheckboxPromptBuilder relativePageSize(int relativePageSize) {
        this.pageSize = relativePageSize;
        this.pageSizeType = PageSizeType.RELATIVE;
        return this;
    }

    public CheckboxItemBuilder newItem() {
        return new CheckboxItemBuilder(this);
    }

    public CheckboxItemBuilder newItem(String name) {
        CheckboxItemBuilder checkboxItemBuilder = new CheckboxItemBuilder(this);
        return checkboxItemBuilder.name(name);
    }

    public PromptBuilder addPrompt() {
        Checkbox checkbox = new Checkbox(this.message, this.name, this.pageSize, this.pageSizeType, this.itemList);
        this.promptBuilder.addPrompt(checkbox);
        return this.promptBuilder;
    }

    public CheckboxSeparatorBuilder newSeparator() {
        return new CheckboxSeparatorBuilder(this);
    }

    public CheckboxSeparatorBuilder newSeparator(String text) {
        CheckboxSeparatorBuilder checkboxSeperatorBuilder = new CheckboxSeparatorBuilder(this);
        return checkboxSeperatorBuilder.text(text);
    }
}

