/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.services;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.LongAdder;
import java.util.stream.Stream;
import org.apache.maven.api.ProtoSession;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.Nullable;
import org.apache.maven.api.services.BuilderProblem;

@Experimental
public interface ProblemCollector<P extends BuilderProblem> {
    default public boolean hasWarningProblems() {
        return this.hasProblemsFor(BuilderProblem.Severity.WARNING);
    }

    default public boolean hasErrorProblems() {
        return this.hasProblemsFor(BuilderProblem.Severity.ERROR);
    }

    default public boolean hasFatalProblems() {
        return this.hasProblemsFor(BuilderProblem.Severity.FATAL);
    }

    default public boolean hasProblemsFor(BuilderProblem.Severity severity) {
        Objects.requireNonNull(severity, "severity");
        for (BuilderProblem.Severity s : BuilderProblem.Severity.values()) {
            if (s.ordinal() > severity.ordinal() || this.problemsReportedFor(s) <= 0) continue;
            return true;
        }
        return false;
    }

    default public int totalProblemsReported() {
        return this.problemsReportedFor(BuilderProblem.Severity.values());
    }

    public int problemsReportedFor(BuilderProblem.Severity ... var1);

    public boolean problemsOverflow();

    public boolean reportProblem(P var1);

    @Nonnull
    default public Stream<P> problems() {
        Stream result = Stream.empty();
        for (BuilderProblem.Severity severity : BuilderProblem.Severity.values()) {
            result = Stream.concat(result, this.problems(severity));
        }
        return result;
    }

    @Nonnull
    public Stream<P> problems(BuilderProblem.Severity var1);

    @Nonnull
    public static <P extends BuilderProblem> ProblemCollector<P> empty() {
        return new ProblemCollector<P>(){

            @Override
            public boolean problemsOverflow() {
                return false;
            }

            @Override
            public int problemsReportedFor(BuilderProblem.Severity ... severities) {
                return 0;
            }

            @Override
            public boolean reportProblem(P problem) {
                throw new IllegalStateException("empty problem collector");
            }

            @Override
            public Stream<P> problems(BuilderProblem.Severity severity) {
                return Stream.empty();
            }
        };
    }

    @Nonnull
    public static <P extends BuilderProblem> ProblemCollector<P> create(@Nullable ProtoSession protoSession) {
        if (protoSession != null && protoSession.getUserProperties().containsKey("maven.builder.maxProblems")) {
            return new Impl(Integer.parseInt(protoSession.getUserProperties().get("maven.builder.maxProblems")));
        }
        return ProblemCollector.create(100);
    }

    @Nonnull
    public static <P extends BuilderProblem> ProblemCollector<P> create(int maxCountLimit) {
        return new Impl(maxCountLimit);
    }

    public static class Impl<P extends BuilderProblem>
    implements ProblemCollector<P> {
        private final int maxCountLimit;
        private final AtomicInteger totalCount;
        private final ConcurrentMap<BuilderProblem.Severity, LongAdder> counters;
        private final ConcurrentMap<BuilderProblem.Severity, List<P>> problems;
        private static final List<BuilderProblem.Severity> REVERSED_ORDER = Arrays.stream(BuilderProblem.Severity.values()).sorted(Comparator.reverseOrder()).toList();

        private Impl(int maxCountLimit) {
            if (maxCountLimit < 0) {
                throw new IllegalArgumentException("maxCountLimit must be non-negative");
            }
            this.maxCountLimit = maxCountLimit;
            this.totalCount = new AtomicInteger();
            this.counters = new ConcurrentHashMap<BuilderProblem.Severity, LongAdder>();
            this.problems = new ConcurrentHashMap<BuilderProblem.Severity, List<P>>();
        }

        @Override
        public int problemsReportedFor(BuilderProblem.Severity ... severity) {
            int result = 0;
            for (BuilderProblem.Severity s : severity) {
                result += this.getCounter(s).intValue();
            }
            return result;
        }

        @Override
        public boolean problemsOverflow() {
            return this.totalCount.get() > this.maxCountLimit;
        }

        @Override
        public boolean reportProblem(P problem) {
            Objects.requireNonNull(problem, "problem");
            int currentCount = this.totalCount.incrementAndGet();
            this.getCounter(problem.getSeverity()).increment();
            if (currentCount <= this.maxCountLimit || this.dropProblemWithLowerSeverity(problem.getSeverity())) {
                this.getProblems(problem.getSeverity()).add(problem);
                return true;
            }
            return false;
        }

        @Override
        public Stream<P> problems(BuilderProblem.Severity severity) {
            Objects.requireNonNull(severity, "severity");
            return this.getProblems(severity).stream();
        }

        private LongAdder getCounter(BuilderProblem.Severity severity) {
            return this.counters.computeIfAbsent(severity, k -> new LongAdder());
        }

        private List<P> getProblems(BuilderProblem.Severity severity) {
            return this.problems.computeIfAbsent(severity, k -> new CopyOnWriteArrayList());
        }

        private boolean dropProblemWithLowerSeverity(BuilderProblem.Severity severity) {
            for (BuilderProblem.Severity s : REVERSED_ORDER) {
                if (s.ordinal() <= severity.ordinal()) continue;
                List<P> problems = this.getProblems(s);
                while (!problems.isEmpty()) {
                    try {
                        return problems.remove(0) != null;
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    }
                }
            }
            return false;
        }
    }
}

