/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.api.model.ImmutableCollections;
import org.apache.maven.api.model.InputLocation;

public class InputSource
implements Serializable {
    private final String modelId;
    private final String location;
    private final List<InputSource> inputs;
    private final InputLocation importedFrom;

    public InputSource(String modelId, String location) {
        this(modelId, location, null);
    }

    public InputSource(String modelId, String location, InputLocation importedFrom) {
        this.modelId = modelId;
        this.location = location;
        this.inputs = null;
        this.importedFrom = importedFrom;
    }

    public InputSource(Collection<InputSource> inputs) {
        this.modelId = null;
        this.location = null;
        this.inputs = ImmutableCollections.copy(inputs);
        this.importedFrom = null;
    }

    public String getLocation() {
        return this.location;
    }

    public String getModelId() {
        return this.modelId;
    }

    public InputLocation getImportedFrom() {
        return this.importedFrom;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InputSource that = (InputSource)o;
        return Objects.equals(this.modelId, that.modelId) && Objects.equals(this.location, that.location) && Objects.equals(this.inputs, that.inputs);
    }

    public int hashCode() {
        return Objects.hash(this.modelId, this.location, this.inputs);
    }

    Stream<InputSource> sources() {
        return this.inputs != null ? this.inputs.stream() : Stream.of(this);
    }

    public String toString() {
        if (this.inputs != null) {
            return this.inputs.stream().map(InputSource::toString).collect(Collectors.joining(", ", "merged[", "]"));
        }
        return this.getModelId() + " " + this.getLocation();
    }

    public static InputSource merge(InputSource src1, InputSource src2) {
        return new InputSource(Stream.concat(src1.sources(), src2.sources()).collect(Collectors.toSet()));
    }
}

