/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.impl.resolver.scopes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import org.eclipse.aether.impl.scope.BuildPath;
import org.eclipse.aether.impl.scope.BuildScope;
import org.eclipse.aether.impl.scope.BuildScopeMatrixSource;
import org.eclipse.aether.impl.scope.BuildScopeQuery;
import org.eclipse.aether.impl.scope.BuildScopeSource;
import org.eclipse.aether.impl.scope.CommonBuilds;
import org.eclipse.aether.impl.scope.InternalScopeManager;
import org.eclipse.aether.impl.scope.ProjectPath;
import org.eclipse.aether.impl.scope.ScopeManagerConfiguration;
import org.eclipse.aether.internal.impl.scope.ScopeManagerDump;
import org.eclipse.aether.scope.DependencyScope;
import org.eclipse.aether.scope.ResolutionScope;

public final class Maven4ScopeManagerConfiguration
implements ScopeManagerConfiguration {
    public static final Maven4ScopeManagerConfiguration INSTANCE = new Maven4ScopeManagerConfiguration();
    public static final String RS_NONE = "none";
    public static final String RS_MAIN_COMPILE = "main-compile";
    public static final String RS_MAIN_COMPILE_PLUS_RUNTIME = "main-compilePlusRuntime";
    public static final String RS_MAIN_RUNTIME = "main-runtime";
    public static final String RS_MAIN_RUNTIME_PLUS_SYSTEM = "main-runtimePlusSystem";
    public static final String RS_TEST_COMPILE = "test-compile";
    public static final String RS_TEST_RUNTIME = "test-runtime";

    private Maven4ScopeManagerConfiguration() {
    }

    public String getId() {
        return "Maven4";
    }

    public boolean isStrictDependencyScopes() {
        return false;
    }

    public boolean isStrictResolutionScopes() {
        return false;
    }

    public BuildScopeSource getBuildScopeSource() {
        return new BuildScopeMatrixSource(Arrays.asList(CommonBuilds.PROJECT_PATH_MAIN, CommonBuilds.PROJECT_PATH_TEST), Arrays.asList(CommonBuilds.BUILD_PATH_COMPILE, CommonBuilds.BUILD_PATH_RUNTIME), new BuildScope[0]);
    }

    public Collection<DependencyScope> buildDependencyScopes(InternalScopeManager internalScopeManager) {
        ArrayList<DependencyScope> result = new ArrayList<DependencyScope>();
        result.add(internalScopeManager.createDependencyScope(org.apache.maven.api.DependencyScope.COMPILE.id(), org.apache.maven.api.DependencyScope.COMPILE.isTransitive(), BuildScopeQuery.all()));
        result.add(internalScopeManager.createDependencyScope(org.apache.maven.api.DependencyScope.RUNTIME.id(), org.apache.maven.api.DependencyScope.RUNTIME.isTransitive(), BuildScopeQuery.byBuildPath((BuildPath)CommonBuilds.BUILD_PATH_RUNTIME)));
        result.add(internalScopeManager.createDependencyScope(org.apache.maven.api.DependencyScope.PROVIDED.id(), org.apache.maven.api.DependencyScope.PROVIDED.isTransitive(), BuildScopeQuery.union((Collection[])new Collection[]{BuildScopeQuery.byBuildPath((BuildPath)CommonBuilds.BUILD_PATH_COMPILE), BuildScopeQuery.select((ProjectPath)CommonBuilds.PROJECT_PATH_TEST, (BuildPath)CommonBuilds.BUILD_PATH_RUNTIME)})));
        result.add(internalScopeManager.createDependencyScope(org.apache.maven.api.DependencyScope.TEST.id(), org.apache.maven.api.DependencyScope.TEST.isTransitive(), BuildScopeQuery.byProjectPath((ProjectPath)CommonBuilds.PROJECT_PATH_TEST)));
        result.add(internalScopeManager.createDependencyScope(org.apache.maven.api.DependencyScope.NONE.id(), org.apache.maven.api.DependencyScope.NONE.isTransitive(), Collections.emptySet()));
        result.add(internalScopeManager.createDependencyScope(org.apache.maven.api.DependencyScope.COMPILE_ONLY.id(), org.apache.maven.api.DependencyScope.COMPILE_ONLY.isTransitive(), BuildScopeQuery.singleton((ProjectPath)CommonBuilds.PROJECT_PATH_MAIN, (BuildPath)CommonBuilds.BUILD_PATH_COMPILE)));
        result.add(internalScopeManager.createDependencyScope(org.apache.maven.api.DependencyScope.TEST_RUNTIME.id(), org.apache.maven.api.DependencyScope.TEST_RUNTIME.isTransitive(), BuildScopeQuery.singleton((ProjectPath)CommonBuilds.PROJECT_PATH_TEST, (BuildPath)CommonBuilds.BUILD_PATH_RUNTIME)));
        result.add(internalScopeManager.createDependencyScope(org.apache.maven.api.DependencyScope.TEST_ONLY.id(), org.apache.maven.api.DependencyScope.TEST_ONLY.isTransitive(), BuildScopeQuery.singleton((ProjectPath)CommonBuilds.PROJECT_PATH_TEST, (BuildPath)CommonBuilds.BUILD_PATH_COMPILE)));
        result.add((DependencyScope)internalScopeManager.createSystemDependencyScope(org.apache.maven.api.DependencyScope.SYSTEM.id(), org.apache.maven.api.DependencyScope.SYSTEM.isTransitive(), BuildScopeQuery.all(), "localPath"));
        if (result.size() != org.apache.maven.api.DependencyScope.values().length - 1) {
            throw new IllegalStateException("Maven4 API dependency scope mismatch");
        }
        return result;
    }

    public Collection<ResolutionScope> buildResolutionScopes(InternalScopeManager internalScopeManager) {
        Collection allDependencyScopes = internalScopeManager.getDependencyScopeUniverse();
        Collection nonTransitiveDependencyScopes = allDependencyScopes.stream().filter(s -> !s.isTransitive()).collect(Collectors.toSet());
        DependencyScope system = internalScopeManager.getDependencyScope(org.apache.maven.api.DependencyScope.SYSTEM.id()).orElse(null);
        ArrayList<ResolutionScope> result = new ArrayList<ResolutionScope>();
        result.add(internalScopeManager.createResolutionScope(RS_NONE, InternalScopeManager.Mode.REMOVE, Collections.emptySet(), Collections.emptySet(), allDependencyScopes));
        result.add(internalScopeManager.createResolutionScope(RS_MAIN_COMPILE, InternalScopeManager.Mode.ELIMINATE, BuildScopeQuery.singleton((ProjectPath)CommonBuilds.PROJECT_PATH_MAIN, (BuildPath)CommonBuilds.BUILD_PATH_COMPILE), Collections.singletonList(system), nonTransitiveDependencyScopes));
        result.add(internalScopeManager.createResolutionScope(RS_MAIN_COMPILE_PLUS_RUNTIME, InternalScopeManager.Mode.ELIMINATE, BuildScopeQuery.byProjectPath((ProjectPath)CommonBuilds.PROJECT_PATH_MAIN), Collections.singletonList(system), nonTransitiveDependencyScopes));
        result.add(internalScopeManager.createResolutionScope(RS_MAIN_RUNTIME, InternalScopeManager.Mode.REMOVE, BuildScopeQuery.singleton((ProjectPath)CommonBuilds.PROJECT_PATH_MAIN, (BuildPath)CommonBuilds.BUILD_PATH_RUNTIME), Collections.emptySet(), nonTransitiveDependencyScopes));
        result.add(internalScopeManager.createResolutionScope(RS_MAIN_RUNTIME_PLUS_SYSTEM, InternalScopeManager.Mode.REMOVE, BuildScopeQuery.singleton((ProjectPath)CommonBuilds.PROJECT_PATH_MAIN, (BuildPath)CommonBuilds.BUILD_PATH_RUNTIME), Collections.singletonList(system), nonTransitiveDependencyScopes));
        result.add(internalScopeManager.createResolutionScope(RS_TEST_COMPILE, InternalScopeManager.Mode.ELIMINATE, BuildScopeQuery.select((ProjectPath)CommonBuilds.PROJECT_PATH_TEST, (BuildPath)CommonBuilds.BUILD_PATH_COMPILE), Collections.singletonList(system), nonTransitiveDependencyScopes));
        result.add(internalScopeManager.createResolutionScope(RS_TEST_RUNTIME, InternalScopeManager.Mode.ELIMINATE, BuildScopeQuery.select((ProjectPath)CommonBuilds.PROJECT_PATH_TEST, (BuildPath)CommonBuilds.BUILD_PATH_RUNTIME), Collections.singletonList(system), nonTransitiveDependencyScopes));
        return result;
    }

    public static void main(String ... args) {
        ScopeManagerDump.dump((ScopeManagerConfiguration)INSTANCE);
    }
}

