/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl.scope;

import java.util.Collection;
import java.util.Objects;
import org.eclipse.aether.collection.DependencyCollectionContext;
import org.eclipse.aether.collection.DependencySelector;
import org.eclipse.aether.graph.Dependency;

public final class ScopeDependencySelector
implements DependencySelector {
    private final int seed;
    private final boolean shiftIfRootNull;
    private final int depth;
    private final int applyFrom;
    private final int applyTo;
    private final Collection<String> included;
    private final Collection<String> excluded;

    public static ScopeDependencySelector legacy(Collection<String> included, Collection<String> excluded) {
        return new ScopeDependencySelector(Objects.hash(true, 0, 1, Integer.MAX_VALUE, included, excluded), true, 0, 1, Integer.MAX_VALUE, included, excluded);
    }

    public static ScopeDependencySelector fromRoot(Collection<String> included, Collection<String> excluded) {
        return ScopeDependencySelector.from(1, included, excluded);
    }

    public static ScopeDependencySelector fromDirect(Collection<String> included, Collection<String> excluded) {
        return ScopeDependencySelector.from(2, included, excluded);
    }

    public static ScopeDependencySelector from(int applyFrom, Collection<String> included, Collection<String> excluded) {
        return ScopeDependencySelector.fromTo(applyFrom, Integer.MAX_VALUE, included, excluded);
    }

    public static ScopeDependencySelector fromTo(int applyFrom, int applyTo, Collection<String> included, Collection<String> excluded) {
        if (applyFrom < 1) {
            throw new IllegalArgumentException("applyFrom must be non-zero and positive");
        }
        if (applyFrom > applyTo) {
            throw new IllegalArgumentException("applyTo must be greater or equal than applyFrom");
        }
        return new ScopeDependencySelector(Objects.hash(false, 0, applyFrom, applyTo, included, excluded), false, 0, applyFrom, applyTo, included, excluded);
    }

    private ScopeDependencySelector(int seed, boolean shiftIfRootNull, int depth, int applyFrom, int applyTo, Collection<String> included, Collection<String> excluded) {
        this.seed = seed;
        this.shiftIfRootNull = shiftIfRootNull;
        this.depth = depth;
        this.applyFrom = applyFrom;
        this.applyTo = applyTo;
        this.included = included;
        this.excluded = excluded;
    }

    public boolean selectDependency(Dependency dependency) {
        Objects.requireNonNull(dependency, "dependency cannot be null");
        if (this.depth < this.applyFrom || this.depth > this.applyTo) {
            return true;
        }
        String scope = dependency.getScope();
        return !(this.included != null && !this.included.contains(scope) || this.excluded != null && this.excluded.contains(scope));
    }

    public DependencySelector deriveChildSelector(DependencyCollectionContext context) {
        Objects.requireNonNull(context, "context cannot be null");
        if (this.depth == 0 && this.shiftIfRootNull && context.getDependency() == null) {
            return new ScopeDependencySelector(this.seed, this.shiftIfRootNull, this.depth + 1, this.applyFrom + 1, this.applyTo, this.included, this.excluded);
        }
        return new ScopeDependencySelector(this.seed, this.shiftIfRootNull, this.depth + 1, this.applyFrom, this.applyTo, this.included, this.excluded);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (null == obj || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        ScopeDependencySelector that = (ScopeDependencySelector)obj;
        return this.seed == that.seed && this.shiftIfRootNull == that.shiftIfRootNull && this.depth == that.depth && this.applyFrom == that.applyFrom && this.applyTo == that.applyTo && Objects.equals(this.included, that.included) && Objects.equals(this.excluded, that.excluded);
    }

    public int hashCode() {
        int hash = 17;
        hash = hash * 31 + this.seed;
        hash = hash * 31 + (this.shiftIfRootNull ? 0 : 1);
        hash = hash * 31 + this.depth;
        hash = hash * 31 + this.applyFrom;
        hash = hash * 31 + this.applyTo;
        hash = hash * 31 + (this.included != null ? this.included.hashCode() : 0);
        hash = hash * 31 + (this.excluded != null ? this.excluded.hashCode() : 0);
        return hash;
    }

    public String toString() {
        return String.format("%s(included: %s, excluded: %s, applied: %s)", this.getClass().getSimpleName(), this.included, this.excluded, this.depth >= this.applyFrom);
    }
}

