/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.components.secdispatcher;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.time.Duration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PinEntry {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String cmd;
    private final LinkedHashMap<String, String> commands;

    public PinEntry(String cmd) {
        this.cmd = Objects.requireNonNull(cmd);
        this.commands = new LinkedHashMap();
    }

    public PinEntry setKeyInfo(String keyInfo) {
        Objects.requireNonNull(keyInfo);
        this.commands.put("OPTION", "allow-external-password-cache");
        this.commands.put("SETKEYINFO", keyInfo);
        return this;
    }

    public PinEntry setOk(String msg) {
        Objects.requireNonNull(msg);
        this.commands.put("SETOK", msg);
        return this;
    }

    public PinEntry setCancel(String msg) {
        Objects.requireNonNull(msg);
        this.commands.put("SETCANCEL", msg);
        return this;
    }

    public PinEntry setTitle(String title) {
        Objects.requireNonNull(title);
        this.commands.put("SETTITLE", title);
        return this;
    }

    public PinEntry setDescription(String desc) {
        Objects.requireNonNull(desc);
        this.commands.put("SETDESC", desc);
        return this;
    }

    public PinEntry setPrompt(String prompt) {
        Objects.requireNonNull(prompt);
        this.commands.put("SETPROMPT", prompt);
        return this;
    }

    public PinEntry setError(String error) {
        Objects.requireNonNull(error);
        this.commands.put("SETERROR", error);
        return this;
    }

    public PinEntry confirmPin() {
        this.commands.put("SETREPEAT", null);
        return this;
    }

    public PinEntry setTimeout(Duration timeout) {
        long seconds = timeout.toSeconds();
        if (seconds < 0L) {
            throw new IllegalArgumentException("Set timeout is 0 seconds");
        }
        this.commands.put("SETTIMEOUT", String.valueOf(seconds));
        return this;
    }

    public Result getPin() throws IOException {
        this.commands.put("GETPIN", null);
        return this.execute();
    }

    public Result confirm() throws IOException {
        this.commands.put("CONFIRM", null);
        return this.execute();
    }

    public Result message() throws IOException {
        this.commands.put("MESSAGE", null);
        return this.execute();
    }

    private Result execute() throws IOException {
        Process process = new ProcessBuilder(this.cmd).start();
        BufferedReader reader = process.inputReader();
        BufferedWriter writer = process.outputWriter();
        this.expectOK(process.inputReader());
        Map.Entry<String, String> lastEntry = this.commands.entrySet().iterator().next();
        for (Map.Entry<String, String> entry : this.commands.entrySet()) {
            Object cmd = entry.getValue() != null ? entry.getKey() + " " + entry.getValue() : entry.getKey();
            this.logger.debug("> {}", cmd);
            writer.write((String)cmd);
            writer.newLine();
            writer.flush();
            if (entry == lastEntry) continue;
            this.expectOK(reader);
        }
        Result result = this.lastExpect(reader);
        writer.write("BYE");
        writer.newLine();
        writer.flush();
        try {
            process.waitFor(5L, TimeUnit.SECONDS);
            int exitCode = process.exitValue();
            if (exitCode != 0) {
                return new Result(Outcome.FAILED, "Exit code: " + exitCode);
            }
            return result;
        }
        catch (Exception e) {
            return new Result(Outcome.FAILED, e.getMessage());
        }
    }

    private void expectOK(BufferedReader in) throws IOException {
        String response = in.readLine();
        this.logger.debug("< {}", (Object)response);
        if (!response.startsWith("OK")) {
            throw new IOException("Expected OK but got this instead: " + response);
        }
    }

    private Result lastExpect(BufferedReader in) throws IOException {
        String response;
        while (true) {
            response = in.readLine();
            this.logger.debug("< {}", (Object)response);
            if (response.startsWith("#") || response.startsWith("S")) continue;
            if (response.startsWith("ERR")) {
                if (response.contains("83886142")) {
                    return new Result(Outcome.TIMEOUT, response);
                }
                if (response.contains("83886179")) {
                    return new Result(Outcome.CANCELED, response);
                }
                if (response.contains("83886194")) {
                    return new Result(Outcome.NOT_CONFIRMED, response);
                }
            }
            if (response.startsWith("D")) {
                return new Result(Outcome.SUCCESS, response.substring(2));
            }
            if (response.startsWith("OK")) break;
        }
        return new Result(Outcome.SUCCESS, response);
    }

    public static void main(String[] args) throws IOException {
        String cmd = "/usr/bin/pinentry-gnome3";
        Result pinResult = new PinEntry(cmd).setTimeout(Duration.ofSeconds(15L)).setKeyInfo("maven:masterPassword").setTitle("Maven Master Password").setDescription("Please enter the Maven master password").setPrompt("Password").setOk("Here you go!").setCancel("Uh oh, rather not").getPin();
        if (pinResult.outcome() == Outcome.SUCCESS) {
            Result confirmResult = new PinEntry(cmd).setTitle("Password confirmation").setPrompt("Please confirm the password").setDescription("Is the password '" + pinResult.payload() + "' the one you want?").confirm();
            if (confirmResult.outcome() == Outcome.SUCCESS) {
                new PinEntry(cmd).setTitle("Password confirmed").setPrompt("The password '" + pinResult.payload() + "' is confirmed.").setDescription("You confirmed your password").message();
            } else {
                System.out.println(confirmResult);
            }
        } else {
            System.out.println(pinResult);
        }
    }

    public record Result(Outcome outcome, String payload) {
    }

    public static enum Outcome {
        SUCCESS,
        TIMEOUT,
        NOT_CONFIRMED,
        CANCELED,
        FAILED;

    }
}

