/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.ml;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;

public class PreviewDatafeedResponse
implements ToXContentObject {
    private BytesReference preview;

    public static PreviewDatafeedResponse fromXContent(XContentParser parser) throws IOException {
        try (XContentBuilder builder = XContentFactory.jsonBuilder();){
            parser.nextToken();
            builder.copyCurrentStructure(parser);
            PreviewDatafeedResponse previewDatafeedResponse = new PreviewDatafeedResponse(BytesReference.bytes((XContentBuilder)builder));
            return previewDatafeedResponse;
        }
    }

    public PreviewDatafeedResponse(BytesReference preview) {
        this.preview = preview;
    }

    public BytesReference getPreview() {
        return this.preview;
    }

    public List<Map<String, Object>> getDataList() throws IOException {
        try (StreamInput streamInput = this.preview.streamInput();){
            List<Map<String, Object>> list;
            block16: {
                XContentParser parser;
                block14: {
                    List<Map<String, Object>> list2;
                    block15: {
                        parser = XContentType.JSON.xContent().createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, (InputStream)streamInput);
                        try {
                            XContentParser.Token token = parser.nextToken();
                            if (token != XContentParser.Token.START_ARRAY) break block14;
                            list2 = parser.listOrderedMap().stream().map(obj -> (Map)obj).collect(Collectors.toList());
                            if (parser == null) break block15;
                        }
                        catch (Throwable throwable) {
                            if (parser != null) {
                                try {
                                    parser.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        parser.close();
                    }
                    return list2;
                }
                list = Collections.singletonList(parser.mapOrdered());
                if (parser == null) break block16;
                parser.close();
            }
            return list;
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        try (StreamInput stream = this.preview.streamInput();){
            builder.rawValue((InputStream)stream, XContentType.JSON);
        }
        return builder;
    }

    public int hashCode() {
        return Objects.hash(this.preview);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PreviewDatafeedResponse other = (PreviewDatafeedResponse)obj;
        return Objects.equals(this.preview, other.preview);
    }

    public final String toString() {
        return Strings.toString((ToXContent)this);
    }
}

