/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authentication.unix.jaas;

import java.security.Principal;
import java.util.Collections;
import java.util.Set;
import org.jvnet.libpam.UnixUser;

public class PamPrincipal
implements Principal {
    private String _userName;
    private String _gecos;
    private String _homeDir;
    private String _shell;
    private int _uid;
    private int _gid;
    private Set<String> _groups;

    public PamPrincipal(UnixUser user) {
        this._userName = user.getUserName();
        this._gecos = user.getGecos();
        this._homeDir = user.getDir();
        this._shell = user.getShell();
        this._uid = user.getUID();
        this._gid = user.getGID();
        this._groups = Collections.unmodifiableSet(user.getGroups());
    }

    @Override
    public String getName() {
        return this._userName;
    }

    public String getGecos() {
        return this._gecos;
    }

    public String getHomeDir() {
        return this._homeDir;
    }

    public String getShell() {
        return this._shell;
    }

    public int getUid() {
        return this._uid;
    }

    public int getGid() {
        return this._gid;
    }

    public Set<String> getGroups() {
        return this._groups;
    }
}

