/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.errorprone.annotations.FormatMethod;
import java.util.List;
import java.util.Objects;

public final class QueryId {
    private final String id;

    @JsonCreator
    public static QueryId valueOf(String queryId) {
        return new QueryId(queryId);
    }

    public QueryId(String id) {
        this.id = QueryId.validateId(id);
    }

    public String getId() {
        return this.id;
    }

    @JsonValue
    public String toString() {
        return this.id;
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        QueryId other = (QueryId)obj;
        return Objects.equals(this.id, other.id);
    }

    private static boolean isValidId(String id) {
        for (int i = 0; i < id.length(); ++i) {
            char c = id.charAt(i);
            if (c == '_' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    public static String validateId(String id) {
        Objects.requireNonNull(id, "id is null");
        QueryId.checkArgument(!id.isEmpty(), "id is empty", new Object[0]);
        QueryId.checkArgument(QueryId.isValidId(id), "Invalid id %s", id);
        return id;
    }

    public static List<String> parseDottedId(String id, int expectedParts, String name) {
        Objects.requireNonNull(id, "id is null");
        QueryId.checkArgument(expectedParts > 0, "expectedParts must be at least 1", new Object[0]);
        Objects.requireNonNull(name, "name is null");
        List<String> ids = List.of(id.split("\\."));
        QueryId.checkArgument(ids.size() == expectedParts, "Invalid %s %s", name, id);
        for (String part : ids) {
            QueryId.validateId(part);
        }
        return ids;
    }

    @FormatMethod
    private static void checkArgument(boolean condition, String message, Object ... messageArgs) {
        if (!condition) {
            throw new IllegalArgumentException(String.format(message, messageArgs));
        }
    }
}

