/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.connector;

import io.trino.spi.connector.ConnectorSplit;
import java.io.Closeable;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public interface ConnectorSplitSource
extends Closeable {
    default public CompletableFuture<ConnectorSplitBatch> getNextBatch(int maxSize) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close();

    public boolean isFinished();

    default public Optional<List<Object>> getTableExecuteSplitsInfo() {
        return Optional.empty();
    }

    public static class ConnectorSplitBatch {
        private final List<ConnectorSplit> splits;
        private final boolean noMoreSplits;

        public ConnectorSplitBatch(List<ConnectorSplit> splits, boolean noMoreSplits) {
            this.splits = Objects.requireNonNull(splits, "splits is null");
            this.noMoreSplits = noMoreSplits;
        }

        public List<ConnectorSplit> getSplits() {
            return this.splits;
        }

        public boolean isNoMoreSplits() {
            return this.noMoreSplits;
        }
    }
}

