/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.type;

import io.trino.spi.block.Block;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.type.AbstractIntType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import java.util.Optional;
import java.util.stream.LongStream;
import java.util.stream.Stream;

public final class IntegerType
extends AbstractIntType {
    public static final IntegerType INTEGER = new IntegerType();

    private IntegerType() {
        super(new TypeSignature("integer", new TypeSignatureParameter[0]));
    }

    @Override
    public Object getObjectValue(ConnectorSession session, Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        return this.getInt(block, position);
    }

    @Override
    public Optional<Type.Range> getRange() {
        return Optional.of(new Type.Range(Integer.MIN_VALUE, Integer.MAX_VALUE));
    }

    @Override
    public Optional<Object> getPreviousValue(Object object) {
        long value = (Long)object;
        IntegerType.checkValueValid(value);
        if (value == Integer.MIN_VALUE) {
            return Optional.empty();
        }
        return Optional.of(value - 1L);
    }

    @Override
    public Optional<Object> getNextValue(Object object) {
        long value = (Long)object;
        IntegerType.checkValueValid(value);
        if (value == Integer.MAX_VALUE) {
            return Optional.empty();
        }
        return Optional.of(value + 1L);
    }

    @Override
    public Optional<Stream<?>> getDiscreteValues(Type.Range range) {
        return Optional.of(LongStream.rangeClosed((Long)range.getMin(), (Long)range.getMax()).boxed());
    }

    @Override
    public boolean equals(Object other) {
        return other == INTEGER;
    }

    @Override
    public int hashCode() {
        return this.getClass().hashCode();
    }
}

