/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.type;

import com.fasterxml.jackson.annotation.JsonValue;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.Timestamps;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Objects;

public final class SqlTimestampWithTimeZone {
    private static final int NANOSECONDS_PER_MILLISECOND = 1000000;
    private static final int PICOSECONDS_PER_NANOSECOND = 1000;
    private final int precision;
    private final long epochMillis;
    private final int picosOfMilli;
    private final TimeZoneKey timeZoneKey;

    public static SqlTimestampWithTimeZone fromInstant(int precision, Instant instant, ZoneId zoneId) {
        return SqlTimestampWithTimeZone.newInstanceWithRounding(precision, instant.toEpochMilli(), instant.getNano() % 1000000 * 1000, TimeZoneKey.getTimeZoneKey(zoneId.getId()));
    }

    public static SqlTimestampWithTimeZone newInstance(int precision, long epochMillis, int picosOfMilli, TimeZoneKey timeZoneKey) {
        if (precision < 0 || precision > 12) {
            throw new IllegalArgumentException("Invalid precision: " + precision);
        }
        if (precision <= 3) {
            if (picosOfMilli != 0) {
                throw new IllegalArgumentException(String.format("Expected picosOfMilli to be 0 for precision %s: %s", precision, picosOfMilli));
            }
            if (Timestamps.round(epochMillis, 3 - precision) != epochMillis) {
                throw new IllegalArgumentException(String.format("Expected 0s for digits beyond precision %s: epochMillis = %s", precision, epochMillis));
            }
        } else if (Timestamps.round(picosOfMilli, 12 - precision) != (long)picosOfMilli) {
            throw new IllegalArgumentException(String.format("Expected 0s for digits beyond precision %s: picosOfMilli = %s", precision, picosOfMilli));
        }
        if (picosOfMilli < 0 || picosOfMilli > 1000000000) {
            throw new IllegalArgumentException("picosOfMilli is out of range: " + picosOfMilli);
        }
        return new SqlTimestampWithTimeZone(precision, epochMillis, picosOfMilli, timeZoneKey);
    }

    private static SqlTimestampWithTimeZone newInstanceWithRounding(int precision, long epochMillis, int picosOfMilli, TimeZoneKey sessionTimeZoneKey) {
        if (precision < 0 || precision > 12) {
            throw new IllegalArgumentException("Invalid precision: " + precision);
        }
        if (precision < 3) {
            epochMillis = Timestamps.round(epochMillis, 3 - precision);
            picosOfMilli = 0;
        } else if (precision == 3) {
            if (Timestamps.round(picosOfMilli, 12 - precision) == 1000000000L) {
                ++epochMillis;
            }
            picosOfMilli = 0;
        } else {
            picosOfMilli = (int)Timestamps.round(picosOfMilli, 12 - precision);
        }
        return new SqlTimestampWithTimeZone(precision, epochMillis, picosOfMilli, sessionTimeZoneKey);
    }

    SqlTimestampWithTimeZone(int precision, long epochMillis, int picosOfMilli, TimeZoneKey timeZoneKey) {
        this.precision = precision;
        this.epochMillis = epochMillis;
        this.picosOfMilli = picosOfMilli;
        this.timeZoneKey = Objects.requireNonNull(timeZoneKey, "timeZoneKey is null");
    }

    public int getPrecision() {
        return this.precision;
    }

    public long getEpochMillis() {
        return this.epochMillis;
    }

    public int getPicosOfMilli() {
        return this.picosOfMilli;
    }

    public long getMillisUtc() {
        return this.epochMillis;
    }

    public TimeZoneKey getTimeZoneKey() {
        return this.timeZoneKey;
    }

    public SqlTimestampWithTimeZone roundTo(int precision) {
        return SqlTimestampWithTimeZone.newInstanceWithRounding(precision, this.epochMillis, this.picosOfMilli, this.timeZoneKey);
    }

    @JsonValue
    public String toString() {
        return Timestamps.formatTimestampWithTimeZone(this.precision, this.epochMillis, this.picosOfMilli, this.timeZoneKey.getZoneId());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SqlTimestampWithTimeZone that = (SqlTimestampWithTimeZone)o;
        return this.precision == that.precision && this.epochMillis == that.epochMillis && this.picosOfMilli == that.picosOfMilli && this.timeZoneKey.equals(that.timeZoneKey);
    }

    public int hashCode() {
        return Objects.hash(this.precision, this.epochMillis, this.picosOfMilli, this.timeZoneKey);
    }

    public ZonedDateTime toZonedDateTime() {
        long epochSecond = Math.floorDiv(this.epochMillis, 1000);
        int nanosOfSecond = Math.floorMod(this.epochMillis, 1000) * 1000000 + Timestamps.roundDiv(this.picosOfMilli, 1000L);
        return Instant.ofEpochSecond(epochSecond, nanosOfSecond).atZone(this.timeZoneKey.getZoneId());
    }
}

