/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.services.elasticsearch.client;

import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.ranger.plugin.service.ResourceLookupContext;
import org.apache.ranger.services.elasticsearch.client.ElasticsearchClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticsearchResourceMgr {
    public static final String INDEX = "index";
    private static final Logger LOG = LoggerFactory.getLogger(ElasticsearchResourceMgr.class);

    public static Map<String, Object> validateConfig(String serviceName, Map<String, String> configs) throws Exception {
        Map<String, Object> ret = null;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> ElasticsearchResourceMgr.validateConfig() serviceName: " + serviceName + ", configs: " + configs);
        }
        try {
            ret = ElasticsearchClient.connectionTest(serviceName, configs);
        }
        catch (Exception e) {
            LOG.error("<== ElasticsearchResourceMgr.validateConfig() error: " + e);
            throw e;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== ElasticsearchResourceMgr.validateConfig() result: " + ret);
        }
        return ret;
    }

    public static List<String> getElasticsearchResources(String serviceName, Map<String, String> configs, ResourceLookupContext context) {
        ElasticsearchClient elasticsearchClient;
        String userInput = context.getUserInput();
        String resource = context.getResourceName();
        Map resourceMap = context.getResources();
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> ElasticsearchResourceMgr.getElasticsearchResources()  userInput: " + userInput + ", resource: " + resource + ", resourceMap: " + resourceMap);
        }
        if (MapUtils.isEmpty(configs)) {
            LOG.error("Connection config is empty!");
            return null;
        }
        if (StringUtils.isEmpty((String)userInput)) {
            LOG.warn("User input is empty, set default value : *");
            userInput = "*";
        }
        if ((elasticsearchClient = ElasticsearchClient.getElasticsearchClient(serviceName, configs)) == null) {
            LOG.error("Failed to getElasticsearchResources!");
            return null;
        }
        List<String> resultList = null;
        if (StringUtils.isNotEmpty((String)resource)) {
            switch (resource) {
                case "index": {
                    List existingConnectors = (List)resourceMap.get(INDEX);
                    resultList = elasticsearchClient.getIndexList(userInput, existingConnectors);
                    break;
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== ElasticsearchResourceMgr.getElasticsearchResources() result: " + resultList);
        }
        return resultList;
    }
}

