/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.services.presto.client;

import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.apache.ranger.plugin.util.TimedEventUtil;
import org.apache.ranger.services.presto.client.PrestoClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrestoConnectionManager {
    private static final Logger LOG = LoggerFactory.getLogger(PrestoConnectionManager.class);
    protected ConcurrentMap<String, PrestoClient> prestoConnectionCache = new ConcurrentHashMap<String, PrestoClient>();
    protected ConcurrentMap<String, Boolean> repoConnectStatusMap = new ConcurrentHashMap<String, Boolean>();

    public PrestoClient getPrestoConnection(final String serviceName, String serviceType, final Map<String, String> configs) {
        PrestoClient prestoClient = null;
        if (serviceType != null) {
            prestoClient = (PrestoClient)this.prestoConnectionCache.get(serviceName);
            if (prestoClient == null) {
                if (configs != null) {
                    Callable<PrestoClient> connectPresto = new Callable<PrestoClient>(){

                        @Override
                        public PrestoClient call() throws Exception {
                            return new PrestoClient(serviceName, configs);
                        }
                    };
                    try {
                        prestoClient = (PrestoClient)TimedEventUtil.timedTask((Callable)connectPresto, (long)5L, (TimeUnit)TimeUnit.SECONDS);
                    }
                    catch (Exception e) {
                        LOG.error("Error connecting to Presto repository: " + serviceName + " using config: " + configs, (Throwable)e);
                    }
                    PrestoClient oldClient = null;
                    oldClient = prestoClient != null ? this.prestoConnectionCache.putIfAbsent(serviceName, prestoClient) : (PrestoClient)this.prestoConnectionCache.get(serviceName);
                    if (oldClient != null) {
                        if (prestoClient != null) {
                            prestoClient.close();
                        }
                        prestoClient = oldClient;
                    }
                    this.repoConnectStatusMap.put(serviceName, true);
                } else {
                    LOG.error("Connection Config not defined for asset :" + serviceName, new Throwable());
                }
            } else {
                try {
                    prestoClient.getCatalogList("*", null);
                }
                catch (Exception e) {
                    this.prestoConnectionCache.remove(serviceName);
                    prestoClient.close();
                    prestoClient = this.getPrestoConnection(serviceName, serviceType, configs);
                }
            }
        } else {
            LOG.error("Asset not found with name " + serviceName, new Throwable());
        }
        return prestoClient;
    }
}

