/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common.ndv.hll;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.hive.common.ndv.NumDistinctValueEstimator;
import org.apache.hadoop.hive.common.ndv.hll.HLLConstants;
import org.apache.hadoop.hive.common.ndv.hll.HLLDenseRegister;
import org.apache.hadoop.hive.common.ndv.hll.HLLSparseRegister;
import org.apache.hadoop.hive.common.ndv.hll.HyperLogLogUtils;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.util.JavaDataModel;
import org.apache.hive.common.util.Murmur3;

public class HyperLogLog
implements NumDistinctValueEstimator {
    private static final int DEFAULT_HASH_BITS = 64;
    private static final long HASH64_ZERO = Murmur3.hash64(new byte[]{0});
    private static final long HASH64_ONE = Murmur3.hash64(new byte[]{1});
    private final int p;
    private final int m;
    private float alphaMM;
    private final boolean noBias;
    private final boolean bitPacking;
    private final int chosenHashBits = 64;
    private HLLDenseRegister denseRegister;
    private HLLSparseRegister sparseRegister;
    private long cachedCount;
    private boolean invalidateCount;
    private EncodingType encoding;
    private int encodingSwitchThreshold;

    private HyperLogLog(HyperLogLogBuilder hllBuilder) {
        if (hllBuilder.numRegisterIndexBits < 4 || hllBuilder.numRegisterIndexBits > 16) {
            throw new IllegalArgumentException("p value should be between 4 to 16");
        }
        this.p = hllBuilder.numRegisterIndexBits;
        this.m = 1 << this.p;
        this.noBias = hllBuilder.noBias;
        this.bitPacking = hllBuilder.bitPacking;
        this.encodingSwitchThreshold = this.bitPacking ? this.m * 6 / 8 / 5 : this.m / 3;
        this.alphaMM = 0.7213f / (1.0f + 1.079f / (float)this.m);
        this.alphaMM = this.alphaMM * (float)this.m * (float)this.m;
        this.cachedCount = -1L;
        this.invalidateCount = false;
        this.encoding = hllBuilder.encoding;
        if (this.encoding.equals((Object)EncodingType.SPARSE)) {
            this.sparseRegister = new HLLSparseRegister(this.p, 25, 6);
            this.denseRegister = null;
        } else {
            this.sparseRegister = null;
            this.denseRegister = new HLLDenseRegister(this.p, this.bitPacking);
        }
    }

    public static HyperLogLogBuilder builder() {
        return new HyperLogLogBuilder();
    }

    private void initializeAlpha(int hashBits) {
        this.alphaMM = hashBits <= 16 ? 0.673f : (hashBits <= 32 ? 0.697f : (hashBits <= 64 ? 0.709f : 0.7213f / (1.0f + 1.079f / (float)this.m)));
        this.alphaMM = this.alphaMM * (float)this.m * (float)this.m;
    }

    public void addBoolean(boolean val) {
        this.add(val ? HASH64_ONE : HASH64_ZERO);
    }

    public void addByte(byte val) {
        this.add(Murmur3.hash64(new byte[]{val}));
    }

    public void addBytes(byte[] val) {
        this.add(Murmur3.hash64(val));
    }

    public void addShort(short val) {
        this.add(Murmur3.hash64(val));
    }

    public void addInt(int val) {
        this.add(Murmur3.hash64(val));
    }

    public void addLong(long val) {
        this.add(Murmur3.hash64(val));
    }

    public void addFloat(float val) {
        this.add(Murmur3.hash64(Float.floatToIntBits(val)));
    }

    public void addDouble(double val) {
        this.add(Murmur3.hash64(Double.doubleToLongBits(val)));
    }

    public void addChar(char val) {
        this.add(Murmur3.hash64((short)val));
    }

    public void addString(String val) {
        this.add(Murmur3.hash64(val.getBytes()));
    }

    public void addString(String val, Charset charset) {
        this.add(Murmur3.hash64(val.getBytes(charset)));
    }

    public void add(long hashcode) {
        if (this.encoding.equals((Object)EncodingType.SPARSE)) {
            if (this.sparseRegister.add(hashcode)) {
                this.invalidateCount = true;
            }
            if (this.sparseRegister.getSize() > this.encodingSwitchThreshold) {
                this.encoding = EncodingType.DENSE;
                this.denseRegister = this.sparseToDenseRegister(this.sparseRegister);
                this.sparseRegister = null;
                this.invalidateCount = true;
            }
        } else if (this.denseRegister.add(hashcode)) {
            this.invalidateCount = true;
        }
    }

    @Override
    public long estimateNumDistinctValues() {
        return this.count() > 0L ? this.count() : 1L;
    }

    public long count() {
        if (this.invalidateCount || this.cachedCount < 0L) {
            if (this.encoding.equals((Object)EncodingType.SPARSE)) {
                int mPrime = 1 << this.sparseRegister.getPPrime();
                this.cachedCount = this.linearCount(mPrime, mPrime - this.sparseRegister.getSparseMap().size());
            } else {
                double sum = this.denseRegister.getSumInversePow2();
                long numZeros = this.denseRegister.getNumZeroes();
                this.cachedCount = (long)((double)this.alphaMM * (1.0 / sum));
                long pow = (long)Math.pow(2.0, 64.0);
                if (this.noBias) {
                    long h = this.cachedCount = this.cachedCount <= (long)(5 * this.m) ? this.cachedCount - this.estimateBias(this.cachedCount) : this.cachedCount;
                    if (numZeros != 0L) {
                        h = this.linearCount(this.m, numZeros);
                    }
                    if (h < this.getThreshold()) {
                        this.cachedCount = h;
                    }
                } else if ((double)this.cachedCount <= 2.5 * (double)this.m && numZeros != 0L) {
                    this.cachedCount = this.linearCount(this.m, numZeros);
                }
            }
            this.invalidateCount = false;
        }
        return this.cachedCount;
    }

    private long getThreshold() {
        return (long)(HLLConstants.thresholdData[this.p - 4] + 0.5);
    }

    private long estimateBias(long count) {
        double[] rawEstForP = HLLConstants.rawEstimateData[this.p - 4];
        TreeMap<Double, Integer> estIndexMap = new TreeMap<Double, Integer>();
        double distance = 0.0;
        for (int i = 0; i < rawEstForP.length; ++i) {
            distance = Math.pow((double)count - rawEstForP[i], 2.0);
            estIndexMap.put(distance, i);
        }
        long result = 0L;
        double[] biasForP = HLLConstants.biasData[this.p - 4];
        double biasSum = 0.0;
        int kNeighbors = 6;
        for (Map.Entry entry : estIndexMap.entrySet()) {
            biasSum += biasForP[(Integer)entry.getValue()];
            if (--kNeighbors > 0) continue;
            break;
        }
        result = (long)(biasSum / 6.0 + 0.5);
        return result;
    }

    public void setCount(long count) {
        this.cachedCount = count;
        this.invalidateCount = true;
    }

    private long linearCount(int mVal, long numZeros) {
        return Math.round((double)mVal * Math.log((double)mVal / (double)numZeros));
    }

    public double getStandardError() {
        return 1.04 / Math.sqrt(this.m);
    }

    public HLLDenseRegister getHLLDenseRegister() {
        return this.denseRegister;
    }

    public HLLSparseRegister getHLLSparseRegister() {
        return this.sparseRegister;
    }

    public void setHLLSparseRegister(int[] reg) {
        for (int i : reg) {
            int key = i >>> 6;
            byte value = (byte)(i & 0x3F);
            this.sparseRegister.set(key, value);
        }
    }

    public void setHLLDenseRegister(byte[] reg) {
        int i = 0;
        for (byte b : reg) {
            this.denseRegister.set(i, b);
            ++i;
        }
    }

    public void merge(HyperLogLog hll) {
        if (64 != hll.chosenHashBits) {
            throw new IllegalArgumentException("HyperLogLog cannot be merged as either p or hashbits are different. Current: " + this.toString() + " Provided: " + hll.toString());
        }
        if (this.p > hll.p) {
            throw new IllegalArgumentException("HyperLogLog cannot merge a smaller p into a larger one : " + this.toString() + " Provided: " + hll.toString());
        }
        if (this.p != hll.p) {
            hll = hll.squash(this.p);
        }
        EncodingType otherEncoding = hll.getEncoding();
        if (this.encoding.equals((Object)EncodingType.SPARSE) && otherEncoding.equals((Object)EncodingType.SPARSE)) {
            this.sparseRegister.merge(hll.getHLLSparseRegister());
            if (this.sparseRegister.getSize() > this.encodingSwitchThreshold) {
                this.encoding = EncodingType.DENSE;
                this.denseRegister = this.sparseToDenseRegister(this.sparseRegister);
                this.sparseRegister = null;
            }
        } else if (this.encoding.equals((Object)EncodingType.DENSE) && otherEncoding.equals((Object)EncodingType.DENSE)) {
            this.denseRegister.merge(hll.getHLLDenseRegister());
        } else if (this.encoding.equals((Object)EncodingType.SPARSE) && otherEncoding.equals((Object)EncodingType.DENSE)) {
            this.denseRegister = this.sparseToDenseRegister(this.sparseRegister);
            this.denseRegister.merge(hll.getHLLDenseRegister());
            this.sparseRegister = null;
            this.encoding = EncodingType.DENSE;
        } else if (this.encoding.equals((Object)EncodingType.DENSE) && otherEncoding.equals((Object)EncodingType.SPARSE)) {
            HLLDenseRegister otherDenseRegister = this.sparseToDenseRegister(hll.getHLLSparseRegister());
            this.denseRegister.merge(otherDenseRegister);
        }
        this.invalidateCount = true;
    }

    public HyperLogLog squash(int p0) {
        if (p0 > this.p) {
            throw new IllegalArgumentException("HyperLogLog cannot be be squashed to be bigger. Current: " + this.toString() + " Provided: " + p0);
        }
        if (p0 == this.p) {
            return this;
        }
        HyperLogLog hll = new HyperLogLogBuilder().setNumRegisterIndexBits(p0).setEncoding(EncodingType.DENSE).enableNoBias(this.noBias).build();
        HLLDenseRegister result = hll.denseRegister;
        if (this.encoding == EncodingType.SPARSE) {
            this.sparseRegister.extractLowBitsTo(result);
        } else if (this.encoding == EncodingType.DENSE) {
            this.denseRegister.extractLowBitsTo(result);
        }
        return hll;
    }

    private HLLDenseRegister sparseToDenseRegister(HLLSparseRegister sparseRegister) {
        if (sparseRegister == null) {
            return null;
        }
        int p = sparseRegister.getP();
        int pMask = (1 << p) - 1;
        HLLDenseRegister result = new HLLDenseRegister(p, this.bitPacking);
        for (Map.Entry<Integer, Byte> entry : sparseRegister.getSparseMap().entrySet()) {
            int key = entry.getKey();
            int idx = key & pMask;
            result.set(idx, entry.getValue());
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Encoding: ");
        sb.append((Object)this.encoding);
        sb.append(", p: ");
        sb.append(this.p);
        sb.append(", estimatedCardinality: ");
        sb.append(this.estimateNumDistinctValues());
        return sb.toString();
    }

    public String toStringExtended() {
        if (this.encoding.equals((Object)EncodingType.DENSE)) {
            return this.toString() + ", " + this.denseRegister.toExtendedString();
        }
        if (this.encoding.equals((Object)EncodingType.SPARSE)) {
            return this.toString() + ", " + this.sparseRegister.toExtendedString();
        }
        return this.toString();
    }

    public int getNumRegisterIndexBits() {
        return this.p;
    }

    public EncodingType getEncoding() {
        return this.encoding;
    }

    public void setEncoding(EncodingType encoding) {
        this.encoding = encoding;
    }

    public boolean equals(Object obj) {
        boolean result;
        if (!(obj instanceof HyperLogLog)) {
            return false;
        }
        HyperLogLog other = (HyperLogLog)obj;
        long count = this.estimateNumDistinctValues();
        long otherCount = other.estimateNumDistinctValues();
        boolean bl = result = this.p == other.p && 64 == other.chosenHashBits && this.encoding.equals((Object)other.encoding) && count == otherCount;
        if (this.encoding.equals((Object)EncodingType.DENSE)) {
            boolean bl2 = result = result && this.denseRegister.equals(other.getHLLDenseRegister());
        }
        if (this.encoding.equals((Object)EncodingType.SPARSE)) {
            result = result && this.sparseRegister.equals(other.getHLLSparseRegister());
        }
        return result;
    }

    public int hashCode() {
        int hashcode = 0;
        hashcode += 31 * this.p;
        hashcode += 1984;
        hashcode += this.encoding.hashCode();
        hashcode = (int)((long)hashcode + 31L * this.estimateNumDistinctValues());
        if (this.encoding.equals((Object)EncodingType.DENSE)) {
            hashcode += 31 * this.denseRegister.hashCode();
        }
        if (this.encoding.equals((Object)EncodingType.SPARSE)) {
            hashcode += 31 * this.sparseRegister.hashCode();
        }
        return hashcode;
    }

    @Override
    public void reset() {
    }

    @Override
    public byte[] serialize() {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            HyperLogLogUtils.serializeHLL(bos, this);
            byte[] result = bos.toByteArray();
            bos.close();
            return result;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public NumDistinctValueEstimator deserialize(byte[] buf) {
        return HyperLogLogUtils.deserializeHLL(buf);
    }

    @Override
    public void addToEstimator(long v) {
        this.addLong(v);
    }

    @Override
    public void addToEstimator(String s) {
        this.addString(s);
    }

    @Override
    public void addToEstimator(double d) {
        this.addDouble(d);
    }

    @Override
    public void addToEstimator(HiveDecimal decimal) {
        this.addDouble(decimal.doubleValue());
    }

    @Override
    public void mergeEstimators(NumDistinctValueEstimator o) {
        this.merge((HyperLogLog)o);
    }

    @Override
    public int lengthFor(JavaDataModel model) {
        return 5 + (1 << this.p);
    }

    @Override
    public boolean canMerge(NumDistinctValueEstimator o) {
        return o instanceof HyperLogLog;
    }

    public static class HyperLogLogBuilder {
        private int numRegisterIndexBits = 14;
        private EncodingType encoding = EncodingType.SPARSE;
        private boolean bitPacking = true;
        private boolean noBias = true;

        public HyperLogLogBuilder setNumRegisterIndexBits(int b) {
            this.numRegisterIndexBits = b;
            return this;
        }

        public HyperLogLogBuilder setSizeOptimized() {
            this.numRegisterIndexBits = 10;
            return this;
        }

        public HyperLogLogBuilder setEncoding(EncodingType enc) {
            this.encoding = enc;
            return this;
        }

        public HyperLogLogBuilder enableBitPacking(boolean b) {
            this.bitPacking = b;
            return this;
        }

        public HyperLogLogBuilder enableNoBias(boolean nb) {
            this.noBias = nb;
            return this;
        }

        public HyperLogLog build() {
            return new HyperLogLog(this);
        }
    }

    public static enum EncodingType {
        SPARSE,
        DENSE;

    }
}

