/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluator;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluatorFactory;
import org.apache.hadoop.hive.ql.exec.JoinUtil;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.persistence.AbstractRowContainer;
import org.apache.hadoop.hive.ql.exec.persistence.RowContainer;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.JoinCondDesc;
import org.apache.hadoop.hive.ql.plan.JoinDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.lazybinary.LazyBinarySerDe;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StandardStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CommonJoinOperator<T extends JoinDesc>
extends Operator<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static final Logger LOG = LoggerFactory.getLogger((String)CommonJoinOperator.class.getName());
    protected transient int numAliases;
    protected transient List<ExprNodeEvaluator>[] joinValues;
    protected transient List<ExprNodeEvaluator>[] joinFilters;
    protected transient List<ExprNodeEvaluator> residualJoinFilters;
    protected transient int[][] filterMaps;
    protected transient List<ObjectInspector>[] joinValuesObjectInspectors;
    protected transient List<ObjectInspector>[] joinFilterObjectInspectors;
    protected transient List<ObjectInspector> residualJoinFiltersOIs;
    protected transient boolean needsPostEvaluation;
    protected transient Map<Integer, Object[]> rowContainerPostFilteredOuterJoin = null;
    protected transient List<ObjectInspector>[] joinValuesStandardObjectInspectors;
    protected transient List<ObjectInspector>[] rowContainerStandardObjectInspectors;
    protected transient Byte[] order;
    protected transient JoinCondDesc[] condn;
    protected transient boolean[] nullsafes;
    public transient boolean noOuterJoin;
    protected transient ArrayList<Object>[] dummyObj;
    protected transient RowContainer<List<Object>>[] dummyObjVectors;
    protected transient int totalSz;
    private transient Map<Integer, Set<String>> posToAliasMap;
    transient LazyBinarySerDe[] spillTableSerDe;
    protected transient TableDesc[] spillTableDesc;
    AbstractRowContainer<List<Object>>[] storage;
    int joinEmitInterval = -1;
    int joinCacheSize = 0;
    long nextSz = 0L;
    transient Byte lastAlias = null;
    transient boolean handleSkewJoin = false;
    transient boolean hasLeftSemiJoin = false;
    protected transient int countAfterReport;
    protected transient int heartbeatInterval;
    protected static final int NOTSKIPBIGTABLE = -1;
    private transient boolean closeOpCalled = false;
    protected Configuration hconf;
    transient boolean newGroupStarted = false;
    protected transient Byte alias;
    protected transient Object[] forwardCache;
    protected transient int[] offsets;
    protected transient boolean[][] skipVectors;
    protected transient List[] intermediate;
    protected transient short[] filterTags;
    protected transient short[] aliasFilterTags;

    protected CommonJoinOperator() {
    }

    public CommonJoinOperator(CompilationOpContext ctx) {
        super(ctx);
    }

    public CommonJoinOperator(CommonJoinOperator<T> clone) {
        super(clone.id, clone.cContext);
        this.joinEmitInterval = clone.joinEmitInterval;
        this.joinCacheSize = clone.joinCacheSize;
        this.nextSz = clone.nextSz;
        this.childOperators = clone.childOperators;
        this.parentOperators = clone.parentOperators;
        this.done = clone.done;
        this.storage = clone.storage;
        this.condn = clone.condn;
        this.conf = clone.getConf();
        this.setSchema(clone.getSchema());
        this.alias = clone.alias;
        this.childOperatorsArray = clone.childOperatorsArray;
        this.childOperatorsTag = clone.childOperatorsTag;
        this.setColumnExprMap(clone.getColumnExprMap());
        this.dummyObj = clone.dummyObj;
        this.dummyObjVectors = clone.dummyObjVectors;
        this.forwardCache = clone.forwardCache;
        this.groupKeyObject = clone.groupKeyObject;
        this.handleSkewJoin = clone.handleSkewJoin;
        this.hconf = clone.hconf;
        this.inputObjInspectors = clone.inputObjInspectors;
        this.noOuterJoin = clone.noOuterJoin;
        this.numAliases = clone.numAliases;
        this.operatorId = clone.operatorId;
        this.posToAliasMap = clone.posToAliasMap;
        this.spillTableDesc = clone.spillTableDesc;
        this.statsMap = clone.statsMap;
        this.joinFilters = clone.joinFilters;
        this.joinFilterObjectInspectors = clone.joinFilterObjectInspectors;
        this.residualJoinFilters = clone.residualJoinFilters;
        this.residualJoinFiltersOIs = clone.residualJoinFiltersOIs;
        this.needsPostEvaluation = clone.needsPostEvaluation;
    }

    private <T extends JoinDesc> ObjectInspector getJoinOutputObjectInspector(Byte[] order, List<ObjectInspector>[] aliasToObjectInspectors, T conf) {
        ArrayList<ObjectInspector> structFieldObjectInspectors = new ArrayList<ObjectInspector>();
        for (Byte alias : order) {
            List<ObjectInspector> oiList = this.getValueObjectInspectors(alias, aliasToObjectInspectors);
            if (oiList == null || oiList.isEmpty()) continue;
            structFieldObjectInspectors.addAll(oiList);
        }
        StandardStructObjectInspector joinOutputObjectInspector = ObjectInspectorFactory.getStandardStructObjectInspector(conf.getOutputColumnNames(), structFieldObjectInspectors);
        return joinOutputObjectInspector;
    }

    protected List<ObjectInspector> getValueObjectInspectors(byte alias, List<ObjectInspector>[] aliasToObjectInspectors) {
        return aliasToObjectInspectors[alias];
    }

    @Override
    protected void initializeOp(Configuration hconf) throws HiveException {
        int i;
        super.initializeOp(hconf);
        this.closeOpCalled = false;
        this.handleSkewJoin = ((JoinDesc)this.conf).getHandleSkewJoin();
        this.hconf = hconf;
        this.heartbeatInterval = HiveConf.getIntVar(hconf, HiveConf.ConfVars.HIVESENDHEARTBEAT);
        this.countAfterReport = 0;
        this.totalSz = 0;
        int tagLen = ((JoinDesc)this.conf).getTagLength();
        this.storage = new AbstractRowContainer[tagLen];
        this.numAliases = ((JoinDesc)this.conf).getExprs().size();
        this.joinValues = new List[tagLen];
        this.joinFilters = new List[tagLen];
        this.order = ((JoinDesc)this.conf).getTagOrder();
        this.condn = ((JoinDesc)this.conf).getConds();
        this.nullsafes = ((JoinDesc)this.conf).getNullSafes();
        this.noOuterJoin = ((JoinDesc)this.conf).isNoOuterJoin();
        this.totalSz = JoinUtil.populateJoinKeyValue(this.joinValues, ((JoinDesc)this.conf).getExprs(), this.order, -1, hconf);
        this.joinFilters = new List[tagLen];
        JoinUtil.populateJoinKeyValue(this.joinFilters, ((JoinDesc)this.conf).getFilters(), this.order, -1, hconf);
        this.joinValuesObjectInspectors = JoinUtil.getObjectInspectorsFromEvaluators(this.joinValues, this.inputObjInspectors, -1, tagLen);
        this.joinFilterObjectInspectors = JoinUtil.getObjectInspectorsFromEvaluators(this.joinFilters, this.inputObjInspectors, -1, tagLen);
        this.joinValuesStandardObjectInspectors = JoinUtil.getStandardObjectInspectors(this.joinValuesObjectInspectors, -1, tagLen);
        this.filterMaps = ((JoinDesc)this.conf).getFilterMap();
        if (this.noOuterJoin) {
            this.rowContainerStandardObjectInspectors = this.joinValuesStandardObjectInspectors;
        } else {
            List[] rowContainerObjectInspectors = new List[tagLen];
            for (Byte alias : this.order) {
                ArrayList<ObjectInspector> rcOIs = new ArrayList<ObjectInspector>();
                rcOIs.addAll(this.joinValuesObjectInspectors[alias]);
                rcOIs.add(PrimitiveObjectInspectorFactory.writableShortObjectInspector);
                rowContainerObjectInspectors[alias.byteValue()] = rcOIs;
            }
            this.rowContainerStandardObjectInspectors = JoinUtil.getStandardObjectInspectors(rowContainerObjectInspectors, -1, tagLen);
        }
        this.dummyObj = new ArrayList[this.numAliases];
        this.dummyObjVectors = new RowContainer[this.numAliases];
        this.joinEmitInterval = HiveConf.getIntVar(hconf, HiveConf.ConfVars.HIVEJOINEMITINTERVAL);
        this.joinCacheSize = HiveConf.getIntVar(hconf, HiveConf.ConfVars.HIVEJOINCACHESIZE);
        int pos = 0;
        for (Byte alias : this.order) {
            int sz = ((JoinDesc)this.conf).getExprs().get(alias).size();
            ArrayList<ShortWritable> nr = new ArrayList<ShortWritable>(sz);
            for (int j = 0; j < sz; ++j) {
                nr.add(null);
            }
            if (!this.noOuterJoin) {
                nr.add(new ShortWritable());
            }
            this.dummyObj[pos] = nr;
            RowContainer<List<Object>> values = JoinUtil.getRowContainer(hconf, this.rowContainerStandardObjectInspectors[pos], alias, 1, this.spillTableDesc, (JoinDesc)this.conf, !this.hasFilter(pos), this.reporter);
            values.addRow(this.dummyObj[pos]);
            this.dummyObjVectors[pos] = values;
            RowContainer<List<Object>> rc = JoinUtil.getRowContainer(hconf, this.rowContainerStandardObjectInspectors[pos], alias, this.joinCacheSize, this.spillTableDesc, (JoinDesc)this.conf, !this.hasFilter(pos), this.reporter);
            this.storage[pos] = rc;
            pos = (byte)(pos + 1);
        }
        this.forwardCache = new Object[this.totalSz];
        this.aliasFilterTags = new short[this.numAliases];
        Arrays.fill(this.aliasFilterTags, (short)-1);
        this.filterTags = new short[this.numAliases];
        this.skipVectors = new boolean[this.numAliases][];
        for (int i2 = 0; i2 < this.skipVectors.length; ++i2) {
            this.skipVectors[i2] = new boolean[i2 + 1];
        }
        this.intermediate = new List[this.numAliases];
        this.offsets = new int[this.numAliases + 1];
        int sum = 0;
        for (i = 0; i < this.numAliases; ++i) {
            this.offsets[i] = sum;
            sum += this.joinValues[this.order[i]].size();
        }
        this.offsets[this.numAliases] = sum;
        this.outputObjInspector = this.getJoinOutputObjectInspector(this.order, this.joinValuesStandardObjectInspectors, (JoinDesc)this.conf);
        for (i = 0; i < this.condn.length; ++i) {
            if (this.condn[i].getType() != 5) continue;
            this.hasLeftSemiJoin = true;
        }
        if (((JoinDesc)this.conf).getResidualFilterExprs() != null) {
            this.residualJoinFilters = new ArrayList<ExprNodeEvaluator>(((JoinDesc)this.conf).getResidualFilterExprs().size());
            this.residualJoinFiltersOIs = new ArrayList<ObjectInspector>(((JoinDesc)this.conf).getResidualFilterExprs().size());
            for (i = 0; i < ((JoinDesc)this.conf).getResidualFilterExprs().size(); ++i) {
                ExprNodeDesc expr = ((JoinDesc)this.conf).getResidualFilterExprs().get(i);
                this.residualJoinFilters.add(ExprNodeEvaluatorFactory.get(expr));
                this.residualJoinFiltersOIs.add(this.residualJoinFilters.get(i).initialize(this.outputObjInspector));
            }
            this.needsPostEvaluation = true;
            if (!this.noOuterJoin) {
                this.joinEmitInterval = -1;
            }
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("JOIN " + this.outputObjInspector.getTypeName() + " totalsz = " + this.totalSz);
        }
    }

    @Override
    public void startGroup() throws HiveException {
        this.newGroupStarted = true;
        for (AbstractRowContainer<List<Object>> alw : this.storage) {
            alw.clearRows();
        }
        super.startGroup();
    }

    protected long getNextSize(long sz) {
        if (sz >= 100000L) {
            return sz + 100000L;
        }
        return 2L * sz;
    }

    protected List<Object> getFilteredValue(byte alias, Object row) throws HiveException {
        boolean hasFilter = this.hasFilter(alias);
        List<Object> nr = JoinUtil.computeValues(row, this.joinValues[alias], this.joinValuesObjectInspectors[alias], hasFilter);
        if (hasFilter) {
            short filterTag = JoinUtil.isFiltered(row, this.joinFilters[alias], this.joinFilterObjectInspectors[alias], this.filterMaps[alias]);
            nr.add(new ShortWritable(filterTag));
            byte by = alias;
            this.aliasFilterTags[by] = (short)(this.aliasFilterTags[by] & filterTag);
        }
        return nr;
    }

    private boolean createForwardJoinObject(boolean[] skip) throws HiveException {
        Arrays.fill(this.forwardCache, null);
        boolean forward = false;
        for (int i = 0; i < this.numAliases; ++i) {
            if (skip[i]) continue;
            for (int j = this.offsets[i]; j < this.offsets[i + 1]; ++j) {
                this.forwardCache[j] = this.intermediate[i].get(j - this.offsets[i]);
            }
            forward = true;
        }
        if (forward) {
            if (this.needsPostEvaluation) {
                boolean bl = forward = !JoinUtil.isFiltered(this.forwardCache, this.residualJoinFilters, this.residualJoinFiltersOIs);
            }
            if (forward) {
                this.internalForward(this.forwardCache, this.outputObjInspector);
                this.countAfterReport = 0;
            }
        }
        return forward;
    }

    private void genJoinObject() throws HiveException {
        int nextType;
        int nextType2;
        if (this.needsPostEvaluation && 0 == this.numAliases - 2 && ((nextType2 = this.condn[0].getType()) == 2 || nextType2 == 3)) {
            this.rowContainerPostFilteredOuterJoin = new HashMap<Integer, Object[]>();
        }
        boolean rightFirst = true;
        boolean hasFilter = this.hasFilter(this.order[0].byteValue());
        AbstractRowContainer.RowIterator<List<Object>> iter = this.storage[this.order[0]].rowIter();
        List<Object> rightObj = iter.first();
        while (rightObj != null) {
            boolean rightNull;
            boolean bl = rightNull = rightObj == this.dummyObj[0];
            if (hasFilter) {
                this.filterTags[0] = this.getFilterTag(rightObj);
            }
            this.skipVectors[0][0] = rightNull;
            this.intermediate[0] = rightObj;
            this.genObject(1, rightFirst, rightNull);
            rightFirst = false;
            rightObj = iter.next();
        }
        if (this.needsPostEvaluation && 0 == this.numAliases - 2 && ((nextType = this.condn[0].getType()) == 2 || nextType == 3)) {
            Arrays.fill(this.forwardCache, null);
            for (Object[] row : this.rowContainerPostFilteredOuterJoin.values()) {
                if (row == null) continue;
                System.arraycopy(row, 0, this.forwardCache, this.offsets[this.numAliases - 1], row.length);
                this.internalForward(this.forwardCache, this.outputObjInspector);
                this.countAfterReport = 0;
            }
        }
    }

    private void genObject(int aliasNum, boolean allLeftFirst, boolean allLeftNull) throws HiveException {
        int nextType;
        int nextType2;
        JoinCondDesc joinCond = this.condn[aliasNum - 1];
        int type = joinCond.getType();
        int left = joinCond.getLeft();
        int right = joinCond.getRight();
        if (this.needsPostEvaluation && aliasNum == this.numAliases - 2 && ((nextType2 = this.condn[aliasNum].getType()) == 2 || nextType2 == 3)) {
            this.rowContainerPostFilteredOuterJoin = new HashMap<Integer, Object[]>();
        }
        boolean[] skip = this.skipVectors[aliasNum];
        boolean[] prevSkip = this.skipVectors[aliasNum - 1];
        AbstractRowContainer<List<Object>> aliasRes = this.storage[this.order[aliasNum]];
        boolean needToProduceLeftRow = false;
        boolean producedRow = false;
        boolean done = false;
        boolean loopAgain = false;
        boolean tryLOForFO = type == 3;
        boolean rightFirst = true;
        AbstractRowContainer.RowIterator<List<Object>> iter = aliasRes.rowIter();
        int pos = 0;
        List<Object> rightObj = iter.first();
        while (!done && rightObj != null) {
            block26: {
                boolean rightNull;
                block23: {
                    block28: {
                        block27: {
                            block25: {
                                block24: {
                                    block22: {
                                        System.arraycopy(prevSkip, 0, skip, 0, prevSkip.length);
                                        boolean bl = rightNull = rightObj == this.dummyObj[aliasNum];
                                        if (this.hasFilter(this.order[aliasNum].byteValue())) {
                                            this.filterTags[aliasNum] = this.getFilterTag(rightObj);
                                        }
                                        skip[right] = rightNull;
                                        if (type != 0) break block22;
                                        this.innerJoin(skip, left, right);
                                        break block23;
                                    }
                                    if (type != 5) break block24;
                                    if (this.innerJoin(skip, left, right)) {
                                        done = !this.needsPostEvaluation;
                                    }
                                    break block23;
                                }
                                if (type != 1 && (type != 3 || !rightNull)) break block25;
                                int result = this.leftOuterJoin(skip, left, right);
                                if (result < 0) break block26;
                                done = result > 0;
                                break block23;
                            }
                            if (type != 2 && (type != 3 || !allLeftNull)) break block27;
                            if ((!allLeftFirst || this.rightOuterJoin(skip, left, right)) && (allLeftFirst || this.innerJoin(skip, left, right))) break block23;
                            break block26;
                        }
                        if (type != 3) break block23;
                        if (!tryLOForFO || this.leftOuterJoin(skip, left, right) <= 0) break block28;
                        loopAgain = allLeftFirst;
                        done = !loopAgain;
                        tryLOForFO = false;
                        break block23;
                    }
                    if (allLeftFirst && !this.rightOuterJoin(skip, left, right) || !allLeftFirst && !this.innerJoin(skip, left, right)) break block26;
                }
                this.intermediate[aliasNum] = rightObj;
                if (aliasNum == this.numAliases - 1) {
                    if (!allLeftNull || !rightNull) {
                        needToProduceLeftRow = true;
                        if (this.needsPostEvaluation) {
                            boolean forward = this.createForwardJoinObject(this.skipVectors[this.numAliases - 1]);
                            producedRow |= forward;
                            boolean bl = done = type == 5 && forward;
                            if (!(rightNull || type != 2 && type != 3)) {
                                if (forward) {
                                    this.rowContainerPostFilteredOuterJoin.put(pos, null);
                                } else if (!this.rowContainerPostFilteredOuterJoin.containsKey(pos)) {
                                    Object[] row = Arrays.copyOfRange(this.forwardCache, this.offsets[aliasNum], this.offsets[aliasNum + 1]);
                                    this.rowContainerPostFilteredOuterJoin.put(pos, row);
                                }
                            }
                        } else {
                            this.createForwardJoinObject(this.skipVectors[this.numAliases - 1]);
                        }
                    }
                } else {
                    this.genObject(aliasNum + 1, allLeftFirst && rightFirst, allLeftNull && rightNull);
                }
            }
            rightObj = loopAgain ? rightObj : iter.next();
            loopAgain = false;
            rightFirst = false;
            ++pos;
        }
        if (this.needsPostEvaluation && aliasNum == this.numAliases - 1 && needToProduceLeftRow && !producedRow && !allLeftNull) {
            if (type == 1 || type == 3) {
                int i = this.numAliases - 1;
                for (int j = this.offsets[i]; j < this.offsets[i + 1]; ++j) {
                    this.forwardCache[j] = null;
                }
                this.internalForward(this.forwardCache, this.outputObjInspector);
                this.countAfterReport = 0;
            }
        } else if (this.needsPostEvaluation && aliasNum == this.numAliases - 2 && ((nextType = this.condn[aliasNum].getType()) == 2 || nextType == 3)) {
            Arrays.fill(this.forwardCache, null);
            for (Object[] row : this.rowContainerPostFilteredOuterJoin.values()) {
                if (row == null) continue;
                System.arraycopy(row, 0, this.forwardCache, this.offsets[this.numAliases - 1], row.length);
                this.internalForward(this.forwardCache, this.outputObjInspector);
                this.countAfterReport = 0;
            }
        }
    }

    private boolean innerJoin(boolean[] skip, int left, int right) {
        if (!this.isInnerJoin(skip, left, right)) {
            Arrays.fill(skip, true);
            return false;
        }
        return true;
    }

    private int leftOuterJoin(boolean[] skip, int left, int right) {
        if (skip[left] || skip[right] || !this.isLeftValid(left, right)) {
            skip[right] = true;
            return 1;
        }
        if (this.isRightValid(left, right)) {
            return 0;
        }
        if (this.hasRightPairForLeft(left, right)) {
            return -1;
        }
        skip[right] = true;
        return 1;
    }

    private boolean rightOuterJoin(boolean[] skip, int left, int right) {
        if (skip[left] || skip[right] || !this.isRightValid(left, right)) {
            Arrays.fill(skip, 0, right, true);
            return true;
        }
        if (this.isLeftValid(left, right)) {
            return true;
        }
        if (this.hasLeftPairForRight(left, right)) {
            return false;
        }
        Arrays.fill(skip, 0, right, true);
        return true;
    }

    private boolean isInnerJoin(boolean[] skip, int left, int right) {
        return !skip[left] && !skip[right] && this.isLeftValid(left, right) && this.isRightValid(left, right);
    }

    private boolean isLeftValid(int left, int right) {
        return !this.hasFilter(left) || !JoinUtil.isFiltered(this.filterTags[left], right);
    }

    private boolean isRightValid(int left, int right) {
        return !this.hasFilter(right) || !JoinUtil.isFiltered(this.filterTags[right], left);
    }

    private boolean hasLeftPairForRight(int left, int right) {
        return !JoinUtil.isFiltered(this.aliasFilterTags[left], right);
    }

    private boolean hasRightPairForLeft(int left, int right) {
        return !JoinUtil.isFiltered(this.aliasFilterTags[right], left);
    }

    private boolean hasAnyFiltered(int alias, List<Object> row) {
        return row == this.dummyObj[alias] || this.hasFilter(alias) && JoinUtil.hasAnyFiltered(this.getFilterTag(row));
    }

    protected final boolean hasFilter(int alias) {
        return this.filterMaps != null && this.filterMaps[alias] != null;
    }

    protected final short getFilterTag(List<Object> row) {
        return ((ShortWritable)row.get(row.size() - 1)).get();
    }

    @Override
    public void endGroup() throws HiveException {
        this.checkAndGenObject();
    }

    protected void internalForward(Object row, ObjectInspector outputOI) throws HiveException {
        this.forward(row, outputOI);
    }

    private void genUniqueJoinObject(int aliasNum, int forwardCachePos) throws HiveException {
        AbstractRowContainer.RowIterator<List<Object>> iter = this.storage[this.order[aliasNum]].rowIter();
        List<Object> row = iter.first();
        while (row != null) {
            this.reportProgress();
            int sz = this.joinValues[this.order[aliasNum]].size();
            int p = forwardCachePos;
            for (int j = 0; j < sz; ++j) {
                this.forwardCache[p++] = row.get(j);
            }
            if (aliasNum == this.numAliases - 1) {
                this.internalForward(this.forwardCache, this.outputObjInspector);
                this.countAfterReport = 0;
            } else {
                this.genUniqueJoinObject(aliasNum + 1, p);
            }
            row = iter.next();
        }
    }

    private void genAllOneUniqueJoinObject() throws HiveException {
        int p = 0;
        for (int i = 0; i < this.numAliases; ++i) {
            int sz = this.joinValues[this.order[i]].size();
            List<Object> obj = this.storage[this.order[i]].rowIter().first();
            for (int j = 0; j < sz; ++j) {
                this.forwardCache[p++] = obj.get(j);
            }
        }
        this.internalForward(this.forwardCache, this.outputObjInspector);
        this.countAfterReport = 0;
    }

    protected void checkAndGenObject() throws HiveException {
        if (this.closeOpCalled) {
            LOG.warn("checkAndGenObject is called after operator " + this.id + " " + this.getName() + " called closeOp");
            return;
        }
        if (this.condn[0].getType() == 4) {
            boolean preserve = false;
            boolean hasNulls = false;
            boolean allOne = true;
            for (int i = 0; i < this.numAliases; ++i) {
                Byte alias = this.order[i];
                AbstractRowContainer<List<Object>> alw = this.storage[alias];
                if (!alw.isSingleRow()) {
                    allOne = false;
                }
                if (!alw.hasRows()) {
                    alw.addRow(this.dummyObj[i]);
                    hasNulls = true;
                    continue;
                }
                if (!this.condn[i].getPreserved()) continue;
                preserve = true;
            }
            if (hasNulls && !preserve) {
                return;
            }
            if (allOne) {
                this.genAllOneUniqueJoinObject();
            } else {
                this.genUniqueJoinObject(0, 0);
            }
        } else {
            boolean mayHasMoreThanOne = false;
            boolean hasEmpty = false;
            block1: for (int i = 0; i < this.numAliases; ++i) {
                Byte alias = this.order[i];
                AbstractRowContainer<List<Object>> alw = this.storage[alias];
                if (this.noOuterJoin) {
                    if (!alw.hasRows()) {
                        return;
                    }
                    if (alw.isSingleRow()) continue;
                    mayHasMoreThanOne = true;
                    continue;
                }
                if (!alw.hasRows()) {
                    hasEmpty = true;
                    alw.addRow(this.dummyObj[i]);
                    continue;
                }
                if (!hasEmpty && alw.isSingleRow()) {
                    if (!this.hasAnyFiltered(alias.byteValue(), alw.rowIter().first())) continue;
                    hasEmpty = true;
                    continue;
                }
                mayHasMoreThanOne = true;
                if (hasEmpty) continue;
                AbstractRowContainer.RowIterator<List<Object>> iter = alw.rowIter();
                List<Object> row = iter.first();
                while (row != null) {
                    this.reportProgress();
                    if (this.hasAnyFiltered(alias.byteValue(), row)) {
                        hasEmpty = true;
                        continue block1;
                    }
                    row = iter.next();
                }
            }
            if (!(this.needsPostEvaluation || hasEmpty || mayHasMoreThanOne)) {
                this.genAllOneUniqueJoinObject();
            } else if (!(this.needsPostEvaluation || hasEmpty || this.hasLeftSemiJoin)) {
                this.genUniqueJoinObject(0, 0);
            } else {
                this.genJoinObject();
            }
        }
        Arrays.fill(this.aliasFilterTags, (short)-1);
    }

    protected void reportProgress() {
        ++this.countAfterReport;
        if (this.countAfterReport % this.heartbeatInterval == 0 && this.reporter != null) {
            this.reporter.progress();
            this.countAfterReport = 0;
        }
    }

    @Override
    public void closeOp(boolean abort) throws HiveException {
        this.closeOpCalled = true;
        for (AbstractRowContainer<List<Object>> alw : this.storage) {
            if (alw == null) continue;
            alw.clearRows();
        }
        Arrays.fill(this.storage, null);
        super.closeOp(abort);
    }

    @Override
    public String getName() {
        return CommonJoinOperator.getOperatorName();
    }

    public static String getOperatorName() {
        return "JOIN";
    }

    public Map<Integer, Set<String>> getPosToAliasMap() {
        return this.posToAliasMap;
    }

    public void setPosToAliasMap(Map<Integer, Set<String>> posToAliasMap) {
        this.posToAliasMap = posToAliasMap;
    }

    @Override
    public boolean opAllowedBeforeMapJoin() {
        return false;
    }

    @Override
    public boolean opAllowedAfterMapJoin() {
        return false;
    }
}

