/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.time.ZonedDateTime;
import org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.NDV;
import org.apache.hadoop.hive.serde2.io.TimestampWritableV2;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;

@UDFType(deterministic=false, runtimeConstant=true)
@Description(name="current_timestamp", value="_FUNC_() - Returns the current timestamp at the start of query evaluation. All calls of current_timestamp within the same query return the same value.")
@NDV(maxNdv=1L)
public class GenericUDFCurrentTimestamp
extends GenericUDF {
    protected TimestampWritableV2 currentTimestamp;

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length != 0) {
            throw new UDFArgumentLengthException("The function CURRENT_TIMESTAMP does not take any arguments, but found " + arguments.length);
        }
        if (this.currentTimestamp == null) {
            SessionState ss = SessionState.get();
            ZonedDateTime dateTime = ss.getQueryCurrentTimestamp().atZone(ss.getConf().getLocalTimeZone());
            this.currentTimestamp = new TimestampWritableV2(Timestamp.valueOf(dateTime.toLocalDateTime().toString()));
        }
        return PrimitiveObjectInspectorFactory.writableTimestampObjectInspector;
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        return this.currentTimestamp;
    }

    public TimestampWritableV2 getCurrentTimestamp() {
        return this.currentTimestamp;
    }

    public void setCurrentTimestamp(TimestampWritableV2 currentTimestamp) {
        this.currentTimestamp = currentTimestamp;
    }

    @Override
    public String getDisplayString(String[] children) {
        return "CURRENT_TIMESTAMP()";
    }

    @Override
    public void copyToNewInstance(Object newInstance) throws UDFArgumentException {
        super.copyToNewInstance(newInstance);
        GenericUDFCurrentTimestamp other = (GenericUDFCurrentTimestamp)newInstance;
        if (this.currentTimestamp != null) {
            other.currentTimestamp = new TimestampWritableV2(this.currentTimestamp);
        }
    }
}

