/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import com.google.common.base.Preconditions;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;

@Description(name="width_bucket", value="_FUNC_(expr, min_value, max_value, num_buckets) - Returns an integer between 0 and num_buckets+1 by mapping the expr into buckets defined by the range [min_value, max_value]", extended="Returns an integer between 0 and num_buckets+1 by mapping expr into the ith equally sized bucket. Buckets are made by dividing [min_value, max_value] into equally sized regions. If expr < min_value, return 1, if expr > max_value return num_buckets+1\nExample: expr is an integer column withs values 1, 10, 20, 30.\n  > SELECT _FUNC_(expr, 5, 25, 4) FROM src;\n1\n1\n3\n5")
public class GenericUDFWidthBucket
extends GenericUDF {
    private transient ObjectInspector[] objectInspectors;
    private transient ObjectInspector commonExprMinMaxOI;
    private transient ObjectInspectorConverters.Converter epxrConverterOI;
    private transient ObjectInspectorConverters.Converter minValueConverterOI;
    private transient ObjectInspectorConverters.Converter maxValueConverterOI;
    private final IntWritable output = new IntWritable();

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        this.objectInspectors = arguments;
        this.checkArgsSize(arguments, 4, 4);
        this.checkArgPrimitive(arguments, 0);
        this.checkArgPrimitive(arguments, 1);
        this.checkArgPrimitive(arguments, 2);
        this.checkArgPrimitive(arguments, 3);
        PrimitiveObjectInspector.PrimitiveCategory[] inputTypes = new PrimitiveObjectInspector.PrimitiveCategory[4];
        this.checkArgGroups(arguments, 0, inputTypes, PrimitiveObjectInspectorUtils.PrimitiveGrouping.NUMERIC_GROUP, PrimitiveObjectInspectorUtils.PrimitiveGrouping.VOID_GROUP);
        this.checkArgGroups(arguments, 1, inputTypes, PrimitiveObjectInspectorUtils.PrimitiveGrouping.NUMERIC_GROUP, PrimitiveObjectInspectorUtils.PrimitiveGrouping.VOID_GROUP);
        this.checkArgGroups(arguments, 2, inputTypes, PrimitiveObjectInspectorUtils.PrimitiveGrouping.NUMERIC_GROUP, PrimitiveObjectInspectorUtils.PrimitiveGrouping.VOID_GROUP);
        this.checkArgGroups(arguments, 3, inputTypes, PrimitiveObjectInspectorUtils.PrimitiveGrouping.NUMERIC_GROUP, PrimitiveObjectInspectorUtils.PrimitiveGrouping.VOID_GROUP);
        TypeInfo exprTypeInfo = TypeInfoUtils.getTypeInfoFromObjectInspector(this.objectInspectors[0]);
        TypeInfo minValueTypeInfo = TypeInfoUtils.getTypeInfoFromObjectInspector(this.objectInspectors[1]);
        TypeInfo maxValueTypeInfo = TypeInfoUtils.getTypeInfoFromObjectInspector(this.objectInspectors[2]);
        TypeInfo commonExprMinMaxTypeInfo = FunctionRegistry.getCommonClassForComparison(exprTypeInfo, FunctionRegistry.getCommonClassForComparison(minValueTypeInfo, maxValueTypeInfo));
        this.commonExprMinMaxOI = TypeInfoUtils.getStandardWritableObjectInspectorFromTypeInfo(commonExprMinMaxTypeInfo);
        this.epxrConverterOI = ObjectInspectorConverters.getConverter(this.objectInspectors[0], this.commonExprMinMaxOI);
        this.minValueConverterOI = ObjectInspectorConverters.getConverter(this.objectInspectors[1], this.commonExprMinMaxOI);
        this.maxValueConverterOI = ObjectInspectorConverters.getConverter(this.objectInspectors[2], this.commonExprMinMaxOI);
        return PrimitiveObjectInspectorFactory.writableIntObjectInspector;
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        if (arguments[0].get() == null || arguments[1].get() == null || arguments[2].get() == null || arguments[3].get() == null) {
            return null;
        }
        Object exprValue = this.epxrConverterOI.convert(arguments[0].get());
        Object minValue = this.minValueConverterOI.convert(arguments[1].get());
        Object maxValue = this.maxValueConverterOI.convert(arguments[2].get());
        int numBuckets = PrimitiveObjectInspectorUtils.getInt(arguments[3].get(), (PrimitiveObjectInspector)this.objectInspectors[3]);
        switch (((PrimitiveObjectInspector)this.commonExprMinMaxOI).getPrimitiveCategory()) {
            case SHORT: {
                return this.evaluate(((ShortWritable)exprValue).get(), ((ShortWritable)minValue).get(), ((ShortWritable)maxValue).get(), numBuckets);
            }
            case INT: {
                return this.evaluate(((IntWritable)exprValue).get(), ((IntWritable)minValue).get(), ((IntWritable)maxValue).get(), numBuckets);
            }
            case LONG: {
                return this.evaluate(((LongWritable)exprValue).get(), ((LongWritable)minValue).get(), ((LongWritable)maxValue).get(), numBuckets);
            }
            case FLOAT: {
                return this.evaluate(((FloatWritable)exprValue).get(), ((FloatWritable)minValue).get(), ((FloatWritable)maxValue).get(), numBuckets);
            }
            case DOUBLE: {
                return this.evaluate(((DoubleWritable)((Object)exprValue)).get(), ((DoubleWritable)((Object)minValue)).get(), ((DoubleWritable)((Object)maxValue)).get(), numBuckets);
            }
            case DECIMAL: {
                return this.evaluate(((HiveDecimalWritable)exprValue).getHiveDecimal(), ((HiveDecimalWritable)minValue).getHiveDecimal(), ((HiveDecimalWritable)maxValue).getHiveDecimal(), numBuckets);
            }
            case BYTE: {
                return this.evaluate(((ByteWritable)((Object)exprValue)).get(), ((ByteWritable)((Object)minValue)).get(), ((ByteWritable)((Object)maxValue)).get(), numBuckets);
            }
        }
        throw new IllegalStateException("Error: width_bucket could not determine a common primitive type for all inputs");
    }

    private IntWritable evaluate(short exprValue, short minValue, short maxValue, int numBuckets) {
        Preconditions.checkArgument(numBuckets > 0, "numBuckets in width_bucket function must be above 0");
        Preconditions.checkArgument(maxValue != minValue, "maxValue cannot be equal to minValue in width_bucket function");
        if (maxValue > minValue) {
            if (exprValue < minValue) {
                this.output.set(0);
            } else if (exprValue >= maxValue) {
                this.output.set(numBuckets + 1);
            } else {
                this.output.set((int)Math.floor(numBuckets * (exprValue - minValue) / (maxValue - minValue) + 1));
            }
        } else if (exprValue > minValue) {
            this.output.set(0);
        } else if (exprValue <= maxValue) {
            this.output.set(numBuckets + 1);
        } else {
            this.output.set((int)Math.floor(numBuckets * (minValue - exprValue) / (minValue - maxValue) + 1));
        }
        return this.output;
    }

    private IntWritable evaluate(int exprValue, int minValue, int maxValue, int numBuckets) {
        Preconditions.checkArgument(numBuckets > 0, "numBuckets in width_bucket function must be above 0");
        Preconditions.checkArgument(maxValue != minValue, "maxValue cannot be equal to minValue in width_bucket function");
        if (maxValue > minValue) {
            if (exprValue < minValue) {
                this.output.set(0);
            } else if (exprValue >= maxValue) {
                this.output.set(numBuckets + 1);
            } else {
                this.output.set((int)Math.floor(numBuckets * (exprValue - minValue) / (maxValue - minValue) + 1));
            }
        } else if (exprValue > minValue) {
            this.output.set(0);
        } else if (exprValue <= maxValue) {
            this.output.set(numBuckets + 1);
        } else {
            this.output.set((int)Math.floor(numBuckets * (minValue - exprValue) / (minValue - maxValue) + 1));
        }
        return this.output;
    }

    private IntWritable evaluate(long exprValue, long minValue, long maxValue, int numBuckets) {
        Preconditions.checkArgument(numBuckets > 0, "numBuckets in width_bucket function must be above 0");
        Preconditions.checkArgument(maxValue != minValue, "maxValue cannot be equal to minValue in width_bucket function");
        if (maxValue > minValue) {
            if (exprValue < minValue) {
                this.output.set(0);
            } else if (exprValue >= maxValue) {
                this.output.set(numBuckets + 1);
            } else {
                this.output.set((int)Math.floor((long)numBuckets * (exprValue - minValue) / (maxValue - minValue) + 1L));
            }
        } else if (exprValue > minValue) {
            this.output.set(0);
        } else if (exprValue <= maxValue) {
            this.output.set(numBuckets + 1);
        } else {
            this.output.set((int)Math.floor((long)numBuckets * (minValue - exprValue) / (minValue - maxValue) + 1L));
        }
        return this.output;
    }

    private IntWritable evaluate(float exprValue, float minValue, float maxValue, int numBuckets) {
        Preconditions.checkArgument(numBuckets > 0, "numBuckets in width_bucket function must be above 0");
        Preconditions.checkArgument(maxValue != minValue, "maxValue cannot be equal to minValue in width_bucket function");
        if (maxValue > minValue) {
            if (exprValue < minValue) {
                this.output.set(0);
            } else if (exprValue >= maxValue) {
                this.output.set(numBuckets + 1);
            } else {
                this.output.set((int)Math.floor((float)numBuckets * (exprValue - minValue) / (maxValue - minValue) + 1.0f));
            }
        } else if (exprValue > minValue) {
            this.output.set(0);
        } else if (exprValue <= maxValue) {
            this.output.set(numBuckets + 1);
        } else {
            this.output.set((int)Math.floor((float)numBuckets * (minValue - exprValue) / (minValue - maxValue) + 1.0f));
        }
        return this.output;
    }

    private IntWritable evaluate(double exprValue, double minValue, double maxValue, int numBuckets) {
        Preconditions.checkArgument(numBuckets > 0, "numBuckets in width_bucket function must be above 0");
        Preconditions.checkArgument(maxValue != minValue, "maxValue cannot be equal to minValue in width_bucket function");
        if (maxValue > minValue) {
            if (exprValue < minValue) {
                this.output.set(0);
            } else if (exprValue >= maxValue) {
                this.output.set(numBuckets + 1);
            } else {
                this.output.set((int)Math.floor((double)numBuckets * (exprValue - minValue) / (maxValue - minValue) + 1.0));
            }
        } else if (exprValue > minValue) {
            this.output.set(0);
        } else if (exprValue <= maxValue) {
            this.output.set(numBuckets + 1);
        } else {
            this.output.set((int)Math.floor((double)numBuckets * (minValue - exprValue) / (minValue - maxValue) + 1.0));
        }
        return this.output;
    }

    private IntWritable evaluate(HiveDecimal exprValue, HiveDecimal minValue, HiveDecimal maxValue, int numBuckets) {
        Preconditions.checkArgument(numBuckets > 0, "numBuckets in width_bucket function must be above 0");
        Preconditions.checkArgument(!maxValue.equals(minValue), "maxValue cannot be equal to minValue in width_bucket function");
        if (maxValue.compareTo(minValue) > 0) {
            if (exprValue.compareTo(minValue) < 0) {
                this.output.set(0);
            } else if (exprValue.compareTo(maxValue) >= 0) {
                this.output.set(numBuckets + 1);
            } else {
                this.output.set(HiveDecimal.create(numBuckets).multiply(exprValue.subtract(minValue)).divide(maxValue.subtract(minValue)).add(HiveDecimal.ONE).intValue());
            }
        } else if (exprValue.compareTo(minValue) > 0) {
            this.output.set(0);
        } else if (exprValue.compareTo(maxValue) <= 0) {
            this.output.set(numBuckets + 1);
        } else {
            this.output.set(HiveDecimal.create(numBuckets).multiply(minValue.subtract(exprValue)).divide(minValue.subtract(maxValue)).add(HiveDecimal.ONE).intValue());
        }
        return this.output;
    }

    private Object evaluate(byte exprValue, byte minValue, byte maxValue, int numBuckets) {
        Preconditions.checkArgument(numBuckets > 0, "numBuckets in width_bucket function must be above 0");
        Preconditions.checkArgument(maxValue != minValue, "maxValue cannot be equal to minValue in width_bucket function");
        if (maxValue > minValue) {
            if (exprValue < minValue) {
                this.output.set(0);
            } else if (exprValue >= maxValue) {
                this.output.set(numBuckets + 1);
            } else {
                this.output.set((int)Math.floor(numBuckets * (exprValue - minValue) / (maxValue - minValue) + 1));
            }
        } else if (exprValue > minValue) {
            this.output.set(0);
        } else if (exprValue <= maxValue) {
            this.output.set(numBuckets + 1);
        } else {
            this.output.set((int)Math.floor(numBuckets * (minValue - exprValue) / (minValue - maxValue) + 1));
        }
        return this.output;
    }

    @Override
    public String getDisplayString(String[] children) {
        return this.getStandardDisplayString("width_bucket", children);
    }
}

