/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.spark.client;

import java.io.Serializable;
import java.util.List;
import java.util.concurrent.Future;
import org.apache.hadoop.hive.common.classification.InterfaceAudience;
import org.apache.hive.spark.client.MetricsCollection;
import org.apache.hive.spark.counter.SparkCounters;

@InterfaceAudience.Private
public interface JobHandle<T extends Serializable>
extends Future<T> {
    public String getClientJobId();

    public MetricsCollection getMetrics();

    public List<Integer> getSparkJobIds();

    public SparkCounters getSparkCounters();

    public State getState();

    public Throwable getError();

    public static interface Listener<T extends Serializable> {
        public void onJobQueued(JobHandle<T> var1);

        public void onJobStarted(JobHandle<T> var1);

        public void onJobCancelled(JobHandle<T> var1);

        public void onJobFailed(JobHandle<T> var1, Throwable var2);

        public void onJobSucceeded(JobHandle<T> var1, T var2);

        public void onSparkJobStarted(JobHandle<T> var1, int var2);
    }

    public static enum State {
        SENT,
        QUEUED,
        STARTED,
        CANCELLED,
        FAILED,
        SUCCEEDED;

    }
}

