/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.history.logging.proto;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.io.Writable;

public class ProtoMessageWritable<T extends MessageLite>
implements Writable {
    private T message;
    private final Parser<T> parser;
    private DataOutputStream dos;
    private CodedOutputStream cos;
    private DataInputStream din;
    private CodedInputStream cin;

    ProtoMessageWritable(Parser<T> parser) {
        this.parser = parser;
    }

    public T getMessage() {
        return this.message;
    }

    public void setMessage(T message) {
        this.message = message;
    }

    public void write(DataOutput out) throws IOException {
        if (this.dos == null) {
            this.dos = new DataOutputStream();
            this.cos = CodedOutputStream.newInstance(this.dos);
        }
        this.dos.out = out;
        this.cos.writeMessageNoTag((MessageLite)this.message);
        this.cos.flush();
    }

    public void readFields(DataInput in) throws IOException {
        if (this.din == null) {
            this.din = new DataInputStream();
            this.cin = CodedInputStream.newInstance(this.din);
            this.cin.setSizeLimit(Integer.MAX_VALUE);
        }
        this.din.in = in;
        this.message = this.cin.readMessage(this.parser, null);
    }

    private static class DataInputStream
    extends InputStream {
        DataInput in;

        private DataInputStream() {
        }

        @Override
        public int read() throws IOException {
            try {
                return this.in.readUnsignedByte();
            }
            catch (EOFException e) {
                return -1;
            }
        }
    }

    private static class DataOutputStream
    extends OutputStream {
        DataOutput out;

        private DataOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
            this.out.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
        }
    }
}

