/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm;

import com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.apache.hadoop.metrics2.lib.MutableRate;

@InterfaceAudience.Private
@Metrics(about="Storage Container Client Metrics", context="dfs")
public class XceiverClientMetrics {
    public static final String SOURCE_NAME = XceiverClientMetrics.class.getSimpleName();
    @Metric
    private MutableCounterLong pendingOps;
    @Metric
    private MutableCounterLong totalOps;
    @Metric
    private MutableCounterLong ecReconstructionTotal;
    @Metric
    private MutableCounterLong ecReconstructionFailsTotal;
    private MutableCounterLong[] pendingOpsArray;
    private MutableCounterLong[] opsArray;
    private MutableRate[] containerOpsLatency;
    private MetricsRegistry registry;

    public XceiverClientMetrics() {
        this.init();
    }

    public void init() {
        int numEnumEntries = ContainerProtos.Type.values().length;
        this.registry = new MetricsRegistry(SOURCE_NAME);
        this.pendingOpsArray = new MutableCounterLong[numEnumEntries];
        this.opsArray = new MutableCounterLong[numEnumEntries];
        this.containerOpsLatency = new MutableRate[numEnumEntries];
        for (int i = 0; i < numEnumEntries; ++i) {
            this.pendingOpsArray[i] = this.registry.newCounter("numPending" + ContainerProtos.Type.forNumber((int)(i + 1)), "number of pending" + ContainerProtos.Type.forNumber((int)(i + 1)) + " ops", 0L);
            this.opsArray[i] = this.registry.newCounter("opCount" + ContainerProtos.Type.forNumber((int)(i + 1)), "number of" + ContainerProtos.Type.forNumber((int)(i + 1)) + " ops", 0L);
            this.containerOpsLatency[i] = this.registry.newRate(ContainerProtos.Type.forNumber((int)(i + 1)) + "Latency", "latency of " + ContainerProtos.Type.forNumber((int)(i + 1)) + " ops");
        }
    }

    public static XceiverClientMetrics create() {
        DefaultMetricsSystem.initialize((String)SOURCE_NAME);
        MetricsSystem ms = DefaultMetricsSystem.instance();
        return (XceiverClientMetrics)ms.register(SOURCE_NAME, "Storage Container Client Metrics", (Object)new XceiverClientMetrics());
    }

    public void incrPendingContainerOpsMetrics(ContainerProtos.Type type) {
        this.pendingOps.incr();
        this.totalOps.incr();
        this.opsArray[type.ordinal()].incr();
        this.pendingOpsArray[type.ordinal()].incr();
    }

    public void decrPendingContainerOpsMetrics(ContainerProtos.Type type) {
        this.pendingOps.incr(-1L);
        this.pendingOpsArray[type.ordinal()].incr(-1L);
    }

    public void addContainerOpsLatency(ContainerProtos.Type type, long latencyMillis) {
        this.containerOpsLatency[type.ordinal()].add(latencyMillis);
    }

    public long getPendingContainerOpCountMetrics(ContainerProtos.Type type) {
        return this.pendingOpsArray[type.ordinal()].value();
    }

    public void incECReconstructionTotal() {
        this.ecReconstructionTotal.incr();
    }

    public void incECReconstructionFailsTotal() {
        this.ecReconstructionFailsTotal.incr();
    }

    @VisibleForTesting
    public long getTotalOpCount() {
        return this.totalOps.value();
    }

    @VisibleForTesting
    public long getContainerOpCountMetrics(ContainerProtos.Type type) {
        return this.opsArray[type.ordinal()].value();
    }

    @VisibleForTesting
    public void reset() {
        this.init();
    }

    public void unRegister() {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        ms.unregisterSource(SOURCE_NAME);
    }
}

