/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.upgrade;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.Set;
import org.apache.hadoop.hdds.upgrade.HDDSLayoutFeature;
import org.apache.hadoop.hdds.upgrade.HDDSUpgradeAction;
import org.apache.hadoop.ozone.upgrade.AbstractLayoutVersionManager;
import org.apache.hadoop.ozone.upgrade.UpgradeActionHdds;
import org.reflections.Reflections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HDDSLayoutVersionManager
extends AbstractLayoutVersionManager<HDDSLayoutFeature> {
    private static final Logger LOG = LoggerFactory.getLogger(HDDSLayoutVersionManager.class);
    private static final Object[] HDDS_CLASS_UPGRADE_PACKAGES = new Object[]{"org.apache.hadoop.hdds.scm.server", "org.apache.hadoop.ozone.container"};
    private static final Reflections HDDS_UPGRADE_REFLECTIONS = new Reflections(HDDS_CLASS_UPGRADE_PACKAGES);

    public HDDSLayoutVersionManager(int layoutVersion) throws IOException {
        this.init(layoutVersion, HDDSLayoutFeature.values());
        this.registerUpgradeActions(HDDSLayoutVersionManager.getAnnotatedTypes(HDDS_UPGRADE_REFLECTIONS));
    }

    public static int maxLayoutVersion() {
        HDDSLayoutFeature[] features = HDDSLayoutFeature.values();
        return features[features.length - 1].layoutVersion();
    }

    @VisibleForTesting
    void registerUpgradeActions(Object ... classNames) {
        this.registerUpgradeActions(HDDSLayoutVersionManager.getAnnotatedTypes(new Reflections(classNames)));
    }

    private static Set<Class<?>> getAnnotatedTypes(Reflections reflections) {
        return reflections.getTypesAnnotatedWith(UpgradeActionHdds.class);
    }

    private void registerUpgradeActions(Set<Class<?>> typesAnnotatedWith) {
        typesAnnotatedWith.forEach(actionClass -> {
            block7: {
                if (HDDSUpgradeAction.class.isAssignableFrom((Class<?>)actionClass)) {
                    try {
                        HDDSUpgradeAction action = (HDDSUpgradeAction)actionClass.newInstance();
                        UpgradeActionHdds annotation = actionClass.getAnnotation(UpgradeActionHdds.class);
                        HDDSLayoutFeature feature = annotation.feature();
                        if (feature.layoutVersion() > this.getMetadataLayoutVersion()) {
                            LOG.info("Registering Upgrade Action : {}", (Object)action.name());
                            if (annotation.component() == UpgradeActionHdds.Component.SCM) {
                                feature.addScmAction(annotation.type(), action);
                            } else {
                                feature.addDatanodeAction(annotation.type(), action);
                            }
                            break block7;
                        }
                        LOG.debug("Skipping Upgrade Action {} since it has been finalized.", (Object)action.name());
                    }
                    catch (Exception e) {
                        LOG.error("Cannot instantiate Upgrade Action class {}", (Object)actionClass.getSimpleName(), (Object)e);
                    }
                } else {
                    LOG.warn("Found upgrade action class not of type org.apache.hadoop.hdds.upgrade.HDDSUpgradeAction : {}", (Object)actionClass.getName());
                }
            }
        });
    }
}

