/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.client.checksum;

import com.google.common.base.Preconditions;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.hadoop.hdds.client.ECReplicationConfig;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.scm.OzoneClientConfig;
import org.apache.hadoop.io.MD5Hash;
import org.apache.hadoop.ozone.client.checksum.AbstractBlockChecksumComputer;
import org.apache.hadoop.ozone.client.checksum.CrcComposer;
import org.apache.hadoop.ozone.client.checksum.CrcUtil;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.util.DataChecksum;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ECBlockChecksumComputer
extends AbstractBlockChecksumComputer {
    private static final Logger LOG = LoggerFactory.getLogger(ECBlockChecksumComputer.class);
    private List<ContainerProtos.ChunkInfo> chunkInfoList;
    private OmKeyInfo keyInfo;

    public ECBlockChecksumComputer(List<ContainerProtos.ChunkInfo> chunkInfoList, OmKeyInfo keyInfo) {
        this.chunkInfoList = chunkInfoList;
        this.keyInfo = keyInfo;
    }

    @Override
    public void compute(OzoneClientConfig.ChecksumCombineMode combineMode) throws IOException {
        switch (combineMode) {
            case MD5MD5CRC: {
                this.computeMd5Crc();
                return;
            }
            case COMPOSITE_CRC: {
                this.computeCompositeCrc();
                return;
            }
        }
        throw new IllegalArgumentException("Unsupported combine mode");
    }

    private void computeMd5Crc() throws IOException {
        Preconditions.checkArgument((this.chunkInfoList.size() > 0 ? 1 : 0) != 0);
        ContainerProtos.ChunkInfo firstChunkInfo = this.chunkInfoList.get(0);
        long chunkSize = firstChunkInfo.getLen();
        long bytesPerCrc = firstChunkInfo.getChecksumData().getBytesPerChecksum();
        int parityBytes = this.getParityBytes(chunkSize, bytesPerCrc);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        for (ContainerProtos.ChunkInfo chunkInfo : this.chunkInfoList) {
            ByteString stripeChecksum = chunkInfo.getStripeChecksum();
            Preconditions.checkNotNull((Object)stripeChecksum);
            byte[] checksumBytes = stripeChecksum.toByteArray();
            Preconditions.checkArgument((checksumBytes.length % 4 == 0 ? 1 : 0) != 0, (Object)"Checksum Bytes size does not match");
            ByteBuffer byteWrap = ByteBuffer.wrap(checksumBytes, 0, checksumBytes.length - parityBytes);
            byte[] currentChecksum = new byte[4];
            while (byteWrap.hasRemaining()) {
                byteWrap.get(currentChecksum);
                out.write(currentChecksum);
            }
        }
        MD5Hash fileMD5 = MD5Hash.digest((byte[])out.toByteArray());
        this.setOutBytes(fileMD5.getDigest());
        LOG.debug("Number of chunks={}, md5hash={}", (Object)this.chunkInfoList.size(), (Object)fileMD5);
    }

    private void computeCompositeCrc() throws IOException {
        DataChecksum.Type dataChecksumType;
        Preconditions.checkArgument((this.chunkInfoList.size() > 0 ? 1 : 0) != 0);
        ContainerProtos.ChunkInfo firstChunkInfo = this.chunkInfoList.get(0);
        switch (firstChunkInfo.getChecksumData().getType()) {
            case CRC32C: {
                dataChecksumType = DataChecksum.Type.CRC32C;
                break;
            }
            case CRC32: {
                dataChecksumType = DataChecksum.Type.CRC32;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported checksum type: " + firstChunkInfo.getChecksumData().getType());
            }
        }
        long bytesPerCrc = firstChunkInfo.getChecksumData().getBytesPerChecksum();
        ECReplicationConfig replicationConfig = (ECReplicationConfig)this.keyInfo.getReplicationConfig();
        long chunkSize = replicationConfig.getEcChunkSize();
        long bytesPerCrcOffset = chunkSize % bytesPerCrc;
        long keySize = this.keyInfo.getDataSize();
        int parityBytes = this.getParityBytes(chunkSize, bytesPerCrc);
        int numChecksumPerChunk = (int)Math.ceil((double)chunkSize / (double)bytesPerCrc);
        CrcComposer blockCrcComposer = CrcComposer.newCrcComposer((DataChecksum.Type)dataChecksumType, (long)bytesPerCrc);
        for (ContainerProtos.ChunkInfo chunkInfo : this.chunkInfoList) {
            ByteString stripeChecksum = chunkInfo.getStripeChecksum();
            Preconditions.checkNotNull((Object)stripeChecksum);
            byte[] checksumBytes = stripeChecksum.toByteArray();
            Preconditions.checkArgument((checksumBytes.length % 4 == 0 ? 1 : 0) != 0, (Object)"Checksum Bytes size does not match");
            CrcComposer chunkCrcComposer = CrcComposer.newCrcComposer((DataChecksum.Type)dataChecksumType, (long)bytesPerCrc);
            ByteBuffer byteWrap = ByteBuffer.wrap(checksumBytes, 0, checksumBytes.length - parityBytes);
            byte[] currentChecksum = new byte[4];
            long chunkOffsetIndex = 1L;
            while (byteWrap.hasRemaining()) {
                long currentChunkOffset = Long.MAX_VALUE;
                if (chunkOffsetIndex % (long)numChecksumPerChunk == 0L && bytesPerCrcOffset > 0L) {
                    currentChunkOffset = bytesPerCrcOffset;
                }
                byteWrap.get(currentChecksum);
                int checksumDataCrc = CrcUtil.readInt((byte[])currentChecksum, (int)0);
                long chunkSizePerChecksum = Math.min(Math.min(keySize, bytesPerCrc), currentChunkOffset);
                chunkCrcComposer.update(checksumDataCrc, chunkSizePerChecksum);
                int chunkChecksumCrc = CrcUtil.readInt((byte[])chunkCrcComposer.digest(), (int)0);
                blockCrcComposer.update(chunkChecksumCrc, chunkSizePerChecksum);
                keySize -= Math.min(bytesPerCrc, currentChunkOffset);
                ++chunkOffsetIndex;
            }
        }
        byte[] compositeCrcChunkChecksum = blockCrcComposer.digest();
        this.setOutBytes(compositeCrcChunkChecksum);
        LOG.debug("Number of chunks = {}, chunk checksum type is {}, composite checksum = {}", new Object[]{this.chunkInfoList.size(), dataChecksumType, compositeCrcChunkChecksum});
    }

    private int getParityBytes(long chunkSize, long bytesPerCrc) {
        ECReplicationConfig replicationConfig = (ECReplicationConfig)this.keyInfo.getReplicationConfig();
        int numParity = replicationConfig.getParity();
        int parityBytes = (int)(Math.ceil((double)chunkSize / (double)bytesPerCrc) * 4.0 * (double)numParity);
        return parityBytes;
    }
}

