/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.jackson.databind.exc;

import io.trino.jdbc.$internal.jackson.databind.DeserializationContext;
import io.trino.jdbc.$internal.jackson.databind.JavaType;
import io.trino.jdbc.$internal.jackson.databind.PropertyName;
import io.trino.jdbc.$internal.jackson.databind.exc.MismatchedInputException;
import io.trino.jdbc.$internal.jackson.databind.util.ClassUtil;

public class InvalidNullException
extends MismatchedInputException {
    private static final long serialVersionUID = 1L;
    protected final PropertyName _propertyName;

    protected InvalidNullException(DeserializationContext ctxt, String msg, PropertyName pname) {
        super(ctxt == null ? null : ctxt.getParser(), msg);
        this._propertyName = pname;
    }

    public static InvalidNullException from(DeserializationContext ctxt, PropertyName name, JavaType type) {
        String msg = String.format("Invalid `null` value encountered for property %s", ClassUtil.quotedOr(name, "<UNKNOWN>"));
        InvalidNullException exc = new InvalidNullException(ctxt, msg, name);
        if (type != null) {
            exc.setTargetType(type);
        }
        return exc;
    }

    public PropertyName getPropertyName() {
        return this._propertyName;
    }
}

