/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.utils;

import java.util.ArrayList;
import java.util.List;
import org.apache.atlas.model.Clearable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FixedBufferList<T extends Clearable> {
    private static final Logger LOG = LoggerFactory.getLogger(FixedBufferList.class);
    private final Class<T> itemClass;
    private final ArrayList<T> buffer;
    private final int incrementCapacityBy;
    private int length;

    public FixedBufferList(Class<T> clazz) {
        this(clazz, 1);
    }

    public FixedBufferList(Class<T> clazz, int incrementCapacityBy) {
        this.incrementCapacityBy = incrementCapacityBy <= 0 ? 1 : incrementCapacityBy;
        this.itemClass = clazz;
        this.buffer = new ArrayList();
    }

    public T next() {
        this.request(this.length + 1);
        return (T)((Clearable)this.buffer.get(this.length++));
    }

    public List<T> toList() {
        return this.buffer.subList(0, this.length);
    }

    public void reset() {
        for (int i = 0; i < this.buffer.size(); ++i) {
            ((Clearable)this.buffer.get(i)).clear();
        }
        this.length = 0;
    }

    private void request(int requestedCapacity) {
        if (requestedCapacity <= this.buffer.size()) {
            return;
        }
        int oldCapacity = this.buffer.size();
        int newCapacity = oldCapacity + this.incrementCapacityBy;
        this.buffer.ensureCapacity(newCapacity);
        this.instantiateItems(oldCapacity, newCapacity);
        if (LOG.isDebugEnabled()) {
            LOG.debug("FixedBufferList: Requested: {} From: {} To:{}", new Object[]{requestedCapacity, oldCapacity, newCapacity});
        }
    }

    private void instantiateItems(int startIndex, int maxSize) {
        for (int i = startIndex; i < maxSize; ++i) {
            try {
                this.buffer.add(this.itemClass.newInstance());
                continue;
            }
            catch (InstantiationException e) {
                LOG.error("FixedBufferList: InstantiationException: Instantiation failed!", (Throwable)e);
                continue;
            }
            catch (IllegalAccessException e) {
                LOG.error("FixedBufferList: IllegalAccessException: Instantiation failed!", (Throwable)e);
            }
        }
    }
}

