/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.acls.domain;

import org.springframework.security.acls.domain.AclFormattingUtils;
import org.springframework.security.acls.model.Permission;

public abstract class AbstractPermission
implements Permission {
    protected final char code;
    protected int mask;

    protected AbstractPermission(int mask) {
        this.mask = mask;
        this.code = (char)42;
    }

    protected AbstractPermission(int mask, char code) {
        this.mask = mask;
        this.code = code;
    }

    public final boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Permission)) {
            return false;
        }
        Permission other = (Permission)obj;
        return this.mask == other.getMask();
    }

    public final int hashCode() {
        return this.mask;
    }

    public final String toString() {
        return this.getClass().getSimpleName() + "[" + this.getPattern() + "=" + this.mask + "]";
    }

    @Override
    public final int getMask() {
        return this.mask;
    }

    @Override
    public String getPattern() {
        return AclFormattingUtils.printBinary(this.mask, this.code);
    }
}

