/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.security.sasl.SaslException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.client.MetricsConnection;
import org.apache.hadoop.hbase.codec.Codec;
import org.apache.hadoop.hbase.ipc.Call;
import org.apache.hadoop.hbase.ipc.CallTimeoutException;
import org.apache.hadoop.hbase.ipc.CellBlockBuilder;
import org.apache.hadoop.hbase.ipc.ConnectionId;
import org.apache.hadoop.hbase.ipc.HBaseRpcController;
import org.apache.hadoop.hbase.ipc.IPCUtil;
import org.apache.hadoop.hbase.net.Address;
import org.apache.hadoop.hbase.security.AuthMethod;
import org.apache.hadoop.hbase.security.SecurityInfo;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.provider.SaslClientAuthenticationProvider;
import org.apache.hadoop.hbase.security.provider.SaslClientAuthenticationProviders;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RPCProtos;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.apache.hbase.thirdparty.com.google.protobuf.MessageOrBuilder;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcCallback;
import org.apache.hbase.thirdparty.com.google.protobuf.TextFormat;
import org.apache.hbase.thirdparty.com.google.protobuf.UnsafeByteOperations;
import org.apache.hbase.thirdparty.io.netty.util.HashedWheelTimer;
import org.apache.hbase.thirdparty.io.netty.util.Timeout;
import org.apache.hbase.thirdparty.io.netty.util.TimerTask;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
abstract class RpcConnection {
    private static final Logger LOG = LoggerFactory.getLogger(RpcConnection.class);
    protected final ConnectionId remoteId;
    protected final boolean useSasl;
    protected final Token<? extends TokenIdentifier> token;
    protected final SecurityInfo securityInfo;
    protected final int reloginMaxBackoff;
    protected final Codec codec;
    protected final CompressionCodec compressor;
    protected final CellBlockBuilder cellBlockBuilder;
    protected final MetricsConnection metrics;
    private final Map<String, byte[]> connectionAttributes;
    protected final HashedWheelTimer timeoutTimer;
    protected final Configuration conf;
    protected static String CRYPTO_AES_ENABLED_KEY = "hbase.rpc.crypto.encryption.aes.enabled";
    protected static boolean CRYPTO_AES_ENABLED_DEFAULT = false;
    protected long lastTouched;
    protected SaslClientAuthenticationProvider provider;
    private String lastSucceededServerPrincipal;

    protected RpcConnection(Configuration conf, HashedWheelTimer timeoutTimer, ConnectionId remoteId, String clusterId, boolean isSecurityEnabled, Codec codec, CompressionCodec compressor, CellBlockBuilder cellBlockBuilder, MetricsConnection metrics, Map<String, byte[]> connectionAttributes) throws IOException {
        Pair<SaslClientAuthenticationProvider, Token<? extends TokenIdentifier>> pair;
        this.timeoutTimer = timeoutTimer;
        this.codec = codec;
        this.compressor = compressor;
        this.cellBlockBuilder = cellBlockBuilder;
        this.conf = conf;
        this.metrics = metrics;
        this.connectionAttributes = connectionAttributes;
        User ticket = remoteId.getTicket();
        this.securityInfo = SecurityInfo.getInfo(remoteId.getServiceName());
        this.useSasl = isSecurityEnabled;
        SaslClientAuthenticationProviders providers = SaslClientAuthenticationProviders.getInstance(conf);
        if (this.useSasl && this.securityInfo != null) {
            pair = providers.selectProvider(clusterId, ticket);
            if (pair == null) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Found no valid authentication method from providers={} with tokens={}", (Object)providers.toString(), (Object)ticket.getTokens());
                }
                throw new RuntimeException("Found no valid authentication method from options");
            }
        } else if (!this.useSasl) {
            pair = providers.getSimpleProvider();
        } else {
            throw new RuntimeException("Could not compute valid client authentication provider");
        }
        this.provider = (SaslClientAuthenticationProvider)pair.getFirst();
        this.token = (Token)pair.getSecond();
        LOG.debug("Using {} authentication for service={}, sasl={}", new Object[]{this.provider.getSaslAuthMethod().getName(), remoteId.serviceName, this.useSasl});
        this.reloginMaxBackoff = conf.getInt("hbase.security.relogin.maxbackoff", 5000);
        this.remoteId = remoteId;
    }

    protected final void scheduleTimeoutTask(final Call call) {
        if (call.timeout > 0) {
            call.timeoutTask = this.timeoutTimer.newTimeout(new TimerTask(){

                public void run(Timeout timeout) throws Exception {
                    call.setTimeout((IOException)((Object)new CallTimeoutException(call.toShortString() + ", waitTime=" + (EnvironmentEdgeManager.currentTime() - call.getStartTime()) + "ms, rpcTimeout=" + call.timeout + "ms")));
                    RpcConnection.this.callTimeout(call);
                }
            }, (long)call.timeout, TimeUnit.MILLISECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] getConnectionHeaderPreamble() {
        int rpcHeaderLen = HConstants.RPC_HEADER.length;
        byte[] preamble = new byte[rpcHeaderLen + 2];
        System.arraycopy(HConstants.RPC_HEADER, 0, preamble, 0, rpcHeaderLen);
        preamble[rpcHeaderLen] = 0;
        RpcConnection rpcConnection = this;
        synchronized (rpcConnection) {
            preamble[preamble.length - 1] = this.provider.getSaslAuthMethod().getCode();
        }
        return preamble;
    }

    protected final RPCProtos.ConnectionHeader getConnectionHeader() {
        RPCProtos.ConnectionHeader.Builder builder = RPCProtos.ConnectionHeader.newBuilder();
        builder.setServiceName(this.remoteId.getServiceName());
        RPCProtos.UserInformation userInfoPB = this.provider.getUserInfo(this.remoteId.ticket);
        if (userInfoPB != null) {
            builder.setUserInfo(userInfoPB);
        }
        if (this.codec != null) {
            builder.setCellBlockCodecClass(this.codec.getClass().getCanonicalName());
        }
        if (this.compressor != null) {
            builder.setCellBlockCompressorClass(this.compressor.getClass().getCanonicalName());
        }
        if (this.connectionAttributes != null && !this.connectionAttributes.isEmpty()) {
            HBaseProtos.NameBytesPair.Builder attributeBuilder = HBaseProtos.NameBytesPair.newBuilder();
            for (Map.Entry<String, byte[]> attribute : this.connectionAttributes.entrySet()) {
                attributeBuilder.setName(attribute.getKey());
                attributeBuilder.setValue(UnsafeByteOperations.unsafeWrap((byte[])attribute.getValue()));
                builder.addAttribute(attributeBuilder.build());
            }
        }
        builder.setVersionInfo(ProtobufUtil.getVersionInfo());
        boolean isCryptoAESEnable = this.conf.getBoolean(CRYPTO_AES_ENABLED_KEY, CRYPTO_AES_ENABLED_DEFAULT);
        if (isCryptoAESEnable) {
            builder.setRpcCryptoCipherTransformation(this.conf.get("hbase.rpc.crypto.encryption.aes.cipher.transform", "AES/CTR/NoPadding"));
        }
        return builder.build();
    }

    protected final InetSocketAddress getRemoteInetAddress(MetricsConnection metrics) throws UnknownHostException {
        InetSocketAddress remoteAddr;
        if (metrics != null) {
            metrics.incrNsLookups();
        }
        if ((remoteAddr = Address.toSocketAddress((Address)this.remoteId.getAddress())).isUnresolved()) {
            if (metrics != null) {
                metrics.incrNsLookupsFailed();
            }
            throw new UnknownHostException(this.remoteId.getAddress() + " could not be resolved");
        }
        return remoteAddr;
    }

    private static boolean useCanonicalHostname(Configuration conf) {
        return !conf.getBoolean("hbase.unsafe.client.kerberos.hostname.disable.reversedns", false);
    }

    private static String getHostnameForServerPrincipal(Configuration conf, InetAddress addr) {
        String hostname;
        if (RpcConnection.useCanonicalHostname(conf)) {
            hostname = addr.getCanonicalHostName();
            if (hostname.equals(addr.getHostAddress())) {
                LOG.warn("Canonical hostname for SASL principal is the same with IP address: " + hostname + ", " + addr.getHostName() + ". Check DNS configuration or consider " + "hbase.unsafe.client.kerberos.hostname.disable.reversedns" + "=true");
            }
        } else {
            hostname = addr.getHostName();
        }
        return hostname.toLowerCase();
    }

    private static String getServerPrincipal(Configuration conf, String serverKey, InetAddress server) throws IOException {
        String hostname = RpcConnection.getHostnameForServerPrincipal(conf, server);
        return SecurityUtil.getServerPrincipal((String)conf.get(serverKey), (String)hostname);
    }

    protected final boolean isKerberosAuth() {
        return this.provider.getSaslAuthMethod().getCode() == AuthMethod.KERBEROS.code;
    }

    protected final Set<String> getServerPrincipals() throws IOException {
        if (!this.isKerberosAuth()) {
            return Collections.singleton("");
        }
        if (this.lastSucceededServerPrincipal != null) {
            return Collections.singleton(this.lastSucceededServerPrincipal);
        }
        InetAddress server = new InetSocketAddress(this.remoteId.address.getHostName(), this.remoteId.address.getPort()).getAddress();
        TreeSet<String> serverPrincipals = new TreeSet<String>();
        for (String serverPrincipalKey : this.securityInfo.getServerPrincipals()) {
            serverPrincipals.add(RpcConnection.getServerPrincipal(this.conf, serverPrincipalKey, server));
        }
        return serverPrincipals;
    }

    protected final <T> T randomSelect(Collection<T> c) {
        int select = ThreadLocalRandom.current().nextInt(c.size());
        int index = 0;
        for (T t : c) {
            if (index == select) {
                return t;
            }
            ++index;
        }
        return null;
    }

    protected final String chooseServerPrincipal(Set<String> candidates, Call securityPreambleCall) throws SaslException {
        String principal = ((RPCProtos.SecurityPreamableResponse)securityPreambleCall.response).getServerPrincipal();
        if (!candidates.contains(principal)) {
            throw new SaslException(this.remoteId.address + " tells us to use server principal " + principal + " which is not expected, should be one of " + candidates);
        }
        return principal;
    }

    protected final void saslNegotiationDone(String serverPrincipal, boolean succeed) {
        LOG.debug("sasl negotiation done with serverPrincipal = {}, succeed = {}", (Object)serverPrincipal, (Object)succeed);
        this.lastSucceededServerPrincipal = succeed ? serverPrincipal : null;
    }

    protected abstract void callTimeout(Call var1);

    public ConnectionId remoteId() {
        return this.remoteId;
    }

    public long getLastTouched() {
        return this.lastTouched;
    }

    public void setLastTouched(long lastTouched) {
        this.lastTouched = lastTouched;
    }

    public abstract boolean isActive();

    public abstract void shutdown();

    public abstract void sendRequest(Call var1, HBaseRpcController var2) throws IOException;

    public abstract void cleanupConnection();

    protected final Call createSecurityPreambleCall(RpcCallback<Call> callback) {
        return new Call(-1, null, null, null, (Message)RPCProtos.SecurityPreamableResponse.getDefaultInstance(), 0, 0, Collections.emptyMap(), callback, MetricsConnection.newCallStats());
    }

    private <T extends InputStream> void finishCall(RPCProtos.ResponseHeader responseHeader, T in, Call call) throws IOException {
        CellScanner cellBlockScanner;
        Message value;
        if (call.responseDefaultType != null) {
            Message.Builder builder = call.responseDefaultType.newBuilderForType();
            if (!builder.mergeDelimitedFrom(in)) {
                call.setException(new EOFException("EOF while reading response with type: " + call.responseDefaultType.getClass().getName()));
                return;
            }
            value = builder.build();
        } else {
            value = null;
        }
        if (responseHeader.hasCellBlockMeta()) {
            int size = responseHeader.getCellBlockMeta().getLength();
            byte[] cellBlock = new byte[size];
            ((DataInput)((Object)in)).readFully(cellBlock);
            cellBlockScanner = this.cellBlockBuilder.createCellScanner(this.codec, this.compressor, cellBlock);
        } else {
            cellBlockScanner = null;
        }
        call.setResponse(value, cellBlockScanner);
    }

    <T extends InputStream> void readResponse(T in, Map<Integer, Call> id2Call, Call preambleCall, Consumer<RemoteException> fatalConnectionErrorConsumer) throws IOException {
        Call call;
        RemoteException remoteExc;
        int totalSize = ((DataInput)((Object)in)).readInt();
        RPCProtos.ResponseHeader responseHeader = RPCProtos.ResponseHeader.parseDelimitedFrom(in);
        int id = responseHeader.getCallId();
        if (LOG.isTraceEnabled()) {
            LOG.trace("got response header " + TextFormat.shortDebugString((MessageOrBuilder)responseHeader) + ", totalSize: " + totalSize + " bytes");
        }
        if (responseHeader.hasException()) {
            RPCProtos.ExceptionResponse exceptionResponse = responseHeader.getException();
            remoteExc = IPCUtil.createRemoteException(exceptionResponse);
            if (IPCUtil.isFatalConnectionException(exceptionResponse)) {
                fatalConnectionErrorConsumer.accept(remoteExc);
                if (preambleCall != null) {
                    preambleCall.setException((IOException)((Object)remoteExc));
                }
                return;
            }
        } else {
            remoteExc = null;
        }
        if (id < 0) {
            LOG.debug("process preamble call response with response type {}", (Object)(preambleCall != null ? preambleCall.responseDefaultType.getDescriptorForType().getName() : "null"));
            if (preambleCall == null) {
                LOG.warn("Got a negative call id {} but there is no preamble call", (Object)id);
            } else {
                if (remoteExc != null) {
                    preambleCall.setException((IOException)((Object)remoteExc));
                } else {
                    this.finishCall(responseHeader, in, preambleCall);
                }
                return;
            }
        }
        if ((call = id2Call.remove(id)) == null) {
            if (LOG.isDebugEnabled()) {
                int readSoFar = IPCUtil.getTotalSizeWhenWrittenDelimited(new Message[]{responseHeader});
                int whatIsLeftToRead = totalSize - readSoFar;
                LOG.debug("Unknown callId: " + id + ", skipping over this response of " + whatIsLeftToRead + " bytes");
            }
            return;
        }
        call.callStats.setResponseSizeBytes(totalSize);
        if (remoteExc != null) {
            call.setException((IOException)((Object)remoteExc));
            return;
        }
        try {
            this.finishCall(responseHeader, in, call);
        }
        catch (IOException e) {
            call.setException(e);
            throw e;
        }
    }
}

