/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.config;

import com.netflix.config.ConcurrentCompositeConfiguration;
import com.netflix.config.ConfigurationManager;
import com.netflix.config.DynamicBooleanProperty;
import com.netflix.config.DynamicDoubleProperty;
import com.netflix.config.DynamicFloatProperty;
import com.netflix.config.DynamicIntProperty;
import com.netflix.config.DynamicLongProperty;
import com.netflix.config.DynamicPropertyFactory;
import com.netflix.config.DynamicStringProperty;
import java.util.Arrays;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.IntConsumer;
import java.util.function.LongConsumer;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.servicecomb.config.DynamicProperties;
import org.springframework.stereotype.Component;

@Component
class DynamicPropertiesImpl
implements DynamicProperties {
    public DynamicPropertiesImpl() {
    }

    public DynamicPropertiesImpl(AbstractConfiguration ... configurations) {
        ConcurrentCompositeConfiguration configuration = new ConcurrentCompositeConfiguration();
        Arrays.stream(configurations).forEach(arg_0 -> ((ConcurrentCompositeConfiguration)configuration).addConfiguration(arg_0));
        ConfigurationManager.install((AbstractConfiguration)configuration);
    }

    @Override
    public String getStringProperty(String propertyName, Consumer<String> consumer, String defaultValue) {
        DynamicStringProperty prop = this.propertyFactoryInstance().getStringProperty(propertyName, defaultValue);
        prop.addCallback(() -> consumer.accept(prop.get()));
        return prop.get();
    }

    @Override
    public String getStringProperty(String propertyName, String defaultValue) {
        return this.propertyFactoryInstance().getStringProperty(propertyName, defaultValue).get();
    }

    @Override
    public int getIntProperty(String propertyName, IntConsumer consumer, int defaultValue) {
        DynamicIntProperty prop = this.propertyFactoryInstance().getIntProperty(propertyName, defaultValue);
        prop.addCallback(() -> consumer.accept(prop.get()));
        return prop.get();
    }

    @Override
    public int getIntProperty(String propertyName, int defaultValue) {
        return this.propertyFactoryInstance().getIntProperty(propertyName, defaultValue).get();
    }

    @Override
    public long getLongProperty(String propertyName, LongConsumer consumer, long defaultValue) {
        DynamicLongProperty prop = this.propertyFactoryInstance().getLongProperty(propertyName, defaultValue);
        prop.addCallback(() -> consumer.accept(prop.get()));
        return prop.get();
    }

    @Override
    public long getLongProperty(String propertyName, long defaultValue) {
        return this.propertyFactoryInstance().getLongProperty(propertyName, defaultValue).get();
    }

    @Override
    public float getFloatProperty(String propertyName, DoubleConsumer consumer, float defaultValue) {
        DynamicFloatProperty prop = this.propertyFactoryInstance().getFloatProperty(propertyName, defaultValue);
        prop.addCallback(() -> consumer.accept(prop.get()));
        return prop.get();
    }

    @Override
    public float getFloatProperty(String propertyName, float defaultValue) {
        return this.propertyFactoryInstance().getFloatProperty(propertyName, defaultValue).get();
    }

    @Override
    public double getDoubleProperty(String propertyName, DoubleConsumer consumer, double defaultValue) {
        DynamicDoubleProperty prop = this.propertyFactoryInstance().getDoubleProperty(propertyName, defaultValue);
        prop.addCallback(() -> consumer.accept(prop.get()));
        return prop.get();
    }

    @Override
    public double getDoubleProperty(String propertyName, double defaultValue) {
        return this.propertyFactoryInstance().getDoubleProperty(propertyName, defaultValue).get();
    }

    @Override
    public boolean getBooleanProperty(String propertyName, Consumer<Boolean> consumer, boolean defaultValue) {
        DynamicBooleanProperty prop = this.propertyFactoryInstance().getBooleanProperty(propertyName, defaultValue);
        prop.addCallback(() -> consumer.accept(prop.get()));
        return prop.get();
    }

    @Override
    public boolean getBooleanProperty(String propertyName, boolean defaultValue) {
        return this.propertyFactoryInstance().getBooleanProperty(propertyName, defaultValue).get();
    }

    private DynamicPropertyFactory propertyFactoryInstance() {
        return DynamicPropertyFactory.getInstance();
    }
}

