/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.localregistry;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.config.BootStrapProperties;

public class RegistryBean {
    private String id;
    private String serviceName;
    private String version;
    private String appId;
    private List<String> schemaIds = new ArrayList<String>();
    private final Map<String, Class<?>> schemaInterfaces = new HashMap();
    private Instances instances;

    public static RegistryBean buildFromYamlModel(String serviceName, Map<String, Object> serviceConfig) {
        return new RegistryBean().setId(RegistryBean.validId((String)serviceConfig.get("id"))).setServiceName(serviceName).setVersion((String)serviceConfig.get("version")).setAppId(RegistryBean.validAppId((String)serviceConfig.get("appid"))).setSchemaIds(RegistryBean.validListsValue((List)serviceConfig.get("schemaIds"))).setInstances(new Instances().setInstances(RegistryBean.validInstances((List)serviceConfig.get("instances"))));
    }

    private static List<Instance> validInstances(List<Map<String, Object>> instancesConfig) {
        if (instancesConfig == null) {
            return Collections.emptyList();
        }
        ArrayList<Instance> instances = new ArrayList<Instance>();
        for (Map<String, Object> instanceConfig : instancesConfig) {
            instances.add(new Instance().setEndpoints(RegistryBean.validListsValue((List)instanceConfig.get("endpoints"))));
        }
        return instances;
    }

    private static List<String> validListsValue(List<String> listsValue) {
        return listsValue == null ? Collections.emptyList() : listsValue;
    }

    private static String validId(String serviceId) {
        return StringUtils.isEmpty((CharSequence)serviceId) ? UUID.randomUUID().toString() : serviceId;
    }

    private static String validAppId(String configAppId) {
        if (!StringUtils.isEmpty((CharSequence)configAppId)) {
            return configAppId;
        }
        return BootStrapProperties.readApplication();
    }

    public String getId() {
        return this.id;
    }

    public RegistryBean setId(String id) {
        this.id = id;
        return this;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public RegistryBean setServiceName(String serviceName) {
        this.serviceName = serviceName;
        return this;
    }

    public String getVersion() {
        return this.version;
    }

    public RegistryBean setVersion(String version) {
        this.version = version;
        return this;
    }

    public String getAppId() {
        return this.appId;
    }

    public RegistryBean setAppId(String appId) {
        this.appId = appId;
        return this;
    }

    public List<String> getSchemaIds() {
        return this.schemaIds;
    }

    public RegistryBean addSchemaId(String schemaId) {
        this.schemaIds.add(schemaId);
        return this;
    }

    public RegistryBean addSchemaInterface(String schemaId, Class<?> schemaInterface) {
        this.schemaInterfaces.put(schemaId, schemaInterface);
        this.schemaIds.add(schemaId);
        return this;
    }

    public Map<String, Class<?>> getSchemaInterfaces() {
        return this.schemaInterfaces;
    }

    public RegistryBean setSchemaIds(List<String> schemaIds) {
        this.schemaIds = schemaIds;
        return this;
    }

    public Instances getInstances() {
        return this.instances;
    }

    public RegistryBean setInstances(Instances instances) {
        this.instances = instances;
        return this;
    }

    public static class Instance {
        private List<String> endpoints;

        public List<String> getEndpoints() {
            return this.endpoints;
        }

        public Instance setEndpoints(List<String> endpoints) {
            this.endpoints = endpoints;
            return this;
        }
    }

    public static class Instances {
        private List<Instance> instances;

        public List<Instance> getInstances() {
            return this.instances;
        }

        public Instances setInstances(List<Instance> instances) {
            this.instances = instances;
            return this;
        }
    }
}

