/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.jdbc.common.dao;

import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.profiling.continuous.storage.ContinuousProfilingPolicy;
import org.apache.skywalking.oap.server.core.storage.SessionCacheCallback;
import org.apache.skywalking.oap.server.core.storage.model.Model;
import org.apache.skywalking.oap.server.core.storage.profiling.continuous.IContinuousProfilingPolicyDAO;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Storage;
import org.apache.skywalking.oap.server.core.storage.type.HashMapConverter;
import org.apache.skywalking.oap.server.library.client.jdbc.hikaricp.JDBCClient;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.SQLExecutor;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.TableMetaInfo;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.common.TableHelper;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.common.dao.JDBCSQLExecutor;

public class JDBCContinuousProfilingPolicyDAO
extends JDBCSQLExecutor
implements IContinuousProfilingPolicyDAO {
    private final JDBCClient jdbcClient;
    private final TableHelper tableHelper;

    public void savePolicy(ContinuousProfilingPolicy policy) throws IOException {
        List<ContinuousProfilingPolicy> existingPolicy = this.queryPolicies(Arrays.asList(policy.getServiceId()));
        Model model = TableMetaInfo.get("continuous_profiling_policy");
        SQLExecutor sqlExecutor = CollectionUtils.isNotEmpty(existingPolicy) ? this.getUpdateExecutor(model, policy, 0L, new ContinuousProfilingPolicy.Builder(), (SessionCacheCallback)null) : this.getInsertExecutor(model, policy, 0L, new ContinuousProfilingPolicy.Builder(), (Convert2Storage<Map<String, Object>>)new HashMapConverter.ToStorage(), (SessionCacheCallback)null);
        try (Connection connection = this.jdbcClient.getConnection();){
            sqlExecutor.invoke(connection);
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    public List<ContinuousProfilingPolicy> queryPolicies(List<String> serviceIdList) throws IOException {
        List<String> tables = this.tableHelper.getTablesWithinTTL("continuous_profiling_policy");
        ArrayList<String> condition = new ArrayList<String>();
        condition.add("continuous_profiling_policy");
        condition.addAll(serviceIdList);
        StringBuilder whereQuery = new StringBuilder().append(" where ").append("table_name").append(" = ?").append(" and ").append("service_id").append(" in ").append(serviceIdList.stream().map(s -> "?").collect(Collectors.joining(",", "(", ")")));
        ArrayList<ContinuousProfilingPolicy> results = new ArrayList<ContinuousProfilingPolicy>();
        for (String table : tables) {
            results.addAll((Collection)this.jdbcClient.executeQuery("select * from " + table + String.valueOf(whereQuery), this::buildPolicies, condition.toArray(new Object[0])));
        }
        return results;
    }

    private List<ContinuousProfilingPolicy> buildPolicies(ResultSet resultSet) throws SQLException {
        ArrayList<ContinuousProfilingPolicy> policies = new ArrayList<ContinuousProfilingPolicy>();
        while (resultSet.next()) {
            ContinuousProfilingPolicy policy = new ContinuousProfilingPolicy();
            policy.setServiceId(resultSet.getString("service_id"));
            policy.setUuid(resultSet.getString("uuid"));
            policy.setConfigurationJson(resultSet.getString("configuration_json"));
            policies.add(policy);
        }
        return policies;
    }

    @Generated
    public JDBCContinuousProfilingPolicyDAO(JDBCClient jdbcClient, TableHelper tableHelper) {
        this.jdbcClient = jdbcClient;
        this.tableHelper = tableHelper;
    }
}

