/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.classification;

import java.io.IOException;
import java.io.Serializable;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.classification.BinaryRandomForestClassificationSummaryImpl;
import org.apache.spark.ml.classification.BinaryRandomForestClassificationTrainingSummary;
import org.apache.spark.ml.classification.BinaryRandomForestClassificationTrainingSummaryImpl;
import org.apache.spark.ml.classification.DecisionTreeClassificationModel;
import org.apache.spark.ml.classification.ProbabilisticClassificationModel;
import org.apache.spark.ml.classification.ProbabilisticClassificationModel$;
import org.apache.spark.ml.classification.ProbabilisticClassifierParams;
import org.apache.spark.ml.classification.RandomForestClassificationModel$;
import org.apache.spark.ml.classification.RandomForestClassificationSummary;
import org.apache.spark.ml.classification.RandomForestClassificationSummaryImpl;
import org.apache.spark.ml.classification.RandomForestClassificationTrainingSummary;
import org.apache.spark.ml.classification.RandomForestClassificationTrainingSummaryImpl;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.SparseVector;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.LongParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasCheckpointInterval;
import org.apache.spark.ml.param.shared.HasSeed;
import org.apache.spark.ml.param.shared.HasWeightCol;
import org.apache.spark.ml.tree.DecisionTreeModel;
import org.apache.spark.ml.tree.DecisionTreeParams;
import org.apache.spark.ml.tree.EnsembleModelReadWrite$;
import org.apache.spark.ml.tree.Node;
import org.apache.spark.ml.tree.RandomForestClassifierParams;
import org.apache.spark.ml.tree.RandomForestParams;
import org.apache.spark.ml.tree.TreeClassifierParams;
import org.apache.spark.ml.tree.TreeEnsembleClassifierParams;
import org.apache.spark.ml.tree.TreeEnsembleModel;
import org.apache.spark.ml.tree.TreeEnsembleModel$;
import org.apache.spark.ml.tree.TreeEnsembleParams;
import org.apache.spark.ml.util.DefaultParamsReader;
import org.apache.spark.ml.util.HasTrainingSummary;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.ml.util.SchemaUtils$;
import org.apache.spark.mllib.tree.configuration.Algo$;
import org.apache.spark.mllib.tree.configuration.Strategy;
import org.apache.spark.mllib.tree.impurity.Impurity;
import org.apache.spark.mllib.tree.model.RandomForestModel;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.json4s.DefaultFormats$;
import org.json4s.ExtractableJsonAstNode$;
import org.json4s.Formats;
import org.json4s.JObject;
import org.json4s.JsonDSL$;
import org.json4s.MonadicJValue$;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.math.Numeric;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\rMb\u0001\u0002\u001a4\u0001yB\u0001\u0002\u001d\u0001\u0003\u0006\u0004%\t%\u001d\u0005\n\u0003\u000f\u0001!\u0011!Q\u0001\nID!\"a\u0003\u0001\u0005\u000b\u0007I\u0011BA\u0007\u0011)\t9\u0002\u0001B\u0001B\u0003%\u0011q\u0002\u0005\u000b\u00033\u0001!Q1A\u0005B\u0005m\u0001BCA\u0015\u0001\t\u0005\t\u0015!\u0003\u0002\u001e!Q\u0011Q\u0006\u0001\u0003\u0006\u0004%\t%a\u0007\t\u0015\u0005E\u0002A!A!\u0002\u0013\ti\u0002\u0003\u0005\u00026\u0001!\t!NA\u001c\u0011!\t)\u0004\u0001C\u0001k\u0005\u001d\u0003\u0002CA\u001b\u0001\u0011\u0005Q'!\u0015\t\u0011\u0005M\u0003\u0001\"\u00118\u0003+Bq!a\u0013\u0001\t\u0003\ni\u0001\u0003\u0006\u0002d\u0001A)\u0019!C\u0005\u0003KBq!a\u001c\u0001\t\u0003\n)\u0007C\u0004\u0002t\u0001!\t%!\u001e\t\u000f\u0005u\u0004\u0001\"\u0001\u0002\u0000!9\u0011\u0011\u0012\u0001\u0005\u0002\u0005-\u0005bBA_\u0001\u0011\u0005\u0013q\u0018\u0005\b\u0003'\u0004A\u0011IAk\u0011\u001d\ty\u0010\u0001C!\u0005\u0003AqA!\u0004\u0001\t#\u0012y\u0001C\u0004\u0003\u0016\u0001!\tEa\u0006\t\u000f\t-\u0002\u0001\"\u0011\u0003.!Q!\u0011\u0007\u0001\t\u0006\u0004%\tAa\r\t\u0011\t]\u0002\u0001\"\u00016\u0005sAqA!\u0014\u0001\t\u0003\u0012y\u0005\u0003\u0005\u0003^\u0001!\ta\u000eB0\u0011!\u0011\u0019\b\u0001C!o\tU\u0004\u0002\u0003B>\u0001\u0011\u0005sG! \b\u000f\t\u00155\u0007#\u0001\u0003\b\u001a1!g\rE\u0001\u0005\u0013Cq!!\u000e!\t\u0003\u0011)\u000bC\u0004\u0003(\u0002\"\tE!+\t\u000f\tM\u0006\u0005\"\u0011\u00036\u001a9!1\u0018\u0011\u0001A\tu\u0006\"\u0003B`I\t\u0005\t\u0015!\u0003J\u0011\u001d\t)\u0004\nC\u0001\u0005\u0003DqA!3%\t#\u0012YM\u0002\u0004\u0003P\u0002\"!\u0011\u001b\u0005\b\u0003kAC\u0011\u0001Bj\u0011%\u00119\u000e\u000bb\u0001\n\u0013\u0011I\u000e\u0003\u0005\u0003f\"\u0002\u000b\u0011\u0002Bn\u0011%\u00119\u000f\u000bb\u0001\n\u0013\u0011I\u000e\u0003\u0005\u0003j\"\u0002\u000b\u0011\u0002Bn\u0011\u001d\u0011\u0019\f\u000bC!\u0005WD\u0001Ba<!\t\u0003)$\u0011\u001f\u0005\u000b\u0007\u001f\u0001\u0013\u0013!C\u0001k\rE\u0001\"CB\u0013A\u0005\u0005I\u0011BB\u0014\u0005}\u0011\u0016M\u001c3p[\u001a{'/Z:u\u00072\f7o]5gS\u000e\fG/[8o\u001b>$W\r\u001c\u0006\u0003iU\nab\u00197bgNLg-[2bi&|gN\u0003\u00027o\u0005\u0011Q\u000e\u001c\u0006\u0003qe\nQa\u001d9be.T!AO\u001e\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005a\u0014aA8sO\u000e\u00011c\u0002\u0001@\u0015B3FL\u001b\t\u0005\u0001\u0006\u001b\u0015*D\u00014\u0013\t\u00115G\u0001\u0011Qe>\u0014\u0017MY5mSN$\u0018nY\"mCN\u001c\u0018NZ5dCRLwN\\'pI\u0016d\u0007C\u0001#H\u001b\u0005)%B\u0001$6\u0003\u0019a\u0017N\\1mO&\u0011\u0001*\u0012\u0002\u0007-\u0016\u001cGo\u001c:\u0011\u0005\u0001\u0003\u0001CA&O\u001b\u0005a%BA'6\u0003\u0011!(/Z3\n\u0005=c%\u0001\b*b]\u0012|WNR8sKN$8\t\\1tg&4\u0017.\u001a:QCJ\fWn\u001d\t\u0004\u0017F\u001b\u0016B\u0001*M\u0005E!&/Z3F]N,WN\u00197f\u001b>$W\r\u001c\t\u0003\u0001RK!!V\u001a\u0003?\u0011+7-[:j_:$&/Z3DY\u0006\u001c8/\u001b4jG\u0006$\u0018n\u001c8N_\u0012,G\u000e\u0005\u0002X56\t\u0001L\u0003\u0002Zk\u0005!Q\u000f^5m\u0013\tY\u0006L\u0001\u0006N\u0019^\u0013\u0018\u000e^1cY\u0016\u0004\"!X4\u000f\u0005y#gBA0c\u001b\u0005\u0001'BA1>\u0003\u0019a$o\\8u}%\t1-A\u0003tG\u0006d\u0017-\u0003\u0002fM\u00069\u0001/Y2lC\u001e,'\"A2\n\u0005!L'\u0001D*fe&\fG.\u001b>bE2,'BA3g!\r96.\\\u0005\u0003Yb\u0013!\u0003S1t)J\f\u0017N\\5oON+X.\\1ssB\u0011\u0001I\\\u0005\u0003_N\u0012\u0011FU1oI>lgi\u001c:fgR\u001cE.Y:tS\u001aL7-\u0019;j_:$&/Y5oS:<7+^7nCJL\u0018aA;jIV\t!\u000f\u0005\u0002to:\u0011A/\u001e\t\u0003?\u001aL!A\u001e4\u0002\rA\u0013X\rZ3g\u0013\tA\u0018P\u0001\u0004TiJLgn\u001a\u0006\u0003m\u001aDC!A>\u0002\u0004A\u0011Ap`\u0007\u0002{*\u0011apN\u0001\u000bC:tw\u000e^1uS>t\u0017bAA\u0001{\n)1+\u001b8dK\u0006\u0012\u0011QA\u0001\u0006c9*d\u0006M\u0001\u0005k&$\u0007\u0005\u000b\u0003\u0003w\u0006\r\u0011AB0ue\u0016,7/\u0006\u0002\u0002\u0010A)\u0011\u0011CA\n'6\ta-C\u0002\u0002\u0016\u0019\u0014Q!\u0011:sCf\fqa\u0018;sK\u0016\u001c\b%A\u0006ok64U-\u0019;ve\u0016\u001cXCAA\u000f!\u0011\t\t\"a\b\n\u0007\u0005\u0005bMA\u0002J]RDC!B>\u0002&\u0005\u0012\u0011qE\u0001\u0006c92d\u0006M\u0001\r]Vlg)Z1ukJ,7\u000f\t\u0015\u0005\rm\f)#\u0001\u0006ok6\u001cE.Y:tKNDCaB>\u0002\u0004\u0005Ya.^7DY\u0006\u001c8/Z:!Q\u0011A10a\u0001\u0002\rqJg.\u001b;?)%I\u0015\u0011HA\u001f\u0003\u007f\t\u0019\u0005C\u0003q\u0013\u0001\u0007!\u000fK\u0003\u0002:m\f\u0019\u0001C\u0004\u0002\f%\u0001\r!a\u0004\t\u000f\u0005e\u0011\u00021\u0001\u0002\u001e!*\u0011qH>\u0002&!9\u0011QF\u0005A\u0002\u0005u\u0001&BA\"w\u0006\rAcB%\u0002J\u00055\u0013q\n\u0005\b\u0003\u0017R\u0001\u0019AA\b\u0003\u0015!(/Z3t\u0011\u001d\tIB\u0003a\u0001\u0003;Aq!!\f\u000b\u0001\u0004\ti\u0002F\u0001J\u00035)7\u000f^5nCR,GmU5{KV\u0011\u0011q\u000b\t\u0005\u0003#\tI&C\u0002\u0002\\\u0019\u0014A\u0001T8oO\"\"Qb_A0C\t\t\t'A\u00032]Qr\u0003'\u0001\u0007`iJ,WmV3jO\"$8/\u0006\u0002\u0002hA1\u0011\u0011CA\n\u0003S\u0002B!!\u0005\u0002l%\u0019\u0011Q\u000e4\u0003\r\u0011{WO\u00197f\u0003-!(/Z3XK&<\u0007\u000e^:)\t=Y\u0018qL\u0001\bgVlW.\u0019:z+\u0005i\u0007\u0006\u0002\t|\u0003s\n#!a\u001f\u0002\u000bMr\u0013G\f\u0019\u0002\u001b\tLg.\u0019:z'VlW.\u0019:z+\t\t\t\tE\u0002A\u0003\u0007K1!!\"4\u0005=\u0012\u0015N\\1ssJ\u000bg\u000eZ8n\r>\u0014Xm\u001d;DY\u0006\u001c8/\u001b4jG\u0006$\u0018n\u001c8Ue\u0006Lg.\u001b8h'VlW.\u0019:zQ\u0011\t20!\u001f\u0002\u0011\u00154\u0018\r\\;bi\u0016$B!!$\u0002\u0014B\u0019\u0001)a$\n\u0007\u0005E5GA\u0011SC:$w.\u001c$pe\u0016\u001cHo\u00117bgNLg-[2bi&|gnU;n[\u0006\u0014\u0018\u0010C\u0004\u0002\u0016J\u0001\r!a&\u0002\u000f\u0011\fG/Y:fiB\"\u0011\u0011TAU!\u0019\tY*!)\u0002&6\u0011\u0011Q\u0014\u0006\u0004\u0003?;\u0014aA:rY&!\u00111UAO\u0005\u001d!\u0015\r^1tKR\u0004B!a*\u0002*2\u0001A\u0001DAV\u0003'\u000b\t\u0011!A\u0003\u0002\u00055&aA0%gE!\u0011qVA[!\u0011\t\t\"!-\n\u0007\u0005MfMA\u0004O_RD\u0017N\\4\u0011\t\u0005E\u0011qW\u0005\u0004\u0003s3'aA!os\"\"!c_A=\u0003=!(/\u00198tM>\u0014XnU2iK6\fG\u0003BAa\u0003\u001b\u0004B!a1\u0002J6\u0011\u0011Q\u0019\u0006\u0005\u0003\u000f\fi*A\u0003usB,7/\u0003\u0003\u0002L\u0006\u0015'AC*ueV\u001cG\u000fV=qK\"9\u0011qZ\nA\u0002\u0005\u0005\u0017AB:dQ\u0016l\u0017\r\u000b\u0003\u0014w\u0006}\u0013!\u0003;sC:\u001chm\u001c:n)\u0011\t9.a=\u0011\t\u0005e\u0017Q\u001e\b\u0005\u00037\fYO\u0004\u0003\u0002^\u0006%h\u0002BAp\u0003OtA!!9\u0002f:\u0019q,a9\n\u0003qJ!AO\u001e\n\u0005aJ\u0014bAAPo%\u0019Q-!(\n\t\u0005=\u0018\u0011\u001f\u0002\n\t\u0006$\u0018M\u0012:b[\u0016T1!ZAO\u0011\u001d\t)\n\u0006a\u0001\u0003k\u0004D!a>\u0002|B1\u00111TAQ\u0003s\u0004B!a*\u0002|\u0012a\u0011Q`Az\u0003\u0003\u0005\tQ!\u0001\u0002.\n\u0019q\f\n\u001b\u0002\u0015A\u0014X\rZ5diJ\u000bw\u000fF\u0002D\u0005\u0007AaA!\u0002\u0016\u0001\u0004\u0019\u0015\u0001\u00034fCR,(/Z:)\tUY(\u0011B\u0011\u0003\u0005\u0017\tQa\r\u00181]A\naC]1xeA\u0014xNY1cS2LG/_%o!2\f7-\u001a\u000b\u0004\u0007\nE\u0001B\u0002B\n-\u0001\u00071)A\u0007sC^\u0004&/\u001a3jGRLwN\\\u0001\u0005G>\u0004\u0018\u0010F\u0002J\u00053AqAa\u0007\u0018\u0001\u0004\u0011i\"A\u0003fqR\u0014\u0018\r\u0005\u0003\u0003 \t\u0015RB\u0001B\u0011\u0015\r\u0011\u0019#N\u0001\u0006a\u0006\u0014\u0018-\\\u0005\u0005\u0005O\u0011\tC\u0001\u0005QCJ\fW.T1qQ\u0011920a\u0018\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012A\u001d\u0015\u00051m\fy&\u0001\ngK\u0006$XO]3J[B|'\u000f^1oG\u0016\u001cX#A\")\teY\u00181A\u0001\u0006i>|E\u000eZ\u000b\u0003\u0005w\u0001BA!\u0010\u0003J5\u0011!q\b\u0006\u0005\u0005\u0003\u0012\u0019%A\u0003n_\u0012,GNC\u0002N\u0005\u000bR1Aa\u00128\u0003\u0015iG\u000e\\5c\u0013\u0011\u0011YEa\u0010\u0003#I\u000bg\u000eZ8n\r>\u0014Xm\u001d;N_\u0012,G.A\u0003xe&$X-\u0006\u0002\u0003RA\u0019qKa\u0015\n\u0007\tU\u0003L\u0001\u0005N\u0019^\u0013\u0018\u000e^3sQ\u0011Y2P!\u0017\"\u0005\tm\u0013!\u0002\u001a/a9\u0002\u0014!D2sK\u0006$XmU;n[\u0006\u0014\u0018\u0010\u0006\u0003\u0003b\t\u001d\u0004\u0003BA\t\u0005GJ1A!\u001ag\u0005\u0011)f.\u001b;\t\u000f\u0005UE\u00041\u0001\u0003jA\"!1\u000eB8!\u0019\tY*!)\u0003nA!\u0011q\u0015B8\t1\u0011\tHa\u001a\u0002\u0002\u0003\u0005)\u0011AAW\u0005\ryF%N\u0001\fg\u00064XmU;n[\u0006\u0014\u0018\u0010\u0006\u0003\u0003b\t]\u0004B\u0002B=;\u0001\u0007!/\u0001\u0003qCRD\u0017a\u00037pC\u0012\u001cV/\\7bef$bA!\u0019\u0003\u0000\t\u0005\u0005B\u0002B==\u0001\u0007!\u000fC\u0004\u0002\u0016z\u0001\r!a6)\t\u0001Y\u0018qL\u0001 %\u0006tGm\\7G_J,7\u000f^\"mCN\u001c\u0018NZ5dCRLwN\\'pI\u0016d\u0007C\u0001!!'\u001d\u0001#1\u0012BI\u0005/\u0003B!!\u0005\u0003\u000e&\u0019!q\u00124\u0003\r\u0005s\u0017PU3g!\u00119&1S%\n\u0007\tU\u0005L\u0001\u0006N\u0019J+\u0017\rZ1cY\u0016\u0004BA!'\u0003$6\u0011!1\u0014\u0006\u0005\u0005;\u0013y*\u0001\u0002j_*\u0011!\u0011U\u0001\u0005U\u00064\u0018-C\u0002i\u00057#\"Aa\"\u0002\tI,\u0017\rZ\u000b\u0003\u0005W\u0003Ba\u0016BW\u0013&\u0019!q\u0016-\u0003\u00115c%+Z1eKJDCAI>\u0003Z\u0005!An\\1e)\rI%q\u0017\u0005\u0007\u0005s\u001a\u0003\u0019\u0001:)\t\rZ(\u0011\f\u0002&%\u0006tGm\\7G_J,7\u000f^\"mCN\u001c\u0018NZ5dCRLwN\\'pI\u0016dwK]5uKJ\u001c2\u0001\nB)\u0003!Ign\u001d;b]\u000e,G\u0003\u0002Bb\u0005\u000f\u00042A!2%\u001b\u0005\u0001\u0003B\u0002B`M\u0001\u0007\u0011*\u0001\u0005tCZ,\u0017*\u001c9m)\u0011\u0011\tG!4\t\r\tet\u00051\u0001s\u0005\u0015\u0012\u0016M\u001c3p[\u001a{'/Z:u\u00072\f7o]5gS\u000e\fG/[8o\u001b>$W\r\u001c*fC\u0012,'oE\u0002)\u0005W#\"A!6\u0011\u0007\t\u0015\u0007&A\u0005dY\u0006\u001c8OT1nKV\u0011!1\u001c\t\u0005\u0005;\u0014\u0019/\u0004\u0002\u0003`*!!\u0011\u001dBP\u0003\u0011a\u0017M\\4\n\u0007a\u0014y.\u0001\u0006dY\u0006\u001c8OT1nK\u0002\nQ\u0002\u001e:fK\u000ec\u0017m]:OC6,\u0017A\u0004;sK\u0016\u001cE.Y:t\u001d\u0006lW\r\t\u000b\u0004\u0013\n5\bB\u0002B=]\u0001\u0007!/A\u0004ge>lw\n\u001c3\u0015\u0017%\u0013\u0019Pa>\u0004\u0002\r-1Q\u0002\u0005\b\u0005k|\u0003\u0019\u0001B\u001e\u0003!yG\u000eZ'pI\u0016d\u0007b\u0002B}_\u0001\u0007!1`\u0001\u0007a\u0006\u0014XM\u001c;\u0011\u0007\u0001\u0013i0C\u0002\u0003\u0000N\u0012aCU1oI>lgi\u001c:fgR\u001cE.Y:tS\u001aLWM\u001d\u0005\b\u0007\u0007y\u0003\u0019AB\u0003\u0003M\u0019\u0017\r^3h_JL7-\u00197GK\u0006$XO]3t!\u001d\u00198qAA\u000f\u0003;I1a!\u0003z\u0005\ri\u0015\r\u001d\u0005\b\u0003[y\u0003\u0019AA\u000f\u0011%\tIb\fI\u0001\u0002\u0004\ti\"A\tge>lw\n\u001c3%I\u00164\u0017-\u001e7uIU*\"aa\u0005+\t\u0005u1QC\u0016\u0003\u0007/\u0001Ba!\u0007\u0004\"5\u001111\u0004\u0006\u0005\u0007;\u0019y\"A\u0005v]\u000eDWmY6fI*\u0011aPZ\u0005\u0005\u0007G\u0019YBA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"a!\u000b\u0011\t\tu71F\u0005\u0005\u0007[\u0011yN\u0001\u0004PE*,7\r\u001e\u0015\u0005Am\u0014I\u0006\u000b\u0003 w\ne\u0003")
public class RandomForestClassificationModel
extends ProbabilisticClassificationModel<Vector, RandomForestClassificationModel>
implements RandomForestClassifierParams,
TreeEnsembleModel<DecisionTreeClassificationModel>,
MLWritable,
HasTrainingSummary<RandomForestClassificationTrainingSummary> {
    private double[] _treeWeights;
    private Vector featureImportances;
    private final String uid;
    private final DecisionTreeClassificationModel[] _trees;
    private final int numFeatures;
    private final int numClasses;
    private Option<RandomForestClassificationTrainingSummary> trainingSummary;
    private int totalNumNodes;
    private Param<String> impurity;
    private IntParam numTrees;
    private BooleanParam bootstrap;
    private DoubleParam subsamplingRate;
    private Param<String> featureSubsetStrategy;
    private Param<String> leafCol;
    private IntParam maxDepth;
    private IntParam maxBins;
    private IntParam minInstancesPerNode;
    private DoubleParam minWeightFractionPerNode;
    private DoubleParam minInfoGain;
    private IntParam maxMemoryInMB;
    private BooleanParam cacheNodeIds;
    private Param<String> weightCol;
    private LongParam seed;
    private IntParam checkpointInterval;
    private volatile byte bitmap$0;

    public static RandomForestClassificationModel load(String path) {
        return RandomForestClassificationModel$.MODULE$.load(path);
    }

    public static MLReader<RandomForestClassificationModel> read() {
        return RandomForestClassificationModel$.MODULE$.read();
    }

    @Override
    public boolean hasSummary() {
        return HasTrainingSummary.hasSummary$(this);
    }

    @Override
    public HasTrainingSummary<RandomForestClassificationTrainingSummary> setSummary(Option<RandomForestClassificationTrainingSummary> summary) {
        return HasTrainingSummary.setSummary$(this, summary);
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public DecisionTreeModel getTree(int i) {
        return TreeEnsembleModel.getTree$(this, i);
    }

    @Override
    public Vector javaTreeWeights() {
        return TreeEnsembleModel.javaTreeWeights$(this);
    }

    @Override
    public String toDebugString() {
        return TreeEnsembleModel.toDebugString$(this);
    }

    @Override
    public Vector predictLeaf(Vector features) {
        return TreeEnsembleModel.predictLeaf$(this, features);
    }

    @Override
    public StructField getLeafField(String leafCol) {
        return TreeEnsembleModel.getLeafField$(this, leafCol);
    }

    @Override
    public long getEstimatedSize() {
        return TreeEnsembleModel.getEstimatedSize$(this);
    }

    @Override
    public final String getImpurity() {
        return TreeClassifierParams.getImpurity$(this);
    }

    @Override
    public Impurity getOldImpurity() {
        return TreeClassifierParams.getOldImpurity$(this);
    }

    @Override
    public /* synthetic */ StructType org$apache$spark$ml$tree$TreeEnsembleClassifierParams$$super$validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return ProbabilisticClassifierParams.validateAndTransformSchema$(this, schema, fitting, featuresDataType);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return TreeEnsembleClassifierParams.validateAndTransformSchema$(this, schema, fitting, featuresDataType);
    }

    @Override
    public final int getNumTrees() {
        return RandomForestParams.getNumTrees$(this);
    }

    @Override
    public final boolean getBootstrap() {
        return RandomForestParams.getBootstrap$(this);
    }

    @Override
    public /* synthetic */ Strategy org$apache$spark$ml$tree$TreeEnsembleParams$$super$getOldStrategy(Map categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity, double subsamplingRate) {
        return DecisionTreeParams.getOldStrategy$(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity, subsamplingRate);
    }

    @Override
    public final double getSubsamplingRate() {
        return TreeEnsembleParams.getSubsamplingRate$(this);
    }

    @Override
    public Strategy getOldStrategy(Map<Object, Object> categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity) {
        return TreeEnsembleParams.getOldStrategy$(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity);
    }

    @Override
    public final String getFeatureSubsetStrategy() {
        return TreeEnsembleParams.getFeatureSubsetStrategy$(this);
    }

    @Override
    public final DecisionTreeParams setLeafCol(String value) {
        return DecisionTreeParams.setLeafCol$(this, value);
    }

    @Override
    public final String getLeafCol() {
        return DecisionTreeParams.getLeafCol$(this);
    }

    @Override
    public final int getMaxDepth() {
        return DecisionTreeParams.getMaxDepth$(this);
    }

    @Override
    public final int getMaxBins() {
        return DecisionTreeParams.getMaxBins$(this);
    }

    @Override
    public final int getMinInstancesPerNode() {
        return DecisionTreeParams.getMinInstancesPerNode$(this);
    }

    @Override
    public final double getMinWeightFractionPerNode() {
        return DecisionTreeParams.getMinWeightFractionPerNode$(this);
    }

    @Override
    public final double getMinInfoGain() {
        return DecisionTreeParams.getMinInfoGain$(this);
    }

    @Override
    public final int getMaxMemoryInMB() {
        return DecisionTreeParams.getMaxMemoryInMB$(this);
    }

    @Override
    public final boolean getCacheNodeIds() {
        return DecisionTreeParams.getCacheNodeIds$(this);
    }

    @Override
    public Strategy getOldStrategy(Map<Object, Object> categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity, double subsamplingRate) {
        return DecisionTreeParams.getOldStrategy$(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity, subsamplingRate);
    }

    @Override
    public final String getWeightCol() {
        return HasWeightCol.getWeightCol$(this);
    }

    @Override
    public final long getSeed() {
        return HasSeed.getSeed$(this);
    }

    @Override
    public final int getCheckpointInterval() {
        return HasCheckpointInterval.getCheckpointInterval$(this);
    }

    @Override
    public final Option<RandomForestClassificationTrainingSummary> trainingSummary() {
        return this.trainingSummary;
    }

    @Override
    public final void trainingSummary_$eq(Option<RandomForestClassificationTrainingSummary> x$1) {
        this.trainingSummary = x$1;
    }

    private int totalNumNodes$lzycompute() {
        RandomForestClassificationModel randomForestClassificationModel = this;
        synchronized (randomForestClassificationModel) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.totalNumNodes = TreeEnsembleModel.totalNumNodes$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.totalNumNodes;
    }

    @Override
    public int totalNumNodes() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.totalNumNodes$lzycompute();
        }
        return this.totalNumNodes;
    }

    @Override
    public final Param<String> impurity() {
        return this.impurity;
    }

    @Override
    public final void org$apache$spark$ml$tree$TreeClassifierParams$_setter_$impurity_$eq(Param<String> x$1) {
        this.impurity = x$1;
    }

    @Override
    public final IntParam numTrees() {
        return this.numTrees;
    }

    @Override
    public final BooleanParam bootstrap() {
        return this.bootstrap;
    }

    @Override
    public final void org$apache$spark$ml$tree$RandomForestParams$_setter_$numTrees_$eq(IntParam x$1) {
        this.numTrees = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$RandomForestParams$_setter_$bootstrap_$eq(BooleanParam x$1) {
        this.bootstrap = x$1;
    }

    @Override
    public final DoubleParam subsamplingRate() {
        return this.subsamplingRate;
    }

    @Override
    public final Param<String> featureSubsetStrategy() {
        return this.featureSubsetStrategy;
    }

    @Override
    public final void org$apache$spark$ml$tree$TreeEnsembleParams$_setter_$subsamplingRate_$eq(DoubleParam x$1) {
        this.subsamplingRate = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$TreeEnsembleParams$_setter_$featureSubsetStrategy_$eq(Param<String> x$1) {
        this.featureSubsetStrategy = x$1;
    }

    @Override
    public final Param<String> leafCol() {
        return this.leafCol;
    }

    @Override
    public final IntParam maxDepth() {
        return this.maxDepth;
    }

    @Override
    public final IntParam maxBins() {
        return this.maxBins;
    }

    @Override
    public final IntParam minInstancesPerNode() {
        return this.minInstancesPerNode;
    }

    @Override
    public final DoubleParam minWeightFractionPerNode() {
        return this.minWeightFractionPerNode;
    }

    @Override
    public final DoubleParam minInfoGain() {
        return this.minInfoGain;
    }

    @Override
    public final IntParam maxMemoryInMB() {
        return this.maxMemoryInMB;
    }

    @Override
    public final BooleanParam cacheNodeIds() {
        return this.cacheNodeIds;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$leafCol_$eq(Param<String> x$1) {
        this.leafCol = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxDepth_$eq(IntParam x$1) {
        this.maxDepth = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxBins_$eq(IntParam x$1) {
        this.maxBins = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$minInstancesPerNode_$eq(IntParam x$1) {
        this.minInstancesPerNode = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$minWeightFractionPerNode_$eq(DoubleParam x$1) {
        this.minWeightFractionPerNode = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$minInfoGain_$eq(DoubleParam x$1) {
        this.minInfoGain = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxMemoryInMB_$eq(IntParam x$1) {
        this.maxMemoryInMB = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$cacheNodeIds_$eq(BooleanParam x$1) {
        this.cacheNodeIds = x$1;
    }

    @Override
    public final Param<String> weightCol() {
        return this.weightCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasWeightCol$_setter_$weightCol_$eq(Param<String> x$1) {
        this.weightCol = x$1;
    }

    @Override
    public final LongParam seed() {
        return this.seed;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasSeed$_setter_$seed_$eq(LongParam x$1) {
        this.seed = x$1;
    }

    @Override
    public final IntParam checkpointInterval() {
        return this.checkpointInterval;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasCheckpointInterval$_setter_$checkpointInterval_$eq(IntParam x$1) {
        this.checkpointInterval = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    private DecisionTreeClassificationModel[] _trees() {
        return this._trees;
    }

    @Override
    public int numFeatures() {
        return this.numFeatures;
    }

    @Override
    public int numClasses() {
        return this.numClasses;
    }

    @Override
    public long estimatedSize() {
        return this.getEstimatedSize();
    }

    public DecisionTreeClassificationModel[] trees() {
        return this._trees();
    }

    private double[] _treeWeights$lzycompute() {
        RandomForestClassificationModel randomForestClassificationModel = this;
        synchronized (randomForestClassificationModel) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this._treeWeights = (double[])Array$.MODULE$.fill(this._trees().length, (Function0)(JFunction0.mcD.sp & Serializable)() -> 1.0, (ClassTag)ClassTag$.MODULE$.Double());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this._treeWeights;
    }

    private double[] _treeWeights() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this._treeWeights$lzycompute();
        }
        return this._treeWeights;
    }

    @Override
    public double[] treeWeights() {
        return this._treeWeights();
    }

    @Override
    public RandomForestClassificationTrainingSummary summary() {
        return (RandomForestClassificationTrainingSummary)HasTrainingSummary.summary$(this);
    }

    public BinaryRandomForestClassificationTrainingSummary binarySummary() {
        RandomForestClassificationTrainingSummary randomForestClassificationTrainingSummary = this.summary();
        if (randomForestClassificationTrainingSummary instanceof BinaryRandomForestClassificationTrainingSummary) {
            BinaryRandomForestClassificationTrainingSummary binaryRandomForestClassificationTrainingSummary = (BinaryRandomForestClassificationTrainingSummary)randomForestClassificationTrainingSummary;
            return binaryRandomForestClassificationTrainingSummary;
        }
        throw new RuntimeException("Cannot create a binary summary for a non-binary model(numClasses=" + this.numClasses() + "), use summary instead.");
    }

    public RandomForestClassificationSummary evaluate(Dataset<?> dataset) {
        String weightColName = !this.isDefined(this.weightCol()) ? "weightCol" : this.$(this.weightCol());
        Tuple3 tuple3 = this.findSummaryModel();
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        ProbabilisticClassificationModel summaryModel = (ProbabilisticClassificationModel)tuple3._1();
        String probabilityColName = (String)tuple3._2();
        String predictionColName = (String)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)summaryModel, (Object)probabilityColName, (Object)predictionColName);
        ProbabilisticClassificationModel summaryModel2 = (ProbabilisticClassificationModel)tuple32._1();
        String probabilityColName2 = (String)tuple32._2();
        String predictionColName2 = (String)tuple32._3();
        if (this.numClasses() > 2) {
            return new RandomForestClassificationSummaryImpl(summaryModel2.transform(dataset), predictionColName2, this.$(this.labelCol()), weightColName);
        }
        return new BinaryRandomForestClassificationSummaryImpl(summaryModel2.transform(dataset), probabilityColName2, predictionColName2, this.$(this.labelCol()), weightColName);
    }

    @Override
    public StructType transformSchema(StructType schema) {
        StructType outputSchema;
        block0: {
            outputSchema = super.transformSchema(schema);
            if (!StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.$(this.leafCol())))) break block0;
            outputSchema = SchemaUtils$.MODULE$.updateField(outputSchema, this.getLeafField(this.$(this.leafCol())), SchemaUtils$.MODULE$.updateField$default$3());
        }
        return outputSchema;
    }

    @Override
    public Dataset<Row> transform(Dataset<?> dataset) {
        StructType outputSchema = this.transformSchema(dataset.schema(), true);
        Dataset<Row> outputData = super.transform(dataset);
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.$(this.leafCol())))) {
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(RandomForestClassificationModel.class.getClassLoader());
            JavaUniverse $u2 = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(RandomForestClassificationModel.class.getClassLoader());
            public final class Org_apache_spark_ml_classification_RandomForestClassificationModel$$typecreator1$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                }

                public Org_apache_spark_ml_classification_RandomForestClassificationModel$$typecreator1$1(RandomForestClassificationModel $outer) {
                }
            }
            public final class Org_apache_spark_ml_classification_RandomForestClassificationModel$$typecreator2$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                }

                public Org_apache_spark_ml_classification_RandomForestClassificationModel$$typecreator2$1(RandomForestClassificationModel $outer) {
                }
            }
            UserDefinedFunction leafUDF = functions$.MODULE$.udf((Function1 & Serializable)features -> this.predictLeaf((Vector)features), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_classification_RandomForestClassificationModel$$typecreator1$1(null)), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_classification_RandomForestClassificationModel$$typecreator2$1(null)));
            return outputData.withColumn(this.$(this.leafCol()), leafUDF.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.featuresCol()))})), outputSchema.apply(this.$(this.leafCol())).metadata());
        }
        return outputData;
    }

    @Override
    public Vector predictRaw(Vector features) {
        double[] votes = (double[])Array$.MODULE$.ofDim(this.numClasses(), (ClassTag)ClassTag$.MODULE$.Double());
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])this._trees()), (Function1 & Serializable)tree -> {
            RandomForestClassificationModel.$anonfun$predictRaw$1(this, features, votes, tree);
            return BoxedUnit.UNIT;
        });
        return Vectors$.MODULE$.dense(votes);
    }

    @Override
    public Vector raw2probabilityInPlace(Vector rawPrediction) {
        Vector vector = rawPrediction;
        if (vector instanceof DenseVector) {
            DenseVector denseVector = (DenseVector)vector;
            ProbabilisticClassificationModel$.MODULE$.normalizeToProbabilitiesInPlace(denseVector);
            return denseVector;
        }
        if (vector instanceof SparseVector) {
            throw new RuntimeException("Unexpected error in RandomForestClassificationModel: raw2probabilityInPlace encountered SparseVector");
        }
        throw new MatchError((Object)vector);
    }

    @Override
    public RandomForestClassificationModel copy(ParamMap extra) {
        return (RandomForestClassificationModel)((Model)this.copyValues(new RandomForestClassificationModel(this.uid(), this._trees(), this.numFeatures(), this.numClasses()), extra)).setParent(this.parent());
    }

    @Override
    public String toString() {
        return "RandomForestClassificationModel: uid=" + this.uid() + ", numTrees=" + this.getNumTrees() + ", numClasses=" + this.numClasses() + ", numFeatures=" + this.numFeatures();
    }

    private Vector featureImportances$lzycompute() {
        RandomForestClassificationModel randomForestClassificationModel = this;
        synchronized (randomForestClassificationModel) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.featureImportances = TreeEnsembleModel$.MODULE$.featureImportances(this.trees(), this.numFeatures(), TreeEnsembleModel$.MODULE$.featureImportances$default$3());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.featureImportances;
    }

    public Vector featureImportances() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.featureImportances$lzycompute();
        }
        return this.featureImportances;
    }

    public RandomForestModel toOld() {
        return new RandomForestModel(Algo$.MODULE$.Classification(), (org.apache.spark.mllib.tree.model.DecisionTreeModel[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])this._trees()), (Function1 & Serializable)x$4 -> x$4.toOld(), ClassTag$.MODULE$.apply(org.apache.spark.mllib.tree.model.DecisionTreeModel.class)));
    }

    @Override
    public MLWriter write() {
        return new RandomForestClassificationModelWriter(this);
    }

    public void createSummary(Dataset<?> dataset) {
        String weightColName = !this.isDefined(this.weightCol()) ? "weightCol" : this.$(this.weightCol());
        Tuple3 tuple3 = this.findSummaryModel();
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        ProbabilisticClassificationModel summaryModel = (ProbabilisticClassificationModel)tuple3._1();
        String probabilityColName = (String)tuple3._2();
        String predictionColName = (String)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)summaryModel, (Object)probabilityColName, (Object)predictionColName);
        ProbabilisticClassificationModel summaryModel2 = (ProbabilisticClassificationModel)tuple32._1();
        String probabilityColName2 = (String)tuple32._2();
        String predictionColName2 = (String)tuple32._3();
        RandomForestClassificationSummaryImpl rfSummary = this.numClasses() <= 2 ? new BinaryRandomForestClassificationTrainingSummaryImpl(summaryModel2.transform(dataset), probabilityColName2, predictionColName2, this.$(this.labelCol()), weightColName, new double[]{0.0}) : new RandomForestClassificationTrainingSummaryImpl(summaryModel2.transform(dataset), predictionColName2, this.$(this.labelCol()), weightColName, new double[]{0.0});
        this.setSummary((Option<RandomForestClassificationTrainingSummary>)new Some((Object)rfSummary));
    }

    @Override
    public void saveSummary(String path) {
    }

    @Override
    public void loadSummary(String path, Dataset<Row> dataset) {
        this.createSummary(dataset);
    }

    public static final /* synthetic */ void $anonfun$predictRaw$1(RandomForestClassificationModel $this, Vector features$1, double[] votes$1, DecisionTreeClassificationModel tree) {
        double[] classCounts = tree.rootNode().predictImpl(features$1).impurityStats().stats();
        double total = BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.wrapDoubleArray(classCounts).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
        if (total != 0.0) {
            for (int i = 0; i < $this.numClasses(); ++i) {
                int n = i;
                votes$1[n] = votes$1[n] + classCounts[i] / total;
            }
            return;
        }
    }

    public RandomForestClassificationModel(String uid, DecisionTreeClassificationModel[] _trees, int numFeatures, int numClasses) {
        this.uid = uid;
        this._trees = _trees;
        this.numFeatures = numFeatures;
        this.numClasses = numClasses;
        HasCheckpointInterval.$init$(this);
        HasSeed.$init$(this);
        HasWeightCol.$init$(this);
        DecisionTreeParams.$init$(this);
        TreeEnsembleParams.$init$(this);
        RandomForestParams.$init$(this);
        TreeEnsembleClassifierParams.$init$(this);
        TreeClassifierParams.$init$(this);
        TreeEnsembleModel.$init$(this);
        MLWritable.$init$(this);
        HasTrainingSummary.$init$(this);
        Predef$.MODULE$.require(ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])_trees)), (Function0 & Serializable)() -> "RandomForestClassificationModel requires at least 1 tree.");
        Statics.releaseFence();
    }

    public RandomForestClassificationModel(DecisionTreeClassificationModel[] trees, int numFeatures, int numClasses) {
        this(Identifiable$.MODULE$.randomUID("rfc"), trees, numFeatures, numClasses);
    }

    public RandomForestClassificationModel() {
        this("", (DecisionTreeClassificationModel[])((Object[])new DecisionTreeClassificationModel[]{new DecisionTreeClassificationModel()}), -1, -1);
    }

    private static class RandomForestClassificationModelReader
    extends MLReader<RandomForestClassificationModel> {
        private final String className = RandomForestClassificationModel.class.getName();
        private final String treeClassName = DecisionTreeClassificationModel.class.getName();

        private String className() {
            return this.className;
        }

        private String treeClassName() {
            return this.treeClassName;
        }

        @Override
        public RandomForestClassificationModel load(String path) {
            DefaultParamsReader.Metadata metadata;
            Tuple2[] treesData;
            DefaultFormats$ format;
            block3: {
                Tuple3<DefaultParamsReader.Metadata, Tuple2<DefaultParamsReader.Metadata, Node>[], double[]> tuple3;
                block2: {
                    format = DefaultFormats$.MODULE$;
                    tuple3 = EnsembleModelReadWrite$.MODULE$.loadImpl(path, this.sparkSession(), this.className(), this.treeClassName());
                    if (tuple3 == null) break block2;
                    DefaultParamsReader.Metadata metadata2 = (DefaultParamsReader.Metadata)tuple3._1();
                    treesData = (Tuple2[])tuple3._2();
                    if (metadata2 == null) break block2;
                    metadata = metadata2;
                    if (treesData != null) break block3;
                }
                throw new MatchError(tuple3);
            }
            Tuple2[] tuple2Array = treesData;
            Tuple2 tuple2 = new Tuple2((Object)metadata, (Object)tuple2Array);
            DefaultParamsReader.Metadata metadata3 = (DefaultParamsReader.Metadata)tuple2._1();
            Tuple2[] treesData2 = (Tuple2[])tuple2._2();
            int numFeatures = BoxesRunTime.unboxToInt((Object)ExtractableJsonAstNode$.MODULE$.extract$extension(org.json4s.package$.MODULE$.jvalue2extractable(MonadicJValue$.MODULE$.$bslash$extension(org.json4s.package$.MODULE$.jvalue2monadic(metadata3.metadata()), "numFeatures")), (Formats)format, (Manifest)ManifestFactory$.MODULE$.Int()));
            int numClasses = BoxesRunTime.unboxToInt((Object)ExtractableJsonAstNode$.MODULE$.extract$extension(org.json4s.package$.MODULE$.jvalue2extractable(MonadicJValue$.MODULE$.$bslash$extension(org.json4s.package$.MODULE$.jvalue2monadic(metadata3.metadata()), "numClasses")), (Formats)format, (Manifest)ManifestFactory$.MODULE$.Int()));
            int numTrees = BoxesRunTime.unboxToInt((Object)ExtractableJsonAstNode$.MODULE$.extract$extension(org.json4s.package$.MODULE$.jvalue2extractable(MonadicJValue$.MODULE$.$bslash$extension(org.json4s.package$.MODULE$.jvalue2monadic(metadata3.metadata()), "numTrees")), (Formats)format, (Manifest)ManifestFactory$.MODULE$.Int()));
            DecisionTreeClassificationModel[] trees = (DecisionTreeClassificationModel[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])treesData2), (Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    DefaultParamsReader.Metadata treeMetadata = (DefaultParamsReader.Metadata)tuple2._1();
                    Node root = (Node)tuple2._2();
                    DecisionTreeClassificationModel tree = new DecisionTreeClassificationModel(treeMetadata.uid(), root, numFeatures, numClasses);
                    treeMetadata.getAndSetParams(tree, treeMetadata.getAndSetParams$default$2());
                    return tree;
                }
                throw new MatchError((Object)tuple2);
            }, ClassTag$.MODULE$.apply(DecisionTreeClassificationModel.class));
            Predef$.MODULE$.require(numTrees == trees.length, (Function0 & Serializable)() -> "RandomForestClassificationModel.load expected " + numTrees + " trees based on metadata but found " + trees.length + " trees.");
            RandomForestClassificationModel model = new RandomForestClassificationModel(metadata3.uid(), trees, numFeatures, numClasses);
            metadata3.getAndSetParams(model, metadata3.getAndSetParams$default$2());
            return model;
        }
    }

    public static class RandomForestClassificationModelWriter
    extends MLWriter {
        private final RandomForestClassificationModel instance;

        @Override
        public void saveImpl(String path) {
            JObject extraMetadata = JsonDSL$.MODULE$.map2jvalue((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numFeatures"), (Object)BoxesRunTime.boxToInteger((int)this.instance.numFeatures())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numClasses"), (Object)BoxesRunTime.boxToInteger((int)this.instance.numClasses())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numTrees"), (Object)BoxesRunTime.boxToInteger((int)this.instance.getNumTrees()))})), (Function1 & Serializable)x -> JsonDSL$.MODULE$.int2jvalue(BoxesRunTime.unboxToInt((Object)x)));
            EnsembleModelReadWrite$.MODULE$.saveImpl(this.instance, path, this.sparkSession(), extraMetadata);
        }

        public RandomForestClassificationModelWriter(RandomForestClassificationModel instance) {
            this.instance = instance;
        }
    }
}

