/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.textruler.learner.trabal;

import java.util.ArrayList;
import java.util.List;
import org.apache.uima.ruta.textruler.core.TextRulerRule;
import org.apache.uima.ruta.textruler.core.TextRulerStatisticsCollector;
import org.apache.uima.ruta.textruler.core.TextRulerTarget;
import org.apache.uima.ruta.textruler.learner.trabal.AnnotationErrorType;
import org.apache.uima.ruta.textruler.learner.trabal.Condition;
import org.apache.uima.ruta.textruler.learner.trabal.ConditionType;
import org.apache.uima.ruta.textruler.learner.trabal.TrabalAnnotation;
import org.apache.uima.ruta.textruler.learner.trabal.TrabalLearner;
import org.apache.uima.ruta.textruler.learner.trabal.TrabalRuleItem;

public abstract class TrabalRule
extends TextRulerRule
implements Comparable<TrabalRule> {
    protected TrabalAnnotation annotation;
    protected TrabalAnnotation targetAnnotation;
    protected float errorRate;
    protected AnnotationErrorType errorType;
    protected List<ConditionType> conditionTypes;
    protected List<Condition> conditions = new ArrayList<Condition>();
    protected int rating = 0;

    public TrabalRule(TrabalLearner parentAlgorithm, TextRulerTarget target) {
        super(parentAlgorithm, target);
    }

    @Override
    public void setCoveringStatistics(TextRulerStatisticsCollector c) {
        super.setCoveringStatistics(c);
        int p = c.getCoveredPositivesCount();
        int n = c.getCoveredNegativesCount();
        this.errorRate = p < 1 ? Float.MAX_VALUE : (float)n / (float)p;
    }

    public List<Condition> getConditions() {
        return this.conditions;
    }

    public void addCondition(Condition condition) {
        if (!this.conditions.contains(condition)) {
            this.conditions.add(condition);
        }
    }

    public void addCondition(Condition condition, int rating) {
        if (!this.conditions.contains(condition)) {
            this.conditions.add(condition);
            this.rating += rating;
        }
    }

    protected String parseConditions(List<ConditionType> types) {
        Object result = "";
        for (Condition each : this.conditions) {
            if (!types.contains((Object)each.getType())) continue;
            result = (String)result + String.valueOf(each) + ", ";
        }
        if (((String)result).length() > 0) {
            return ((String)result).substring(0, ((String)result).length() - 2);
        }
        return "";
    }

    protected String parseConditions(ConditionType type) {
        Object result = "";
        for (Condition each : this.conditions) {
            if (each.getType() != type) continue;
            result = (String)result + String.valueOf(each) + ", ";
        }
        if (((String)result).length() > 0) {
            return ((String)result).substring(0, ((String)result).length() - 2);
        }
        return "";
    }

    public float getErrorRate() {
        return this.errorRate;
    }

    public AnnotationErrorType getErrorType() {
        return this.errorType;
    }

    public TrabalAnnotation getAnnotation() {
        return this.annotation;
    }

    public TrabalAnnotation getTargetAnnotation() {
        return this.targetAnnotation;
    }

    public TrabalAnnotation getMatchingAnnotation() {
        switch (this.errorType) {
            case CORRECTION: 
            case DELETION: {
                return this.annotation;
            }
        }
        return this.targetAnnotation;
    }

    public int getRating() {
        return this.rating;
    }

    public void setRating(int rating) {
        this.rating = rating;
    }

    @Override
    public String toString() {
        Object result = "// " + String.valueOf(this.getAnnotation()) + " -> " + String.valueOf(this.getTargetAnnotation());
        result = ((String)result).replaceAll("\n", " ");
        result = ((String)result).replaceAll("\f", " ");
        result = ((String)result).replaceAll("\r", " ");
        result = ((String)result).replaceAll("\t", " ");
        result = (String)result + "\n";
        return (String)result + this.ruleString + "\t// " + String.valueOf(this.getCoveringStatistics()) + "\n\n";
    }

    @Override
    public int compareTo(TrabalRule obj) {
        if (this.rating < obj.getRating()) {
            return -1;
        }
        if (this.rating == obj.getRating()) {
            return 0;
        }
        return 1;
    }

    public String parseFeatures() {
        Object result = "";
        for (String key : this.targetAnnotation.getFeatures().keySet()) {
            result = (String)result + ", \"" + key + "\" = \"" + this.targetAnnotation.getFeatures().get(key) + "\"";
        }
        return result;
    }

    @Override
    public abstract void compileRuleString();

    public abstract boolean contains(TrabalAnnotation var1);

    public abstract boolean hasSameBasicRule(TrabalRule var1);

    public abstract TrabalRuleItem getFrontBoundary();

    public abstract TrabalRuleItem getRearBoundary();

    @Override
    public abstract TrabalRule copy();
}

